/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.web;

import java.net.URI;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationIdentityProviderProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.SecurityTokenTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.apereo.cas.ws.idp.web.WSFederationRequest;
import org.apereo.cas.ws.idp.web.WSFederationRequestConfigurationContext;
import org.jasig.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

@Controller
public abstract class BaseWSFederationRequestController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseWSFederationRequestController.class);
    private final WSFederationRequestConfigurationContext configContext;

    protected String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, WSFederationRequest wsfedRequest) throws Exception {
        URIBuilder builder = new URIBuilder(this.configContext.getCallbackService().getId());
        builder.addParameter("wa", wsfedRequest.getWa());
        builder.addParameter("wreply", wsfedRequest.getWreply());
        builder.addParameter("wtrealm", wsfedRequest.getWtrealm());
        if (StringUtils.isNotBlank((CharSequence)wsfedRequest.getWctx())) {
            builder.addParameter("wctx", wsfedRequest.getWctx());
        }
        if (StringUtils.isNotBlank((CharSequence)wsfedRequest.getWfresh())) {
            builder.addParameter("wfresh", wsfedRequest.getWfresh());
        }
        if (StringUtils.isNotBlank((CharSequence)wsfedRequest.getWhr())) {
            builder.addParameter("whr", wsfedRequest.getWhr());
        }
        if (StringUtils.isNotBlank((CharSequence)wsfedRequest.getWreq())) {
            builder.addParameter("wreq", wsfedRequest.getWreq());
        }
        URI url = builder.build();
        LOGGER.trace("Built service callback url [{}]", (Object)url);
        return CommonUtils.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)url.toString(), (String)this.configContext.getCasProperties().getServer().getName(), (String)"service", (String)"ticket", (boolean)false);
    }

    protected SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) {
        String sts;
        TicketGrantingTicket tgt;
        String cookieValue = this.configContext.getTicketGrantingTicketCookieGenerator().retrieveCookieValue(request);
        if (StringUtils.isNotBlank((CharSequence)cookieValue) && (tgt = (TicketGrantingTicket)this.configContext.getTicketRegistry().getTicket(cookieValue, TicketGrantingTicket.class)) != null && StringUtils.isNotBlank((CharSequence)(sts = (String)tgt.getDescendantTickets().stream().filter(t -> t.startsWith("STS")).findFirst().orElse(null)))) {
            SecurityTokenTicket stt = (SecurityTokenTicket)this.configContext.getTicketRegistry().getTicket(sts, SecurityTokenTicket.class);
            if (stt == null || stt.isExpired()) {
                LOGGER.warn("Security token ticket [{}] is not found or has expired", (Object)sts);
                return null;
            }
            if (stt.getSecurityToken() == null || stt.getSecurityToken().isExpired()) {
                LOGGER.warn("Security token linked to ticket [{}] has expired", (Object)sts);
                return null;
            }
            return stt.getSecurityToken();
        }
        return null;
    }

    protected boolean shouldRenewAuthentication(WSFederationRequest fedRequest, HttpServletRequest request) {
        Instant createdDate;
        if (StringUtils.isBlank((CharSequence)fedRequest.getWfresh()) || !NumberUtils.isCreatable((String)fedRequest.getWfresh())) {
            return false;
        }
        long ttl = Long.parseLong(fedRequest.getWfresh().trim());
        if (ttl == 0L) {
            return false;
        }
        SecurityToken idpToken = this.getSecurityTokenFromRequest(request);
        if (idpToken == null) {
            return true;
        }
        long ttlMs = TimeUnit.MINUTES.toMillis(ttl);
        if (ttlMs > 0L && (createdDate = idpToken.getCreated()) != null) {
            Date expiryDate = new Date(createdDate.toEpochMilli() + ttlMs);
            return expiryDate.before(new Date());
        }
        return false;
    }

    protected WSFederationRegisteredService findAndValidateFederationRequestForRegisteredService(Service targetService, WSFederationRequest fedRequest) {
        WSFederationRegisteredService svc = this.getWsFederationRegisteredService(targetService);
        if (StringUtils.isBlank((CharSequence)fedRequest.getWtrealm()) || !StringUtils.equals((CharSequence)fedRequest.getWtrealm(), (CharSequence)svc.getRealm())) {
            LOGGER.warn("Realm [{}] is not authorized for matching service [{}]", (Object)fedRequest.getWtrealm(), (Object)svc);
            throw new UnauthorizedServiceException("screen.service.error.message", "");
        }
        WsFederationIdentityProviderProperties idp = this.configContext.getCasProperties().getAuthn().getWsfedIdp().getIdp();
        if (!StringUtils.equals((CharSequence)idp.getRealm(), (CharSequence)svc.getRealm())) {
            LOGGER.warn("Realm [{}] is not authorized for the identity provider realm [{}]", (Object)fedRequest.getWtrealm(), (Object)idp.getRealm());
            throw new UnauthorizedServiceException("screen.service.error.message", "");
        }
        return svc;
    }

    protected WSFederationRegisteredService getWsFederationRegisteredService(Service targetService) {
        WSFederationRegisteredService svc = (WSFederationRegisteredService)this.configContext.getServicesManager().findServiceBy(targetService, WSFederationRegisteredService.class);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)targetService, (RegisteredService)svc);
        return svc;
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleUnauthorizedServiceException(HttpServletRequest req, Exception ex) {
        return WebUtils.produceUnauthorizedErrorView((Exception)ex);
    }

    @Generated
    public WSFederationRequestConfigurationContext getConfigContext() {
        return this.configContext;
    }

    @Generated
    protected BaseWSFederationRequestController(WSFederationRequestConfigurationContext configContext) {
        this.configContext = configContext;
    }
}

