/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.web;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.SecurityTokenTicket;
import org.apereo.cas.ticket.SecurityTokenTicketFactory;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.apereo.cas.ws.idp.web.BaseWSFederationRequestController;
import org.apereo.cas.ws.idp.web.WSFederationRequest;
import org.apereo.cas.ws.idp.web.WSFederationRequestConfigurationContext;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;

public class WSFederationValidateRequestCallbackController
extends BaseWSFederationRequestController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WSFederationValidateRequestCallbackController.class);

    public WSFederationValidateRequestCallbackController(WSFederationRequestConfigurationContext configurationContext) {
        super(configurationContext);
    }

    private static ModelAndView postResponseBackToRelyingParty(String rpToken, WSFederationRequest fedRequest) {
        String postUrl = StringUtils.isNotBlank((CharSequence)fedRequest.getWreply()) ? fedRequest.getWreply() : fedRequest.getWtrealm();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("wa", "wsignin1.0");
        parameters.put("wresult", StringEscapeUtils.unescapeHtml4((String)rpToken));
        parameters.put("wtrealm", fedRequest.getWtrealm());
        if (StringUtils.isNotBlank((CharSequence)fedRequest.getWctx())) {
            parameters.put("wctx", fedRequest.getWctx());
        }
        LOGGER.trace("Posting relying party token to [{}]", (Object)postUrl);
        return new ModelAndView("casPostResponseView", CollectionUtils.wrap((String)"originalUrl", (Object)postUrl, (String)"parameters", parameters));
    }

    @GetMapping(path={"/ws/idp/federationcallback"})
    protected ModelAndView handleFederationRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        WSFederationRequest fedRequest = WSFederationRequest.of(request);
        LOGGER.debug("Received callback profile request [{}]", (Object)request.getRequestURI());
        String serviceUrl = this.constructServiceUrl(request, response, fedRequest);
        Service targetService = this.getConfigContext().getServiceSelectionStrategy().resolveServiceFrom(this.getConfigContext().getWebApplicationServiceFactory().createService(serviceUrl));
        targetService.getAttributes().put("wreply", CollectionUtils.wrapList((Object[])new Object[]{fedRequest.getWreply()}));
        targetService.getAttributes().put("wtrealm", CollectionUtils.wrapList((Object[])new Object[]{fedRequest.getWtrealm()}));
        targetService.getAttributes().put("wctx", CollectionUtils.wrapList((Object[])new Object[]{fedRequest.getWctx()}));
        WSFederationRegisteredService service = this.findAndValidateFederationRequestForRegisteredService(targetService, fedRequest);
        LOGGER.debug("Located matching service [{}]", (Object)service);
        String ticket = request.getParameter("ticket");
        if (StringUtils.isBlank((CharSequence)ticket)) {
            LOGGER.error("Can not validate the request because no [{}] is provided via the request", (Object)"ticket");
            return new ModelAndView("error", new HashMap(0), HttpStatus.FORBIDDEN);
        }
        Assertion assertion = this.validateRequestAndBuildCasAssertion(response, request, fedRequest);
        SecurityToken securityTokenReq = this.getSecurityTokenFromRequest(request);
        SecurityToken securityToken = (SecurityToken)FunctionUtils.doIfNull((Object)securityTokenReq, () -> {
            LOGGER.debug("No security token is yet available. Invoking security token service to issue token");
            return this.fetchSecurityTokenFromAssertion(assertion, targetService);
        }, () -> securityTokenReq).get();
        this.addSecurityTokenTicketToRegistry(request, securityToken);
        String rpToken = this.produceRelyingPartyToken(request, targetService, fedRequest, securityToken, assertion);
        return WSFederationValidateRequestCallbackController.postResponseBackToRelyingParty(rpToken, fedRequest);
    }

    private SecurityToken fetchSecurityTokenFromAssertion(Assertion assertion, Service targetService) {
        String principal = assertion.getPrincipal().getName();
        Optional token = this.getConfigContext().getSecurityTokenServiceTokenFetcher().fetch(targetService, principal);
        if (token.isEmpty()) {
            LOGGER.warn("No security token could be retrieved for service [{}] and principal [{}]", (Object)targetService, (Object)principal);
            throw new UnauthorizedServiceException("screen.service.error.message");
        }
        return (SecurityToken)token.get();
    }

    private void addSecurityTokenTicketToRegistry(HttpServletRequest request, SecurityToken securityToken) throws Exception {
        LOGGER.trace("Creating security token as a ticket to CAS ticket registry...");
        TicketRegistry ticketRegistry = this.getConfigContext().getTicketRegistry();
        TicketGrantingTicket tgt = CookieUtils.getTicketGrantingTicketFromRequest((CasCookieBuilder)this.getConfigContext().getTicketGrantingTicketCookieGenerator(), (TicketRegistry)ticketRegistry, (HttpServletRequest)request);
        byte[] serializedToken = SerializationUtils.serialize((Serializable)securityToken);
        SecurityTokenTicketFactory securityTokenTicketFactory = (SecurityTokenTicketFactory)this.getConfigContext().getTicketFactory().get(SecurityTokenTicket.class);
        SecurityTokenTicket ticket = securityTokenTicketFactory.create(tgt, serializedToken);
        LOGGER.trace("Created security token ticket [{}]", (Object)ticket);
        ticketRegistry.addTicket((Ticket)ticket);
        LOGGER.trace("Added security token as a ticket to CAS ticket registry...");
        ticketRegistry.updateTicket((Ticket)tgt);
    }

    private String produceRelyingPartyToken(HttpServletRequest request, Service targetService, WSFederationRequest fedRequest, SecurityToken securityToken, Assertion assertion) throws Exception {
        WSFederationRegisteredService service = this.findAndValidateFederationRequestForRegisteredService(targetService, fedRequest);
        LOGGER.debug("Located registered service [{}] to create relying-party tokens...", (Object)service);
        return this.getConfigContext().getRelyingPartyTokenProducer().produce(securityToken, service, fedRequest, request, assertion);
    }

    private Assertion validateRequestAndBuildCasAssertion(HttpServletResponse response, HttpServletRequest request, WSFederationRequest fedRequest) throws Exception {
        String ticket = request.getParameter("ticket");
        String serviceUrl = this.constructServiceUrl(request, response, fedRequest);
        LOGGER.trace("Created service url for validation: [{}]", (Object)serviceUrl);
        Assertion assertion = this.getConfigContext().getTicketValidator().validate(ticket, serviceUrl);
        LOGGER.debug("Located CAS assertion [{}]", (Object)assertion);
        return assertion;
    }
}

