/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategyConfigurer;
import org.apereo.cas.authentication.SecurityTokenServiceClientBuilder;
import org.apereo.cas.authentication.SecurityTokenServiceTokenFetcher;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketValidator;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.InternalTicketValidator;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.ws.idp.authentication.WSFederationAuthenticationServiceSelectionStrategy;
import org.apereo.cas.ws.idp.metadata.WSFederationMetadataController;
import org.apereo.cas.ws.idp.services.DefaultRelyingPartyTokenProducer;
import org.apereo.cas.ws.idp.services.WSFederationRelyingPartyTokenProducer;
import org.apereo.cas.ws.idp.services.WSFederationServiceRegistry;
import org.apereo.cas.ws.idp.services.WsFederationServicesManagerRegisteredServiceLocator;
import org.apereo.cas.ws.idp.web.WSFederationRequestConfigurationContext;
import org.apereo.cas.ws.idp.web.WSFederationValidateRequestCallbackController;
import org.apereo.cas.ws.idp.web.WSFederationValidateRequestController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ImportResource(locations={"classpath:META-INF/cxf/cxf.xml"})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.WsFederationIdentityProvider)
@AutoConfiguration
public class CoreWsSecurityIdentityProviderConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreWsSecurityIdentityProviderConfiguration.class);

    @Configuration(value="CoreWsSecurityIdentityProviderControllersConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecurityIdentityProviderControllersConfiguration {
        @ConditionalOnMissingBean(name={"federationValidateRequestController"})
        @Bean
        public WSFederationValidateRequestController federationValidateRequestController(@Qualifier(value="wsFederationConfigurationContext") WSFederationRequestConfigurationContext wsFederationConfigurationContext) {
            return new WSFederationValidateRequestController(wsFederationConfigurationContext);
        }

        @Bean
        public WSFederationValidateRequestCallbackController federationValidateRequestCallbackController(@Qualifier(value="wsFederationConfigurationContext") WSFederationRequestConfigurationContext wsFederationConfigurationContext) {
            return new WSFederationValidateRequestCallbackController(wsFederationConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WSFederationMetadataController wsFederationMetadataController(CasConfigurationProperties casProperties) {
            return new WSFederationMetadataController(casProperties);
        }
    }

    @Configuration(value="CoreWsSecurityIdentityProviderContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecurityIdentityProviderContextConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WSFederationRequestConfigurationContext wsFederationConfigurationContext(@Qualifier(value="wsFederationRelyingPartyTokenProducer") WSFederationRelyingPartyTokenProducer wsFederationRelyingPartyTokenProducer, @Qualifier(value="noRedirectHttpClient") HttpClient httpClient, @Qualifier(value="wsFederationAuthenticationServiceSelectionStrategy") AuthenticationServiceSelectionStrategy wsFederationAuthenticationServiceSelectionStrategy, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="wsFederationCallbackService") Service wsFederationCallbackService, @Qualifier(value="securityTokenServiceTokenFetcher") SecurityTokenServiceTokenFetcher securityTokenServiceTokenFetcher, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="wsFederationTicketValidator") TicketValidator wsFederationTicketValidator, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, CasConfigurationProperties casProperties) {
            return ((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)((WSFederationRequestConfigurationContext.WSFederationRequestConfigurationContextBuilder)WSFederationRequestConfigurationContext.builder().servicesManager(servicesManager)).relyingPartyTokenProducer(wsFederationRelyingPartyTokenProducer)).webApplicationServiceFactory(webApplicationServiceFactory)).casProperties(casProperties)).ticketValidator(wsFederationTicketValidator)).securityTokenServiceTokenFetcher(securityTokenServiceTokenFetcher)).serviceSelectionStrategy(wsFederationAuthenticationServiceSelectionStrategy)).httpClient(httpClient)).ticketFactory(ticketFactory)).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator)).ticketRegistry(ticketRegistry)).ticketRegistrySupport(ticketRegistrySupport)).callbackService(wsFederationCallbackService)).build();
        }
    }

    @Configuration(value="CoreWsSecurityIdentityProviderTicketsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecurityIdentityProviderTicketsConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"wsFederationRelyingPartyTokenProducer"})
        public WSFederationRelyingPartyTokenProducer wsFederationRelyingPartyTokenProducer(@Qualifier(value="securityTokenServiceCredentialCipherExecutor") CipherExecutor securityTokenServiceCredentialCipherExecutor, @Qualifier(value="securityTokenServiceClientBuilder") SecurityTokenServiceClientBuilder securityTokenServiceClientBuilder, CasConfigurationProperties casProperties) {
            return new DefaultRelyingPartyTokenProducer(securityTokenServiceClientBuilder, (CipherExecutor<String, String>)securityTokenServiceCredentialCipherExecutor, new HashSet<String>(casProperties.getAuthn().getWsfedIdp().getSts().getCustomClaims()));
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"wsFederationTicketValidator"})
        public TicketValidator wsFederationTicketValidator(@Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new InternalTicketValidator(centralAuthenticationService, webApplicationServiceFactory, authenticationAttributeReleasePolicy, servicesManager);
        }
    }

    @Configuration(value="CoreWsSecurityIdentityProviderServicesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecurityIdentityProviderServicesConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"wsFederationServicesManagerRegisteredServiceLocator"})
        public ServicesManagerRegisteredServiceLocator wsFederationServicesManagerRegisteredServiceLocator() {
            return new WsFederationServicesManagerRegisteredServiceLocator();
        }

        @Bean
        public Service wsFederationCallbackService(@Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
            return webApplicationServiceFactory.createService("/ws/idp/federationcallback");
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"wsFederationServiceRegistryExecutionPlanConfigurer"})
        public ServiceRegistryExecutionPlanConfigurer wsFederationServiceRegistryExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="wsFederationCallbackService") Service wsFederationCallbackService) {
            return plan -> {
                LOGGER.debug("Initializing WS Federation callback service [{}]", (Object)wsFederationCallbackService);
                CasRegisteredService service = new CasRegisteredService();
                service.setId(RandomUtils.nextLong());
                service.setEvaluationOrder(Integer.MIN_VALUE);
                service.setName(service.getClass().getSimpleName());
                service.setDescription("WS-Federation Authentication Request");
                service.setServiceId(wsFederationCallbackService.getId().concat(".+"));
                LOGGER.debug("Saving callback service [{}] into the registry", (Object)service.getServiceId());
                plan.registerServiceRegistry((ServiceRegistry)new WSFederationServiceRegistry(applicationContext, new RegisteredService[]{service}));
            };
        }
    }

    @Configuration(value="CoreWsSecurityIdentityProviderServiceSelectionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecurityIdentityProviderServiceSelectionPlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"wsFederationAuthenticationServiceSelectionStrategyConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationServiceSelectionStrategyConfigurer wsFederationAuthenticationServiceSelectionStrategyConfigurer(@Qualifier(value="wsFederationAuthenticationServiceSelectionStrategy") AuthenticationServiceSelectionStrategy wsFederationAuthenticationServiceSelectionStrategy) {
            return plan -> plan.registerStrategy(wsFederationAuthenticationServiceSelectionStrategy);
        }
    }

    @Configuration(value="CoreWsSecurityIdentityProviderServiceSelectionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecurityIdentityProviderServiceSelectionConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"wsFederationAuthenticationServiceSelectionStrategy"})
        public AuthenticationServiceSelectionStrategy wsFederationAuthenticationServiceSelectionStrategy(@Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new WSFederationAuthenticationServiceSelectionStrategy(servicesManager, webApplicationServiceFactory);
        }
    }

    @Configuration(value="CoreWsSecurityIdentityProviderWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecurityIdentityProviderWebConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ProtocolEndpointWebSecurityConfigurer<Void> wsFederationProtocolEndpointConfigurer() {
            return new ProtocolEndpointWebSecurityConfigurer<Void>(){

                public List<String> getIgnoredEndpoints() {
                    return List.of(StringUtils.prependIfMissing((String)"/ws/idp", (CharSequence)"/", (CharSequence[])new CharSequence[0]), StringUtils.prependIfMissing((String)"/ws/sts/", (CharSequence)"/", (CharSequence[])new CharSequence[0]));
                }
            };
        }
    }
}

