/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.SecurityTokenServiceClient;
import org.apereo.cas.authentication.SecurityTokenServiceClientBuilder;
import org.apereo.cas.authentication.SecurityTokenServiceTokenFetcher;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedSsoServiceException;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecurityTokenServiceTokenFetcher
implements SecurityTokenServiceTokenFetcher {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSecurityTokenServiceTokenFetcher.class);
    private final ServicesManager servicesManager;
    private final AuthenticationServiceSelectionStrategy selectionStrategy;
    private final CipherExecutor<String, String> credentialCipherExecutor;
    private final SecurityTokenServiceClientBuilder clientBuilder;

    @Override
    public Optional<SecurityToken> fetch(Service service, String principalId) {
        Service resolvedService = this.selectionStrategy.resolveServiceFrom(service);
        LOGGER.debug("Resolved service as [{}]", (Object)resolvedService);
        if (resolvedService != null) {
            WSFederationRegisteredService rp = (WSFederationRegisteredService)this.servicesManager.findServiceBy(resolvedService, WSFederationRegisteredService.class);
            if (rp == null || !rp.getAccessStrategy().isServiceAccessAllowed()) {
                LOGGER.warn("Service [{}] is not allowed to use SSO.", (Object)rp);
                throw new UnauthorizedSsoServiceException();
            }
            LOGGER.debug("Building security token service client for registered service [{}]", (Object)rp);
            SecurityTokenServiceClient sts = this.clientBuilder.buildClientForSecurityTokenRequests(rp);
            return Optional.ofNullable(this.invokeSecurityTokenServiceForToken(rp, sts, principalId));
        }
        return Optional.empty();
    }

    private SecurityToken invokeSecurityTokenServiceForToken(WSFederationRegisteredService rp, SecurityTokenServiceClient sts, String principalId) {
        try {
            Map properties = sts.getProperties();
            properties.put("security.username", principalId);
            String uid = (String)this.credentialCipherExecutor.encode((Object)principalId);
            properties.put("security.password", uid);
            LOGGER.debug("Requesting security token for principal [{}] and registered service [{}]", (Object)uid, (Object)rp);
            return sts.requestSecurityToken(rp.getAppliesTo());
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new AuthenticationException(e.getMessage());
        }
    }

    @Generated
    public DefaultSecurityTokenServiceTokenFetcher(ServicesManager servicesManager, AuthenticationServiceSelectionStrategy selectionStrategy, CipherExecutor<String, String> credentialCipherExecutor, SecurityTokenServiceClientBuilder clientBuilder) {
        this.servicesManager = servicesManager;
        this.selectionStrategy = selectionStrategy;
        this.credentialCipherExecutor = credentialCipherExecutor;
        this.clientBuilder = clientBuilder;
    }

    @Generated
    public String toString() {
        return "DefaultSecurityTokenServiceTokenFetcher(super=" + super.toString() + ", servicesManager=" + this.servicesManager + ", selectionStrategy=" + this.selectionStrategy + ", credentialCipherExecutor=" + this.credentialCipherExecutor + ", clientBuilder=" + this.clientBuilder + ")";
    }
}

