/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.claims;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apereo.cas.support.claims.WrappingSecurityTokenServiceClaimsHandler;

public class NonWSFederationClaimsClaimsHandler
extends WrappingSecurityTokenServiceClaimsHandler {
    public NonWSFederationClaimsClaimsHandler(String handlerRealm, String issuer) {
        super(handlerRealm, issuer);
    }

    @Override
    protected String createProcessedClaimType(Claim requestClaim, ClaimsParameters parameters) {
        String tokenType = parameters.getTokenRequirements().getTokenType();
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equalsIgnoreCase(tokenType)) {
            return StringUtils.remove((String)requestClaim.getClaimType(), (String)"http://www.yale.edu/tp/cas/");
        }
        return requestClaim.getClaimType();
    }

    @Override
    public List<String> getSupportedClaimTypes() {
        return new NonWSFederationClaimsList();
    }

    private static class NonWSFederationClaimsList
    extends ArrayList<String> {
        private static final long serialVersionUID = -50278523307446738L;

        private NonWSFederationClaimsList() {
        }

        @Override
        public boolean contains(Object o) {
            return o.toString().startsWith("http://www.yale.edu/tp/cas/");
        }
    }
}

