/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.BaseTicketCatalogConfigurer;
import org.apereo.cas.ticket.DefaultSecurityTokenTicket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.TicketDefinitionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(value="CasWsSecurityTokenTicketCatalogConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasWsSecurityTokenTicketCatalogConfiguration
extends BaseTicketCatalogConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasWsSecurityTokenTicketCatalogConfiguration.class);

    public void configureTicketCatalog(TicketCatalog plan, CasConfigurationProperties casProperties) {
        LOGGER.debug("Registering core WS security token ticket definitions...");
        TicketDefinition definition = this.buildTicketDefinition(plan, "STS", DefaultSecurityTokenTicket.class, Integer.MIN_VALUE);
        TicketDefinitionProperties properties = definition.getProperties();
        properties.setStorageName("wsSecurityTokenTicketsCache");
        properties.setStorageTimeout(casProperties.getTicket().getTgt().getPrimary().getMaxTimeToLiveInSeconds());
        this.registerTicketDefinition(plan, definition);
    }
}

