/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.sts.RealmParser;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.StaticSTSProperties;
import org.apache.cxf.sts.claims.ClaimsAttributeStatementProvider;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.ClaimsManager;
import org.apache.cxf.sts.event.STSEventListener;
import org.apache.cxf.sts.event.map.EventMapper;
import org.apache.cxf.sts.event.map.MapEventListener;
import org.apache.cxf.sts.event.map.MapEventLogger;
import org.apache.cxf.sts.operation.TokenIssueOperation;
import org.apache.cxf.sts.operation.TokenValidateOperation;
import org.apache.cxf.sts.service.StaticService;
import org.apache.cxf.sts.token.delegation.SAMLDelegationHandler;
import org.apache.cxf.sts.token.delegation.TokenDelegationHandler;
import org.apache.cxf.sts.token.provider.ConditionsProvider;
import org.apache.cxf.sts.token.provider.DefaultConditionsProvider;
import org.apache.cxf.sts.token.provider.DefaultSubjectProvider;
import org.apache.cxf.sts.token.provider.SAMLTokenProvider;
import org.apache.cxf.sts.token.provider.SCTProvider;
import org.apache.cxf.sts.token.provider.SubjectProvider;
import org.apache.cxf.sts.token.provider.TokenProvider;
import org.apache.cxf.sts.token.provider.jwt.JWTTokenProvider;
import org.apache.cxf.sts.token.realm.RealmProperties;
import org.apache.cxf.sts.token.realm.Relationship;
import org.apache.cxf.sts.token.validator.SAMLTokenValidator;
import org.apache.cxf.sts.token.validator.SCTValidator;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.X509TokenValidator;
import org.apache.cxf.sts.token.validator.jwt.JWTTokenValidator;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.apache.cxf.ws.security.sts.provider.SecurityTokenServiceProvider;
import org.apache.cxf.ws.security.sts.provider.operation.IssueOperation;
import org.apache.cxf.ws.security.sts.provider.operation.ValidateOperation;
import org.apache.cxf.ws.security.tokenstore.MemoryTokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.wss4j.dom.validate.Validator;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.authentication.DefaultSecurityTokenServiceTokenFetcher;
import org.apereo.cas.authentication.SecurityTokenServiceClientBuilder;
import org.apereo.cas.authentication.SecurityTokenServiceTokenFetcher;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationIdentityProviderProperties;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationSecurityTokenServiceProperties;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationSecurityTokenServiceRealmProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.claims.CustomNamespaceWSFederationClaimsClaimsHandler;
import org.apereo.cas.support.claims.NonWSFederationClaimsClaimsHandler;
import org.apereo.cas.support.claims.WrappingSecurityTokenServiceClaimsHandler;
import org.apereo.cas.support.realm.RealmPasswordVerificationCallbackHandler;
import org.apereo.cas.support.realm.UriRealmParser;
import org.apereo.cas.support.util.CryptoUtils;
import org.apereo.cas.support.validation.CipheredCredentialsValidator;
import org.apereo.cas.support.validation.SecurityTokenServiceCredentialCipherExecutor;
import org.apereo.cas.support.x509.X509TokenDelegationHandler;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ImportResource(locations={"classpath:jaxws-realms.xml"})
@Configuration(value="CoreWsSecuritySecurityTokenServiceConfiguration", proxyBeanMethods=false)
public class CoreWsSecuritySecurityTokenServiceConfiguration {

    @Configuration(value="CoreWsSecuritySecurityTokenServiceClaimsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecuritySecurityTokenServiceClaimsConfiguration {
        @ConditionalOnMissingBean(name={"wrappingSecurityTokenServiceClaimsHandler"})
        @Bean
        public ClaimsHandler wrappingSecurityTokenServiceClaimsHandler(CasConfigurationProperties casProperties) {
            WsFederationSecurityTokenServiceProperties wsfed = casProperties.getAuthn().getWsfedIdp().getSts();
            WsFederationIdentityProviderProperties idp = casProperties.getAuthn().getWsfedIdp().getIdp();
            return new WrappingSecurityTokenServiceClaimsHandler(idp.getRealmName(), wsfed.getRealm().getIssuer());
        }

        @ConditionalOnMissingBean(name={"nonWSFederationClaimsClaimsHandler"})
        @Bean
        public ClaimsHandler nonWSFederationClaimsClaimsHandler(CasConfigurationProperties casProperties) {
            WsFederationSecurityTokenServiceProperties wsfed = casProperties.getAuthn().getWsfedIdp().getSts();
            WsFederationIdentityProviderProperties idp = casProperties.getAuthn().getWsfedIdp().getIdp();
            return new NonWSFederationClaimsClaimsHandler(idp.getRealmName(), wsfed.getRealm().getIssuer());
        }

        @ConditionalOnMissingBean(name={"customNamespaceWSFederationClaimsClaimsHandler"})
        @Bean
        public ClaimsHandler customNamespaceWSFederationClaimsClaimsHandler(CasConfigurationProperties casProperties) {
            WsFederationSecurityTokenServiceProperties wsfed = casProperties.getAuthn().getWsfedIdp().getSts();
            WsFederationIdentityProviderProperties idp = casProperties.getAuthn().getWsfedIdp().getIdp();
            return new CustomNamespaceWSFederationClaimsClaimsHandler(idp.getRealmName(), wsfed.getRealm().getIssuer(), wsfed.getCustomClaims());
        }

        @ConditionalOnMissingBean(name={"wsfedClaimsHandlers"})
        @Bean
        public List<ClaimsHandler> wsfedClaimsHandlers(@Qualifier(value="wrappingSecurityTokenServiceClaimsHandler") ClaimsHandler wrappingSecurityTokenServiceClaimsHandler, @Qualifier(value="nonWSFederationClaimsClaimsHandler") ClaimsHandler nonWSFederationClaimsClaimsHandler, @Qualifier(value="customNamespaceWSFederationClaimsClaimsHandler") ClaimsHandler customNamespaceWSFederationClaimsClaimsHandler) {
            return CollectionUtils.wrapList((Object[])new ClaimsHandler[]{wrappingSecurityTokenServiceClaimsHandler, nonWSFederationClaimsClaimsHandler, customNamespaceWSFederationClaimsClaimsHandler});
        }

        @ConditionalOnMissingBean(name={"wsfedClaimsManager"})
        @Bean
        public ClaimsManager wsfedClaimsManager(@Qualifier(value="wsfedClaimsHandlers") List<ClaimsHandler> wsfedClaimsHandlers) {
            ClaimsManager claimsManager = new ClaimsManager();
            claimsManager.setClaimHandlers(wsfedClaimsHandlers);
            return claimsManager;
        }
    }

    @Configuration(value="CoreWsSecuritySecurityTokenServiceWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecuritySecurityTokenServiceWebConfiguration {
        @ConditionalOnMissingBean(name={"cxfServlet"})
        @Bean
        public ServletRegistrationBean<CXFServlet> cxfServlet() {
            ServletRegistrationBean bean = new ServletRegistrationBean();
            bean.setEnabled(true);
            bean.setName("cxfServletSecurityTokenService");
            bean.setServlet((Servlet)new CXFServlet());
            bean.setUrlMappings((Collection)CollectionUtils.wrap((Object)"/ws/sts/".concat("*")));
            bean.setAsyncSupported(true);
            return bean;
        }

        @ConditionalOnMissingBean(name={"loggerListener"})
        @Bean
        public EventMapper loggerListener() {
            return new EventMapper((MapEventListener)new MapEventLogger());
        }
    }

    @Configuration(value="CoreWsSecuritySecurityTokenServiceTransportConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecuritySecurityTokenServiceTransportConfiguration {
        @ConditionalOnMissingBean(name={"transportSTSProviderBean"})
        @Bean
        public SecurityTokenServiceProvider transportSTSProviderBean(@Qualifier(value="transportIssueDelegate") IssueOperation transportIssueDelegate, @Qualifier(value="transportValidateDelegate") ValidateOperation transportValidateDelegate) throws Exception {
            SecurityTokenServiceProvider provider = new SecurityTokenServiceProvider();
            provider.setIssueOperation(transportIssueDelegate);
            provider.setValidateOperation(transportValidateDelegate);
            return provider;
        }

        @ConditionalOnMissingBean(name={"securityTokenServiceTokenStore"})
        @Bean
        public TokenStore securityTokenServiceTokenStore() {
            return new MemoryTokenStore();
        }

        @ConditionalOnMissingBean(name={"transportValidateDelegate"})
        @Bean
        public ValidateOperation transportValidateDelegate(List<TokenValidator> transportTokenValidators, @Qualifier(value="transportSTSProperties") STSPropertiesMBean transportSTSProperties, @Qualifier(value="loggerListener") EventMapper loggerListener) {
            TokenValidateOperation op = new TokenValidateOperation();
            op.setTokenValidators(transportTokenValidators);
            op.setStsProperties(transportSTSProperties);
            op.setEventListener((STSEventListener)loggerListener);
            return op;
        }

        @ConditionalOnMissingBean(name={"securityTokenServiceCredentialCipherExecutor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CipherExecutor securityTokenServiceCredentialCipherExecutor(CasConfigurationProperties casProperties) {
            EncryptionJwtSigningJwtCryptographyProperties crypto = casProperties.getAuthn().getWsfedIdp().getSts().getCrypto();
            return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, SecurityTokenServiceCredentialCipherExecutor.class);
        }

        @ConditionalOnMissingBean(name={"transportUsernameTokenValidator"})
        @Bean
        public Validator transportUsernameTokenValidator(@Qualifier(value="securityTokenServiceCredentialCipherExecutor") CipherExecutor securityTokenServiceCredentialCipherExecutor) {
            return new CipheredCredentialsValidator(securityTokenServiceCredentialCipherExecutor);
        }

        @ConditionalOnMissingBean(name={"transportService"})
        @Bean
        public StaticService transportService() {
            StaticService s = new StaticService();
            s.setEndpoints(CollectionUtils.wrap((Object)".*"));
            return s;
        }

        @ConditionalOnMissingBean(name={"transportSTSProperties"})
        @Bean
        public STSPropertiesMBean transportSTSProperties(CasConfigurationProperties casProperties, @Qualifier(value="securityTokenServiceRealms") Map<String, RealmProperties> securityTokenServiceRealms) {
            WsFederationSecurityTokenServiceProperties wsfed = casProperties.getAuthn().getWsfedIdp().getSts();
            WsFederationIdentityProviderProperties idp = casProperties.getAuthn().getWsfedIdp().getIdp();
            StaticSTSProperties s = new StaticSTSProperties();
            s.setIssuer(this.getClass().getSimpleName());
            s.setRealmParser((RealmParser)new UriRealmParser(securityTokenServiceRealms));
            s.setSignatureCryptoProperties((Object)CryptoUtils.getSecurityProperties((String)wsfed.getSigningKeystoreFile(), (String)wsfed.getSigningKeystorePassword()));
            s.setEncryptionCryptoProperties((Object)CryptoUtils.getSecurityProperties((String)wsfed.getEncryptionKeystoreFile(), (String)wsfed.getEncryptionKeystorePassword()));
            Relationship rel = new Relationship();
            rel.setType("FederatedIdentity");
            rel.setSourceRealm(idp.getRealmName());
            rel.setTargetRealm(idp.getRealmName());
            s.setRelationships(CollectionUtils.wrap((Object)rel));
            return s;
        }
    }

    @Configuration(value="CoreWsSecuritySecurityTokenServiceValidatorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecuritySecurityTokenServiceValidatorConfiguration {
        @ConditionalOnMissingBean(name={"transportSamlTokenValidator"})
        @Bean
        public TokenValidator transportSamlTokenValidator() {
            return new SAMLTokenValidator();
        }

        @ConditionalOnMissingBean(name={"transportJwtTokenValidator"})
        @Bean
        public TokenValidator transportJwtTokenValidator() {
            return new JWTTokenValidator();
        }

        @ConditionalOnMissingBean(name={"transportSecureContextTokenValidator"})
        @Bean
        public TokenValidator transportSecureContextTokenValidator() {
            return new SCTValidator();
        }

        @ConditionalOnMissingBean(name={"transportX509TokenValidator"})
        @Bean
        public TokenValidator transportX509TokenValidator() {
            return new X509TokenValidator();
        }
    }

    @Configuration(value="CoreWsSecuritySecurityTokenServiceRealmsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecuritySecurityTokenServiceRealmsConfiguration {
        @ConditionalOnMissingBean(name={"casRealm"})
        @Bean
        public RealmProperties casRealm(CasConfigurationProperties casProperties) {
            WsFederationSecurityTokenServiceProperties wsfed = casProperties.getAuthn().getWsfedIdp().getSts();
            WsFederationSecurityTokenServiceRealmProperties realmConfig = wsfed.getRealm();
            RealmProperties realm = new RealmProperties();
            String issuer = realmConfig.getIssuer();
            if (StringUtils.isBlank((CharSequence)issuer)) {
                throw new BeanCreationException("Realm issuer for the secure token service cannot be undefined");
            }
            realm.setIssuer(issuer);
            if (StringUtils.isBlank((CharSequence)realmConfig.getKeystoreFile()) || StringUtils.isBlank((CharSequence)realmConfig.getKeyPassword()) || StringUtils.isBlank((CharSequence)realmConfig.getKeystoreAlias())) {
                throw new BeanCreationException("Keystore file, password or alias assigned to the realm must be defined");
            }
            Properties p = CryptoUtils.getSecurityProperties((String)realmConfig.getKeystoreFile(), (String)realmConfig.getKeystorePassword(), (String)realmConfig.getKeystoreAlias());
            realm.setSignatureCryptoProperties((Object)p);
            realm.setCallbackHandler((CallbackHandler)new RealmPasswordVerificationCallbackHandler(realmConfig.getKeyPassword()));
            return realm;
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"securityTokenServiceRealms"})
        public Map<String, RealmProperties> securityTokenServiceRealms(CasConfigurationProperties casProperties, @Qualifier(value="casRealm") RealmProperties casRealm) {
            WsFederationIdentityProviderProperties idp = casProperties.getAuthn().getWsfedIdp().getIdp();
            HashMap<String, RealmProperties> realms = new HashMap<String, RealmProperties>();
            realms.put(idp.getRealmName(), casRealm);
            return realms;
        }
    }

    @Configuration(value="CoreWsSecuritySecurityTokenServiceClientConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecuritySecurityTokenServiceClientConfiguration {
        @ConditionalOnMissingBean(name={"securityTokenServiceClientBuilder"})
        @Bean
        public SecurityTokenServiceClientBuilder securityTokenServiceClientBuilder(CasConfigurationProperties casProperties, @Qualifier(value="hostnameVerifier") HostnameVerifier hostnameVerifier, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
            return new SecurityTokenServiceClientBuilder(casProperties.getAuthn().getWsfedIdp(), casProperties.getServer().getPrefix(), hostnameVerifier, casSslContext);
        }
    }

    @Configuration(value="CoreWsSecuritySecurityTokenServiceProvidersConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecuritySecurityTokenServiceProvidersConfiguration {
        @ConditionalOnMissingBean(name={"transportSecureContextTokenProvider"})
        @Bean
        public SCTProvider transportSecureContextTokenProvider() {
            return new SCTProvider();
        }

        @ConditionalOnMissingBean(name={"transportJwtTokenProvider"})
        @Bean
        public JWTTokenProvider transportJwtTokenProvider(@Qualifier(value="securityTokenServiceRealms") Map<String, RealmProperties> securityTokenServiceRealms) {
            JWTTokenProvider provider = new JWTTokenProvider();
            provider.setRealmMap(securityTokenServiceRealms);
            provider.setSignToken(true);
            return provider;
        }

        @ConditionalOnMissingBean(name={"transportSamlTokenProvider"})
        @Bean
        public SAMLTokenProvider transportSamlTokenProvider(CasConfigurationProperties casProperties, @Qualifier(value="securityTokenServiceRealms") Map<String, RealmProperties> securityTokenServiceRealms) {
            WsFederationSecurityTokenServiceProperties wsfed = casProperties.getAuthn().getWsfedIdp().getSts();
            DefaultSubjectProvider s = new DefaultSubjectProvider();
            if (StringUtils.isNotBlank((CharSequence)wsfed.getSubjectNameQualifier())) {
                s.setSubjectNameQualifier(wsfed.getSubjectNameQualifier());
            }
            switch (wsfed.getSubjectNameIdFormat().trim().toLowerCase()) {
                case "email": {
                    s.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
                    break;
                }
                case "entity": {
                    s.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
                    break;
                }
                case "transient": {
                    s.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
                    break;
                }
                case "persistent": {
                    s.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
                    break;
                }
                default: {
                    s.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
                }
            }
            DefaultConditionsProvider c = new DefaultConditionsProvider();
            c.setAcceptClientLifetime(wsfed.isConditionsAcceptClientLifetime());
            c.setFailLifetimeExceedance(wsfed.isConditionsFailLifetimeExceedance());
            c.setFutureTimeToLive(Beans.newDuration((String)wsfed.getConditionsFutureTimeToLive()).toSeconds());
            c.setLifetime(Beans.newDuration((String)wsfed.getConditionsLifetime()).toSeconds());
            c.setMaxLifetime(Beans.newDuration((String)wsfed.getConditionsMaxLifetime()).toSeconds());
            SAMLTokenProvider provider = new SAMLTokenProvider();
            provider.setAttributeStatementProviders(CollectionUtils.wrap((Object)new ClaimsAttributeStatementProvider()));
            provider.setRealmMap(securityTokenServiceRealms);
            provider.setConditionsProvider((ConditionsProvider)c);
            provider.setSubjectProvider((SubjectProvider)s);
            provider.setSignToken(wsfed.isSignTokens());
            return provider;
        }
    }

    @Configuration(value="CoreWsSecuritySecurityTokenServiceOperationeConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecuritySecurityTokenServiceOperationeConfiguration {
        @ConditionalOnMissingBean(name={"securityTokenServiceTokenFetcher"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SecurityTokenServiceTokenFetcher securityTokenServiceTokenFetcher(@Qualifier(value="securityTokenServiceCredentialCipherExecutor") CipherExecutor securityTokenServiceCredentialCipherExecutor, @Qualifier(value="securityTokenServiceClientBuilder") SecurityTokenServiceClientBuilder securityTokenServiceClientBuilder, @Qualifier(value="wsFederationAuthenticationServiceSelectionStrategy") AuthenticationServiceSelectionStrategy wsFederationAuthenticationServiceSelectionStrategy, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DefaultSecurityTokenServiceTokenFetcher(servicesManager, wsFederationAuthenticationServiceSelectionStrategy, securityTokenServiceCredentialCipherExecutor, securityTokenServiceClientBuilder);
        }

        @ConditionalOnMissingBean(name={"transportIssueDelegate"})
        @Bean
        public IssueOperation transportIssueDelegate(CasConfigurationProperties casProperties, List<TokenProvider> transportTokenProviders, @Qualifier(value="transportService") StaticService transportService, @Qualifier(value="transportSTSProperties") STSPropertiesMBean transportSTSProperties, @Qualifier(value="wsfedClaimsManager") ClaimsManager wsfedClaimsManager, List<TokenValidator> transportTokenValidators, @Qualifier(value="loggerListener") EventMapper loggerListener, List<TokenDelegationHandler> delegationHandlers, @Qualifier(value="securityTokenServiceTokenStore") TokenStore securityTokenServiceTokenStore) {
            WsFederationSecurityTokenServiceProperties wsfed = casProperties.getAuthn().getWsfedIdp().getSts();
            TokenIssueOperation op = new TokenIssueOperation();
            op.setTokenProviders(transportTokenProviders);
            op.setServices(CollectionUtils.wrap((Object)transportService));
            op.setStsProperties(transportSTSProperties);
            op.setClaimsManager(wsfedClaimsManager);
            op.setTokenValidators(transportTokenValidators);
            op.setEventListener((STSEventListener)loggerListener);
            op.setDelegationHandlers(delegationHandlers);
            op.setEncryptIssuedToken(wsfed.isEncryptTokens());
            op.setTokenStore(securityTokenServiceTokenStore);
            return op;
        }
    }

    @Configuration(value="CoreWsSecuritySecurityTokenServiceDelegationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecuritySecurityTokenServiceDelegationConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"samlTokenDelegationHandler"})
        public TokenDelegationHandler samlTokenDelegationHandler() {
            return new SAMLDelegationHandler();
        }

        @Bean
        @ConditionalOnMissingBean(name={"x509TokenDelegationHandler"})
        public TokenDelegationHandler x509TokenDelegationHandler() {
            return new X509TokenDelegationHandler();
        }
    }
}

