/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.lang.reflect.Field;
import lombok.Generated;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apereo.cas.config.CoreSamlConfiguration;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ReflectionUtils;

@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.WsFederationIdentityProvider)
@AutoConfiguration(after={CoreSamlConfiguration.class})
public class CoreWsSecuritySecurityTokenServiceSamlConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreWsSecuritySecurityTokenServiceSamlConfiguration.class);

    private static void findFieldAndSetValue(String fieldName, Object value) {
        LOGGER.trace("Locating field name [{}]", (Object)fieldName);
        Field field = ReflectionUtils.findField(OpenSAMLUtil.class, (String)fieldName);
        if (field == null) {
            LOGGER.error("[{}] is undefined and cannot be located in OpenSAMLUtil", (Object)fieldName);
            return;
        }
        ReflectionUtils.makeAccessible((Field)field);
        LOGGER.trace("Setting field name [{}]", (Object)fieldName);
        Unchecked.consumer(f -> field.set(null, value)).accept(field);
    }

    @Bean
    public InitializingBean wsSecurityTokenServiceInitializingBean(@Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
        return () -> {
            String warningMessage = "The security token service configuration of CAS will try to disable the OpenSAML bootstrapping process by wss4j, as it interferes with and prevents CAS' own initialization of OpenSAML. Given the current API limitations of the wss4j library, which is responsible for the implementation of the security token service in CAS, Java reflection is used to disable the OpenSAML bootstrapping process. This approach is prone to error, and may be revisited in future versions of CAS, once the wss4j library opens up its OpenSAML bootstrapping API in more extensible ways";
            LOGGER.info("The security token service configuration of CAS will try to disable the OpenSAML bootstrapping process by wss4j, as it interferes with and prevents CAS' own initialization of OpenSAML. Given the current API limitations of the wss4j library, which is responsible for the implementation of the security token service in CAS, Java reflection is used to disable the OpenSAML bootstrapping process. This approach is prone to error, and may be revisited in future versions of CAS, once the wss4j library opens up its OpenSAML bootstrapping API in more extensible ways");
            LOGGER.trace("Initializing WS provider configuration...");
            WSProviderConfig.init();
            LOGGER.trace("Marking OpenSAML components as initialized...");
            CoreWsSecuritySecurityTokenServiceSamlConfiguration.findFieldAndSetValue("providerRegistry", openSamlConfigBean.getXmlObjectProviderRegistry());
            CoreWsSecuritySecurityTokenServiceSamlConfiguration.findFieldAndSetValue("builderFactory", openSamlConfigBean.getBuilderFactory());
            CoreWsSecuritySecurityTokenServiceSamlConfiguration.findFieldAndSetValue("marshallerFactory", openSamlConfigBean.getMarshallerFactory());
            CoreWsSecuritySecurityTokenServiceSamlConfiguration.findFieldAndSetValue("unmarshallerFactory", openSamlConfigBean.getUnmarshallerFactory());
            CoreWsSecuritySecurityTokenServiceSamlConfiguration.findFieldAndSetValue("samlEngineInitialized", Boolean.TRUE);
        };
    }
}

