/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security.authentication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authorization.LdapUserAttributesToRolesAuthorizationGenerator;
import org.apereo.cas.authorization.LdapUserGroupsToRolesAuthorizationGenerator;
import org.apereo.cas.configuration.model.core.monitor.LdapSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthorizationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.LoggingUtils;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.Credential;
import org.ldaptive.LdapEntry;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperation;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.Authenticator;
import org.pac4j.core.authorization.authorizer.RequireAnyRoleAuthorizer;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.authorization.generator.DefaultRolesPermissionsAuthorizationGenerator;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class EndpointLdapAuthenticationProvider
implements AuthenticationProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointLdapAuthenticationProvider.class);
    private final LdapSecurityActuatorEndpointsMonitorProperties ldapProperties;
    private final SecurityProperties securityProperties;
    private final ConnectionFactory connectionFactory;
    private final Authenticator authenticator;

    private static Authentication generateAuthenticationToken(Authentication authentication, List<SimpleGrantedAuthority> authorities) {
        String username = authentication.getPrincipal().toString();
        Object credentials = authentication.getCredentials();
        return new UsernamePasswordAuthenticationToken((Object)username, credentials, authorities);
    }

    public void destroy() {
        this.connectionFactory.close();
        this.authenticator.close();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            String username = authentication.getPrincipal().toString();
            Object credentials = authentication.getCredentials();
            String password = Optional.ofNullable(credentials).map(Object::toString).orElse(null);
            if (StringUtils.isBlank((CharSequence)password)) {
                throw new IllegalArgumentException("Password cannot be blank");
            }
            LOGGER.debug("Preparing LDAP authentication request for user [{}]", (Object)username);
            AuthenticationRequest request = new AuthenticationRequest(username, new Credential(password), ReturnAttributes.ALL.value());
            LOGGER.debug("Executing LDAP authentication request for user [{}]", (Object)username);
            AuthenticationResponse response = this.authenticator.authenticate(request);
            LOGGER.debug("LDAP response: [{}]", (Object)response);
            if (response.isSuccess()) {
                List roles = this.securityProperties.getUser().getRoles();
                if (roles.isEmpty()) {
                    LOGGER.info("No user security roles are defined to enable authorization. User [{}] is considered authorized", (Object)username);
                    return EndpointLdapAuthenticationProvider.generateAuthenticationToken(authentication, new ArrayList<SimpleGrantedAuthority>(0));
                }
                LdapEntry entry = response.getLdapEntry();
                CommonProfile profile = new CommonProfile();
                profile.setId(username);
                entry.getAttributes().forEach(a -> profile.addAttribute(a.getName(), (Object)a.getStringValues()));
                LOGGER.debug("Collected user profile [{}]", (Object)profile);
                JEEContext context = new JEEContext(HttpRequestUtils.getHttpServletRequestFromRequestAttributes(), HttpRequestUtils.getHttpServletResponseFromRequestAttributes());
                AuthorizationGenerator authZGen = this.buildAuthorizationGenerator();
                authZGen.generate((WebContext)context, (SessionStore)JEESessionStore.INSTANCE, (UserProfile)profile);
                LOGGER.debug("Assembled user profile with roles after generating authorization claims [{}]", (Object)profile);
                ArrayList authorities = profile.getRoles().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toCollection(ArrayList::new));
                LOGGER.debug("List of authorities remapped from profile roles are [{}]", (Object)authorities);
                RequireAnyRoleAuthorizer authorizer = new RequireAnyRoleAuthorizer(roles);
                LOGGER.debug("Executing authorization for expected admin roles [{}]", (Object)authorizer.getElements());
                if (authorizer.isAllAuthorized((WebContext)context, (SessionStore)JEESessionStore.INSTANCE, CollectionUtils.wrap((Object)profile))) {
                    return EndpointLdapAuthenticationProvider.generateAuthenticationToken(authentication, authorities);
                }
                LOGGER.warn("User [{}] is not authorized to access the requested resource allowed to roles [{}]", (Object)username, (Object)authorizer.getElements());
            } else {
                LOGGER.warn("LDAP authentication response produced no results for [{}]", (Object)username);
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new InsufficientAuthenticationException("Unexpected LDAP error", (Throwable)e);
        }
        throw new BadCredentialsException("Could not authenticate provided credentials");
    }

    public boolean supports(Class<?> aClass) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(aClass);
    }

    private AuthorizationGenerator buildAuthorizationGenerator() {
        LdapAuthorizationProperties ldapAuthz = this.ldapProperties.getLdapAuthz();
        if (this.isGroupBasedAuthorization()) {
            LOGGER.debug("Handling LDAP authorization based on groups");
            return new LdapUserGroupsToRolesAuthorizationGenerator(this.ldapAuthorizationGeneratorUserSearchOperation(this.connectionFactory), ldapAuthz.isAllowMultipleResults(), ldapAuthz.getGroupAttribute(), ldapAuthz.getGroupPrefix(), this.ldapAuthorizationGeneratorGroupSearchOperation(this.connectionFactory));
        }
        if (this.isUserBasedAuthorization()) {
            LOGGER.debug("Handling LDAP authorization based on attributes and roles");
            return new LdapUserAttributesToRolesAuthorizationGenerator(this.ldapAuthorizationGeneratorUserSearchOperation(this.connectionFactory), ldapAuthz.isAllowMultipleResults(), ldapAuthz.getRoleAttribute(), ldapAuthz.getRolePrefix());
        }
        List roles = this.securityProperties.getUser().getRoles();
        LOGGER.info("Could not determine authorization generator based on users or groups. Authorization will generate static roles based on [{}]", (Object)roles);
        return new DefaultRolesPermissionsAuthorizationGenerator((Collection)roles, new ArrayList(0));
    }

    private boolean isGroupBasedAuthorization() {
        LdapAuthorizationProperties ldapAuthz = this.ldapProperties.getLdapAuthz();
        return StringUtils.isNotBlank((CharSequence)ldapAuthz.getGroupFilter()) && StringUtils.isNotBlank((CharSequence)ldapAuthz.getGroupAttribute());
    }

    private boolean isUserBasedAuthorization() {
        LdapAuthorizationProperties ldapAuthz = this.ldapProperties.getLdapAuthz();
        return StringUtils.isNotBlank((CharSequence)ldapAuthz.getBaseDn()) && StringUtils.isNotBlank((CharSequence)ldapAuthz.getSearchFilter());
    }

    private SearchOperation ldapAuthorizationGeneratorUserSearchOperation(ConnectionFactory factory) {
        LdapAuthorizationProperties ldapAuthz = this.ldapProperties.getLdapAuthz();
        SearchOperation searchOperation = LdapUtils.newLdaptiveSearchOperation((String)ldapAuthz.getBaseDn(), (String)ldapAuthz.getSearchFilter(), new ArrayList(0), (List)CollectionUtils.wrap((Object)ldapAuthz.getRoleAttribute()));
        searchOperation.setConnectionFactory(factory);
        return searchOperation;
    }

    private SearchOperation ldapAuthorizationGeneratorGroupSearchOperation(ConnectionFactory factory) {
        LdapAuthorizationProperties ldapAuthz = this.ldapProperties.getLdapAuthz();
        SearchOperation searchOperation = LdapUtils.newLdaptiveSearchOperation((String)ldapAuthz.getGroupBaseDn(), (String)ldapAuthz.getGroupFilter(), new ArrayList(0), (List)CollectionUtils.wrap((Object)ldapAuthz.getGroupAttribute()));
        searchOperation.setConnectionFactory(factory);
        return searchOperation;
    }

    @Generated
    public EndpointLdapAuthenticationProvider(LdapSecurityActuatorEndpointsMonitorProperties ldapProperties, SecurityProperties securityProperties, ConnectionFactory connectionFactory, Authenticator authenticator) {
        this.ldapProperties = ldapProperties;
        this.securityProperties = securityProperties;
        this.connectionFactory = connectionFactory;
        this.authenticator = authenticator;
    }
}

