/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.tomcat;

import lombok.Generated;
import org.apache.catalina.Cluster;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.session.BackupManager;
import org.apache.catalina.ha.session.ClusterManagerBase;
import org.apache.catalina.ha.session.ClusterSessionListener;
import org.apache.catalina.ha.session.DeltaManager;
import org.apache.catalina.ha.session.JvmRouteBinderValve;
import org.apache.catalina.ha.tcp.ReplicationValve;
import org.apache.catalina.ha.tcp.SimpleTcpCluster;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.group.interceptors.MessageDispatchInterceptor;
import org.apache.catalina.tribes.group.interceptors.StaticMembershipInterceptor;
import org.apache.catalina.tribes.group.interceptors.TcpFailureDetector;
import org.apache.catalina.tribes.group.interceptors.TcpPingInterceptor;
import org.apache.catalina.tribes.membership.McastService;
import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.catalina.tribes.membership.cloud.CloudMembershipService;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.ReplicationTransmitter;
import org.apache.catalina.tribes.transport.nio.NioReceiver;
import org.apache.catalina.tribes.transport.nio.PooledParallelSender;
import org.apache.commons.lang3.StringUtils;
import org.apache.coyote.http11.Http11AprProtocol;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheSslHostConfigProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatApachePortableRuntimeProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatClusteringProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatHttpProperties;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;

public class CasTomcatServletWebServerFactory
extends TomcatServletWebServerFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasTomcatServletWebServerFactory.class);
    private final CasConfigurationProperties casProperties;

    public CasTomcatServletWebServerFactory(CasConfigurationProperties casProperties, ServerProperties serverProperties) {
        super(serverProperties.getPort().intValue());
        if (StringUtils.isNotBlank((CharSequence)serverProperties.getServlet().getContextPath())) {
            this.setContextPath(serverProperties.getServlet().getContextPath());
        }
        this.casProperties = casProperties;
        this.configureConnectorForApr();
        this.configureContextForSessionClustering();
    }

    protected TomcatWebServer getTomcatWebServer(Tomcat tomcat) {
        this.configureSessionClustering(tomcat);
        return super.getTomcatWebServer(tomcat);
    }

    protected void postProcessContext(Context context) {
        CasEmbeddedApacheTomcatHttpProperties http = this.casProperties.getServer().getTomcat().getHttp();
        if (http.getRedirectPort() > 0) {
            SecurityConstraint securityConstraint = new SecurityConstraint();
            securityConstraint.setUserConstraint("CONFIDENTIAL");
            SecurityCollection collection = new SecurityCollection();
            collection.addPattern("/*");
            securityConstraint.addCollection(collection);
            context.addConstraint(securityConstraint);
        }
    }

    private void configureConnectorForApr() {
        CasEmbeddedApacheTomcatApachePortableRuntimeProperties apr = this.casProperties.getServer().getTomcat().getApr();
        if (apr.isEnabled()) {
            LOGGER.trace("Attempting to initialize APR protocol via [{}] for port [{}]", (Object)Http11AprProtocol.class.getName(), (Object)this.getPort());
            AprLifecycleListener arpLifecycle = new AprLifecycleListener();
            this.setProtocol(Http11AprProtocol.class.getName());
            this.addContextLifecycleListeners(new LifecycleListener[]{arpLifecycle});
            this.addConnectorCustomizers(new TomcatConnectorCustomizer[]{c -> {
                if (c.getPort() == this.getPort()) {
                    LOGGER.debug("Enabling APR on connector port [{}]", (Object)c.getPort());
                    c.setSecure(true);
                    c.setScheme("https");
                    if (apr.getSslHostConfig().isEnabled()) {
                        CasTomcatServletWebServerFactory.configureConnectorForSslHostConfig(c, apr.getSslHostConfig());
                    }
                    Http11AprProtocol handler = (Http11AprProtocol)c.getProtocolHandler();
                    handler.setSSLEnabled(true);
                    if (StringUtils.isNotBlank((CharSequence)apr.getSslProtocol())) {
                        handler.setSSLProtocol(apr.getSslProtocol());
                    }
                    if (apr.getSslVerifyDepth() > 0) {
                        handler.setSSLVerifyDepth(apr.getSslVerifyDepth());
                    }
                    if (StringUtils.isNotBlank((CharSequence)apr.getSslVerifyClient())) {
                        handler.setSSLVerifyClient(apr.getSslVerifyClient());
                    }
                    if (StringUtils.isNotBlank((CharSequence)apr.getSslCipherSuite())) {
                        handler.setSSLCipherSuite(apr.getSslCipherSuite());
                    }
                    if (StringUtils.isNotBlank((CharSequence)apr.getSslPassword())) {
                        handler.setSSLPassword(apr.getSslPassword());
                    }
                    handler.setSSLDisableCompression(apr.isSslDisableCompression());
                    handler.setSSLHonorCipherOrder(apr.isSslHonorCipherOrder());
                    FunctionUtils.doIfNotNull((Object)apr.getSslCaCertificateFile(), f -> handler.setSSLCACertificateFile(apr.getSslCaCertificateFile().getCanonicalPath()));
                    FunctionUtils.doIfNotNull((Object)apr.getSslCertificateFile(), f -> handler.setSSLCertificateFile(apr.getSslCertificateFile().getCanonicalPath()));
                    FunctionUtils.doIfNotNull((Object)apr.getSslCertificateKeyFile(), f -> handler.setSSLCertificateKeyFile(apr.getSslCertificateKeyFile().getCanonicalPath()));
                    FunctionUtils.doIfNotNull((Object)apr.getSslCertificateChainFile(), f -> handler.setSSLCertificateChainFile(apr.getSslCertificateChainFile().getCanonicalPath()));
                    FunctionUtils.doIfNotNull((Object)apr.getSslCaRevocationFile(), f -> handler.setSSLCARevocationFile(apr.getSslCaRevocationFile().getCanonicalPath()));
                }
            }});
        }
    }

    private void configureSessionClustering(Tomcat tomcat) {
        CasEmbeddedApacheTomcatClusteringProperties clusteringProperties = this.casProperties.getServer().getTomcat().getClustering();
        if (!clusteringProperties.isEnabled()) {
            LOGGER.trace("Tomcat session clustering/replication is turned off");
            return;
        }
        SimpleTcpCluster cluster = new SimpleTcpCluster();
        GroupChannel groupChannel = new GroupChannel();
        NioReceiver receiver = new NioReceiver();
        receiver.setPort(clusteringProperties.getReceiverPort());
        receiver.setTimeout(clusteringProperties.getReceiverTimeout());
        receiver.setMaxThreads(clusteringProperties.getReceiverMaxThreads());
        receiver.setAddress(clusteringProperties.getReceiverAddress());
        receiver.setAutoBind(clusteringProperties.getReceiverAutoBind());
        groupChannel.setChannelReceiver((ChannelReceiver)receiver);
        ReplicationTransmitter sender = new ReplicationTransmitter();
        sender.setTransport((MultiPointSender)new PooledParallelSender());
        groupChannel.setChannelSender((ChannelSender)sender);
        groupChannel.addInterceptor((ChannelInterceptor)new TcpPingInterceptor());
        groupChannel.addInterceptor((ChannelInterceptor)new TcpFailureDetector());
        groupChannel.addInterceptor((ChannelInterceptor)new MessageDispatchInterceptor());
        cluster.setChannelSendOptions(clusteringProperties.getChannelSendOptions());
        ClusterManagerBase manager = this.getClusteringManagerInstance();
        cluster.setManagerTemplate((ClusterManager)manager);
        cluster.addValve((Valve)new ReplicationValve());
        cluster.addValve((Valve)new JvmRouteBinderValve());
        cluster.addClusterListener((ClusterListener)new ClusterSessionListener());
        if ("CLOUD".equalsIgnoreCase(clusteringProperties.getClusteringType())) {
            CloudMembershipService membershipService = new CloudMembershipService();
            membershipService.setMembershipProviderClassName(clusteringProperties.getCloudMembershipProvider());
            groupChannel.setMembershipService((MembershipService)membershipService);
            LOGGER.trace("Tomcat session clustering/replication configured using cloud membership provider [{}]", (Object)clusteringProperties.getCloudMembershipProvider());
        } else {
            McastService membershipService = new McastService();
            membershipService.setPort(clusteringProperties.getMembershipPort());
            membershipService.setAddress(clusteringProperties.getMembershipAddress());
            membershipService.setFrequency((long)clusteringProperties.getMembershipFrequency());
            membershipService.setDropTime((long)clusteringProperties.getMembershipDropTime());
            membershipService.setRecoveryEnabled(clusteringProperties.isMembershipRecoveryEnabled());
            membershipService.setRecoveryCounter(clusteringProperties.getMembershipRecoveryCounter());
            membershipService.setLocalLoopbackDisabled(clusteringProperties.isMembershipLocalLoopbackDisabled());
            groupChannel.setMembershipService((MembershipService)membershipService);
            String clusterMembers = clusteringProperties.getClusterMembers();
            if (StringUtils.isNotBlank((CharSequence)clusterMembers)) {
                String[] memberSpecs;
                StaticMembershipInterceptor membership = new StaticMembershipInterceptor();
                for (String spec : memberSpecs = clusterMembers.split(",", -1)) {
                    ClusterMemberDesc memberDesc = new ClusterMemberDesc(spec);
                    StaticMember member = new StaticMember();
                    member.setHost(memberDesc.getAddress());
                    member.setPort(memberDesc.getPort());
                    member.setDomain("CAS");
                    member.setUniqueId(memberDesc.getUniqueId());
                    membership.addStaticMember((Member)member);
                    groupChannel.addInterceptor((ChannelInterceptor)membership);
                }
            }
        }
        cluster.setChannel((Channel)groupChannel);
        tomcat.getEngine().setCluster((Cluster)cluster);
    }

    private void configureContextForSessionClustering() {
        CasEmbeddedApacheTomcatClusteringProperties clusteringProperties = this.casProperties.getServer().getTomcat().getClustering();
        if (!clusteringProperties.isEnabled()) {
            LOGGER.trace("Tomcat session clustering/replication is turned off");
            return;
        }
        this.addContextCustomizers(new TomcatContextCustomizer[]{context -> {
            ClusterManagerBase manager = this.getClusteringManagerInstance();
            context.setManager((Manager)manager);
            context.setDistributable(true);
        }});
    }

    private ClusterManagerBase getClusteringManagerInstance() {
        CasEmbeddedApacheTomcatClusteringProperties clusteringProperties = this.casProperties.getServer().getTomcat().getClustering();
        String type = clusteringProperties.getManagerType().toUpperCase();
        if ("DELTA".equalsIgnoreCase(type)) {
            DeltaManager manager = new DeltaManager();
            manager.setExpireSessionsOnShutdown(clusteringProperties.isExpireSessionsOnShutdown());
            manager.setNotifyListenersOnReplication(true);
            return manager;
        }
        BackupManager backupManager = new BackupManager();
        backupManager.setNotifyListenersOnReplication(true);
        return backupManager;
    }

    private static void configureConnectorForSslHostConfig(Connector c, CasEmbeddedApacheSslHostConfigProperties properties) {
        SSLHostConfig hostConfig = new SSLHostConfig();
        hostConfig.setCertificateVerification(properties.getCertificateVerification());
        hostConfig.setCertificateVerificationDepth(properties.getCertificateVerificationDepth());
        hostConfig.setHostName(properties.getHostName());
        hostConfig.setProtocols(properties.getProtocols());
        hostConfig.setSslProtocol(properties.getSslProtocol());
        hostConfig.setCaCertificateFile(properties.getCaCertificateFile());
        hostConfig.setInsecureRenegotiation(properties.isInsecureRenegotiation());
        hostConfig.setRevocationEnabled(properties.isRevocationEnabled());
        properties.getCertificates().forEach(cert -> {
            SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(hostConfig, SSLHostConfigCertificate.Type.valueOf((String)cert.getType().trim().toUpperCase()));
            certificate.setCertificateChainFile(cert.getCertificateChainFile());
            certificate.setCertificateFile(cert.getCertificateFile());
            certificate.setCertificateKeyFile(cert.getCertificateKeyFile());
            certificate.setCertificateKeyPassword(cert.getCertificateKeyPassword());
            hostConfig.addCertificate(certificate);
        });
        c.addSslHostConfig(hostConfig);
    }

    private static class ClusterMemberDesc {
        private static final int UNIQUE_ID_LIMIT = 255;
        private static final int UNIQUE_ID_ITERATIONS = 16;
        private final String address;
        private final int port;
        private String uniqueId;

        ClusterMemberDesc(String spec) {
            String[] values = spec.split(":", -1);
            this.address = values[0];
            this.port = Integer.parseInt(values[1]);
            int index = Integer.parseInt(values[2]);
            if (index < 0 || index > 255) {
                throw new IllegalArgumentException("Invalid unique index: must be >= 0 and < 256");
            }
            this.uniqueId = "{";
            int i = 0;
            while (i < 16) {
                if (i != 0) {
                    this.uniqueId = this.uniqueId + ",";
                }
                this.uniqueId = this.uniqueId + index % 256;
                ++i;
                ++index;
            }
            this.uniqueId = this.uniqueId + "}";
        }

        @Generated
        public String getAddress() {
            return this.address;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public String getUniqueId() {
            return this.uniqueId;
        }

        @Generated
        public String toString() {
            return "CasTomcatServletWebServerFactory.ClusterMemberDesc(address=" + this.address + ", port=" + this.port + ", uniqueId=" + this.uniqueId + ")";
        }
    }
}

