/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import lombok.Generated;
import org.apache.catalina.filters.CsrfPreventionFilter;
import org.apache.catalina.filters.RemoteAddrFilter;
import org.apache.catalina.filters.RequestFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apereo.cas.config.CasEmbeddedContainerTomcatConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatRemoteAddressProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.HttpStatus;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ImportAutoConfiguration(value={CasEmbeddedContainerTomcatConfiguration.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.ApacheTomcat)
@AutoConfiguration
public class CasEmbeddedContainerTomcatFiltersConfiguration {
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"tomcatCsrfPreventionFilter"})
    public FilterRegistrationBean<CsrfPreventionFilter> tomcatCsrfPreventionFilter(CasConfigurationProperties casProperties) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new CsrfPreventionFilter());
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setName("tomcatCsrfPreventionFilter");
        bean.setEnabled(casProperties.getServer().getTomcat().getCsrf().isEnabled());
        return bean;
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"tomcatRemoteAddressFilter"})
    public FilterRegistrationBean<RemoteAddrFilter> tomcatRemoteAddressFilter(CasConfigurationProperties casProperties) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        CasEmbeddedApacheTomcatRemoteAddressProperties addr = casProperties.getServer().getTomcat().getRemoteAddr();
        ClientInfoRemoteAddrFilter filter = new ClientInfoRemoteAddrFilter();
        filter.setAllow(addr.getAllowedClientIpAddressRegex());
        filter.setDeny(addr.getDeniedClientIpAddressRegex());
        filter.setDenyStatus(HttpStatus.UNAUTHORIZED.value());
        bean.setFilter((Filter)filter);
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setName("clientInfoRemoteAddrFilter");
        bean.setEnabled(addr.isEnabled());
        return bean;
    }

    private static class ClientInfoRemoteAddrFilter
    extends RequestFilter {
        private final Log logger = LogFactory.getLog(ClientInfoRemoteAddrFilter.class);

        private ClientInfoRemoteAddrFilter() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
            String remoteAddress = Optional.ofNullable(ClientInfoHolder.getClientInfo()).map(ClientInfo::getClientIpAddress).orElseGet(() -> ((ServletRequest)request).getRemoteAddr());
            String message = String.format("Remote address to process is [%s]", remoteAddress);
            this.logger.trace((Object)message);
            this.process(remoteAddress, request, response, filterChain);
        }

        @Generated
        protected Log getLogger() {
            return this.logger;
        }
    }
}

