/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.util;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Date;
import org.apereo.cas.client.util.CommonUtils;

public final class SamlUtils {
    private static final DateTimeFormatter ISO_FORMATTER_NO_MILLIS = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("YYYY-MM-dd'T'HH:mm:ss")).parseLenient().appendOffset("+HHMM", "Z").parseStrict().toFormatter();
    private static final DateTimeFormatter ISO_PARSER_WITH_MILLIS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).parseLenient().appendOffset("+HHMM", "Z").parseStrict().toFormatter();

    private SamlUtils() {
    }

    public static String formatForUtcTime(Date date) {
        return ISO_FORMATTER_NO_MILLIS.format(ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC));
    }

    public static Date parseUtcDate(String date) {
        if (CommonUtils.isEmpty((CharSequence)date)) {
            return null;
        }
        return Date.from(ZonedDateTime.parse(date, ISO_PARSER_WITH_MILLIS).toInstant());
    }
}

