/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.api.model.v3_1.Container;
import io.fabric8.kubernetes.api.model.v3_1.Endpoints;
import io.fabric8.kubernetes.api.model.v3_1.Event;
import io.fabric8.kubernetes.api.model.v3_1.HasMetadata;
import io.fabric8.kubernetes.api.model.v3_1.Pod;
import io.fabric8.kubernetes.api.model.v3_1.PodList;
import io.fabric8.kubernetes.api.model.v3_1.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v3_1.Service;
import io.fabric8.kubernetes.api.model.v3_1.ServiceList;
import io.fabric8.kubernetes.api.model.v3_1.ServicePort;
import io.fabric8.kubernetes.api.model.v3_1.extensions.ReplicaSetList;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClient;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.clnt.v3_1.Watch;
import io.fabric8.kubernetes.clnt.v3_1.Watcher;
import io.fabric8.kubernetes.clnt.v3_1.dsl.ContainerResource;
import io.fabric8.kubernetes.clnt.v3_1.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v3_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v3_1.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v3_1.dsl.Resource;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.cube.kubernetes.api.AnnotationProvider;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.DependencyResolver;
import org.arquillian.cube.kubernetes.api.FeedbackProvider;
import org.arquillian.cube.kubernetes.api.KubernetesResourceLocator;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.api.ResourceInstaller;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.api.SessionCreatedListener;
import org.arquillian.cube.kubernetes.impl.ShutdownHook;
import org.arquillian.cube.kubernetes.impl.utils.ProcessUtil;
import org.jboss.arquillian.core.spi.Validate;
import org.xnio.IoUtils;

public class SessionManager
implements SessionCreatedListener {
    private final Session session;
    private final KubernetesClient client;
    private final Configuration configuration;
    private final AnnotationProvider annotationProvider;
    private final NamespaceService namespaceService;
    private final KubernetesResourceLocator kubernetesResourceLocator;
    private final DependencyResolver dependencyResolver;
    private final ResourceInstaller resourceInstaller;
    private final FeedbackProvider feedbackProvider;
    private final List<HasMetadata> resources = new ArrayList<HasMetadata>();
    private final Map<String, Collection<Closeable>> watchersMap = new ConcurrentHashMap<String, Collection<Closeable>>();
    private Watch watchLog;
    private Watch watchEvents;
    private final AtomicReference<ShutdownHook> shutdownHookRef = new AtomicReference();
    private String logPath;
    private FileWriter eventLogWriter;
    private String currentClassName;
    private String currentMethodName;

    public SessionManager(Session session, KubernetesClient client, Configuration configuration, AnnotationProvider annotationProvider, NamespaceService namespaceService, KubernetesResourceLocator kubernetesResourceLocator, DependencyResolver dependencyResolver, ResourceInstaller resourceInstaller, FeedbackProvider feedbackProvider) {
        Validate.notNull((Object)session, (String)"A Session instance is required.");
        Validate.notNull((Object)client, (String)"A KubernetesClient instance is required.");
        Validate.notNull((Object)configuration, (String)"Configuration is required.");
        Validate.notNull((Object)annotationProvider, (String)"An AnnotationProvider instance is required.");
        Validate.notNull((Object)namespaceService, (String)"A NamespaceService instance is required.");
        Validate.notNull((Object)dependencyResolver, (String)"A DependencyResolver instance is required.");
        Validate.notNull((Object)kubernetesResourceLocator, (String)"A KubernetesResourceLocator instance is required.");
        Validate.notNull((Object)resourceInstaller, (String)"A ResourceInstaller instance is required.");
        Validate.notNull((Object)feedbackProvider, (String)"A FeedbackProvider instance is required.");
        this.session = session;
        this.client = client;
        this.configuration = configuration;
        this.annotationProvider = annotationProvider;
        this.namespaceService = namespaceService;
        this.kubernetesResourceLocator = kubernetesResourceLocator;
        this.dependencyResolver = dependencyResolver;
        this.resourceInstaller = resourceInstaller;
        this.feedbackProvider = feedbackProvider;
    }

    private String getSessionStatus() {
        if (this.session.getFailed().get() > 0) {
            return "FAILED";
        }
        return "PASSED";
    }

    public void createNamespace() {
        Map<String, String> namespaceAnnotations = this.annotationProvider.create(this.session.getId(), "RUNNING");
        if (!this.namespaceService.exists(this.session.getNamespace()).booleanValue()) {
            if (this.configuration.isNamespaceLazyCreateEnabled()) {
                this.namespaceService.create(this.session.getNamespace(), namespaceAnnotations);
            } else {
                throw new IllegalStateException("Namespace [" + this.session.getNamespace() + "] doesn't exist and lazily creation of namespaces is disabled. Either use an existing one, or set `namespace.lazy.enabled` to true.");
            }
        }
    }

    public void createEnvironment() {
        Logger log = this.session.getLogger();
        try {
            List<URL> dependencyUrls;
            URL configUrl = this.configuration.getEnvironmentConfigUrl();
            List<URL> list = dependencyUrls = !this.configuration.getEnvironmentDependencies().isEmpty() ? this.configuration.getEnvironmentDependencies() : this.dependencyResolver.resolve(this.session);
            if (this.configuration.isEnvironmentInitEnabled()) {
                if (this.configuration.getEnvironmentSetupScriptUrl() != null) {
                    this.setupEnvironment();
                }
                Collection<URL> additionalUrls = this.kubernetesResourceLocator.locateAdditionalResources();
                for (URL uRL : additionalUrls) {
                    log.status("Applying additional kubernetes configuration from: " + uRL);
                    InputStream is2 = uRL.openStream();
                    Throwable throwable = null;
                    try {
                        this.resources.addAll(this.resourceInstaller.install(uRL));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is2 == null) continue;
                        if (throwable != null) {
                            try {
                                is2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is2.close();
                    }
                }
                for (URL uRL : dependencyUrls) {
                    log.info("Found dependency: " + uRL);
                    this.resources.addAll(this.resourceInstaller.install(uRL));
                }
                if (configUrl == null) {
                    configUrl = this.kubernetesResourceLocator.locate();
                }
                if (configUrl != null) {
                    log.status("Applying kubernetes configuration from: " + configUrl);
                    Throwable throwable = null;
                    try (InputStream is = configUrl.openStream();){
                        this.resources.addAll(this.resourceInstaller.install(configUrl));
                    }
                    catch (Throwable is2) {
                        Throwable throwable4 = is2;
                        throw is2;
                    }
                } else {
                    log.warn("Did not find any kubernetes/openshift configuration files before starting the test execution. If you are using fabric8-maven-plugin, ensure `mvn package fabric8:resource fabric8:build` is run first to generate the resources.");
                }
                ArrayList<HasMetadata> resourcesToWait = new ArrayList<HasMetadata>(this.resources);
                for (String service : this.configuration.getWaitForServiceList()) {
                    Endpoints endpoints = (Endpoints)((Resource)((NonNamespaceOperation)this.client.endpoints().inNamespace(this.session.getNamespace())).withName(service)).get();
                    if (endpoints == null) continue;
                    resourcesToWait.add((HasMetadata)endpoints);
                }
                if (this.configuration.isWaitEnabled() && !resourcesToWait.isEmpty()) {
                    try {
                        this.client.resourceList(resourcesToWait).waitUntilReady(this.configuration.getWaitTimeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (KubernetesClientTimeoutException kubernetesClientTimeoutException) {
                        log.warn("There are resources in not ready state:");
                        for (HasMetadata r : kubernetesClientTimeoutException.getResourcesNotReady()) {
                            log.error(r.getKind() + " name: " + r.getMetadata().getName() + " namespace:" + r.getMetadata().getNamespace());
                            this.feedbackProvider.onResourceNotReady(r);
                        }
                        throw new IllegalStateException("Environment not initialized in time.", kubernetesClientTimeoutException);
                    }
                }
            }
            this.display();
        }
        catch (Exception e) {
            try {
                this.clean("ERROR");
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void start() {
        Logger log = this.session.getLogger();
        log.status("Using Kubernetes at: " + this.client.getMasterUrl());
        this.createNamespace();
        this.setupConsoleListener();
        this.setupEventListener();
        this.addShutdownHook();
        try {
            this.createEnvironment();
        }
        catch (Throwable t) {
            this.removeShutdownHook();
            throw t;
        }
    }

    private void addConsole(String podName) {
        if (this.watchersMap.containsKey(podName)) {
            return;
        }
        String className = this.session.getCurrentClassName();
        String methodName = this.session.getCurrentMethodName();
        String fileName = this.logPath;
        if (Strings.isNullOrEmpty((String)className)) {
            className = "NOCLASS";
        }
        fileName = fileName + String.format("/%s", className);
        if (Strings.isNotNullOrEmpty((String)methodName)) {
            fileName = fileName + String.format("-%s", methodName);
        }
        try {
            ArrayList<Object> fds = new ArrayList<Object>();
            List containers = ((Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.session.getNamespace())).withName(podName)).get()).getSpec().getContainers();
            if (containers.size() == 1) {
                fileName = fileName + String.format("-%s.log", podName);
                FileOutputStream stream = new FileOutputStream(fileName);
                LogWatch lw = (LogWatch)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.session.getNamespace())).withName(podName)).watchLog((OutputStream)stream);
                fds.add(lw);
                fds.add(stream);
            } else {
                for (Container container : containers) {
                    String containerName = container.getName();
                    String fileNameContainer = String.format("%s-%s-%s.log", fileName, podName, containerName);
                    FileOutputStream stream = new FileOutputStream(fileNameContainer);
                    LogWatch lw = (LogWatch)((ContainerResource)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.session.getNamespace())).withName(podName)).inContainer((Object)containerName)).watchLog((OutputStream)stream);
                    fds.add(lw);
                    fds.add(stream);
                }
            }
            this.watchersMap.put(podName, fds);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(String.format("Error storing the console log for pod %s", podName), e);
        }
    }

    private void delConsole(String podName) {
        Collection<Closeable> lw = this.watchersMap.get(podName);
        if (lw == null) {
            return;
        }
        this.watchersMap.remove(podName);
        IoUtils.safeClose((Closeable[])lw.toArray(new Closeable[0]));
    }

    private void setupConsoleListener() {
        if (!this.configuration.isLogCopyEnabled()) {
            return;
        }
        this.logPath = this.configuration.getLogPath();
        if (Strings.isNullOrEmpty((String)this.logPath)) {
            this.logPath = String.format("%s/target/surefire-reports", System.getProperty("user.dir"));
        }
        this.session.getLogger().info(String.format("Storing pods console logs into dir %s", this.logPath));
        new File(this.logPath).mkdirs();
        Watcher<Pod> watcher = new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod pod) {
                switch (action) {
                    case ADDED: 
                    case MODIFIED: {
                        if (!pod.getStatus().getPhase().equalsIgnoreCase("Running")) break;
                        SessionManager.this.addConsole(pod.getMetadata().getName());
                        break;
                    }
                    case DELETED: 
                    case ERROR: {
                        SessionManager.this.delConsole(pod.getMetadata().getName());
                    }
                }
            }

            public void onClose(KubernetesClientException cause) {
            }
        };
        this.watchLog = (Watch)((NonNamespaceOperation)this.client.pods().inNamespace(this.session.getNamespace())).watch((Object)watcher);
    }

    private void cleanupConsoleListener() {
        if (this.watchLog != null) {
            this.watchLog.close();
        }
        this.watchersMap.forEach((k, v) -> IoUtils.safeClose((Closeable[])v.toArray(new Closeable[0])));
        this.watchersMap.clear();
    }

    private void setupEventLogWriter() {
        String className = this.session.getCurrentClassName();
        String methodName = this.session.getCurrentMethodName();
        if (className != null && className.equals(this.currentClassName) && methodName != null && methodName.equals(this.currentMethodName)) {
            return;
        }
        this.currentClassName = className;
        this.currentMethodName = methodName;
        String fileName = this.logPath;
        if (Strings.isNullOrEmpty((String)className)) {
            className = "NOCLASS";
        }
        fileName = fileName + String.format("/%s", className);
        if (Strings.isNotNullOrEmpty((String)methodName)) {
            fileName = fileName + String.format("-%s", methodName);
        }
        fileName = fileName + "-KUBE_EVENTS.log";
        try {
            if (this.eventLogWriter != null) {
                this.eventLogWriter.close();
            }
            this.eventLogWriter = new FileWriter(fileName, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing kubernetes events", e);
        }
    }

    private void setupEventListener() {
        if (!this.configuration.isLogCopyEnabled()) {
            return;
        }
        Watcher<Event> watcher = new Watcher<Event>(){

            public void eventReceived(Watcher.Action action, Event event) {
                switch (action) {
                    case ADDED: 
                    case MODIFIED: 
                    case DELETED: 
                    case ERROR: {
                        try {
                            SessionManager.this.setupEventLogWriter();
                            SessionManager.this.eventLogWriter.append(String.format("[%s] [%s] [%s:%s]: (%s) %s\n", event.getLastTimestamp(), event.getType(), event.getInvolvedObject().getKind(), event.getInvolvedObject().getName(), event.getReason(), event.getMessage()));
                            SessionManager.this.eventLogWriter.flush();
                            break;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Error storing kubernetes events", e);
                        }
                    }
                }
            }

            public void onClose(KubernetesClientException cause) {
            }
        };
        this.watchEvents = (Watch)((NonNamespaceOperation)this.client.events().inNamespace(this.session.getNamespace())).watch((Object)watcher);
    }

    private void cleanupEventsListener() {
        if (this.watchEvents != null) {
            this.watchEvents.close();
        }
        if (this.eventLogWriter != null) {
            try {
                this.eventLogWriter.close();
            }
            catch (IOException e) {
                this.session.getLogger().error("Error closing kubernetes events file: " + e);
            }
        }
    }

    @Override
    public void stop() {
        try {
            this.cleanupConsoleListener();
            this.cleanupEventsListener();
            this.clean(this.getSessionStatus());
        }
        finally {
            this.removeShutdownHook();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean(String status) {
        String namespace = this.session.getNamespace();
        try {
            if (this.configuration.isNamespaceCleanupEnabled()) {
                this.resourceInstaller.uninstall(this.resources);
            }
            if (this.configuration.isNamespaceDestroyEnabled()) {
                this.namespaceService.destroy(namespace);
            } else {
                try {
                    this.namespaceService.annotate(this.session.getNamespace(), this.annotationProvider.create(this.session.getId(), status));
                }
                catch (Throwable t) {
                    this.session.getLogger().warn("Could not annotate namespace: [" + namespace + "] with status: [" + status + "].");
                }
            }
        }
        finally {
            this.tearDownEnvironment();
        }
    }

    @Override
    public void display() {
        ServiceList serviceList;
        PodList podList;
        ReplicationControllerList replicationControllerList;
        ReplicaSetList replicaSetList = (ReplicaSetList)((NonNamespaceOperation)this.client.extensions().replicaSets().inNamespace(this.session.getNamespace())).list();
        if (replicaSetList.getItems() != null) {
            for (Object replicaSet : replicaSetList.getItems()) {
                this.session.getLogger().info("ReplicaSet: [" + replicaSet.getMetadata().getName() + "]");
            }
        }
        if ((replicationControllerList = (ReplicationControllerList)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.session.getNamespace())).list()).getItems() != null) {
            for (Object replicationController : replicationControllerList.getItems()) {
                this.session.getLogger().info("Replication controller: [" + replicationController.getMetadata().getName() + "]");
            }
        }
        if ((podList = (PodList)((NonNamespaceOperation)this.client.pods().inNamespace(this.session.getNamespace())).list()) != null) {
            for (Pod pod : podList.getItems()) {
                this.session.getLogger().info("Pod: [" + pod.getMetadata().getName() + "] Status: [" + pod.getStatus().getPhase() + "]");
            }
        }
        if ((serviceList = (ServiceList)((NonNamespaceOperation)this.client.services().inNamespace(this.session.getNamespace())).list()) != null) {
            for (Service service : serviceList.getItems()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Service: [").append(service.getMetadata().getName()).append("]").append(" IP: [").append(service.getSpec().getClusterIP()).append("]").append(" Ports: [ ");
                for (ServicePort servicePort : service.getSpec().getPorts()) {
                    sb.append(servicePort.getPort()).append(" ");
                }
                sb.append("]");
                this.session.getLogger().info(sb.toString());
            }
        }
    }

    private void setupEnvironment() {
        Logger log = this.session.getLogger();
        log.info("Executing environment setup script from:" + this.configuration.getEnvironmentSetupScriptUrl());
        try {
            ProcessUtil.runCommand(log, this.configuration.getEnvironmentSetupScriptUrl(), this.createScriptEnvironment());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void tearDownEnvironment() {
        if (this.configuration.getEnvironmentTeardownScriptUrl() != null) {
            try {
                this.session.getLogger().info("Executing environment teardown script from:" + this.configuration.getEnvironmentTeardownScriptUrl());
                ProcessUtil.runCommand(this.session.getLogger(), this.configuration.getEnvironmentTeardownScriptUrl(), this.createScriptEnvironment());
            }
            catch (IOException ex) {
                this.session.getLogger().warn("Failed to execute teardown script, due to: " + ex.getMessage());
            }
        }
    }

    private Map<String, String> createScriptEnvironment() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(System.getenv());
        env.putAll(this.configuration.getScriptEnvironmentVariables());
        env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"kubernetes.namespace"), this.configuration.getNamespace());
        env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"kubernetes.domain"), this.configuration.getKubernetesDomain());
        env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"kubernetes.master"), this.configuration.getMasterUrl().toString());
        env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"docker.registry"), this.configuration.getDockerRegistry());
        return env;
    }

    private void addShutdownHook() {
        ShutdownHook hook = new ShutdownHook(new Runnable(){

            @Override
            public void run() {
                SessionManager.this.clean("ABORTED");
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
        this.shutdownHookRef.set(hook);
    }

    private void removeShutdownHook() {
        ShutdownHook hook = this.shutdownHookRef.get();
        if (hook != null) {
            Runtime.getRuntime().removeShutdownHook(hook);
        }
    }
}

