/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.enricher;

import io.fabric8.kubernetes.api.model.v3_1.EndpointAddress;
import io.fabric8.kubernetes.api.model.v3_1.EndpointSubset;
import io.fabric8.kubernetes.api.model.v3_1.Endpoints;
import io.fabric8.kubernetes.api.model.v3_1.Pod;
import io.fabric8.kubernetes.api.model.v3_1.Service;
import io.fabric8.kubernetes.api.model.v3_1.ServicePort;
import io.fabric8.kubernetes.clnt.v3_1.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClient;
import io.fabric8.kubernetes.clnt.v3_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v3_1.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v3_1.dsl.Resource;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.kubernetes.annotations.Port;
import org.arquillian.cube.kubernetes.annotations.PortForward;
import org.arquillian.cube.kubernetes.annotations.Scheme;
import org.arquillian.cube.kubernetes.annotations.UseDns;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.api.SessionListener;
import org.arquillian.cube.kubernetes.impl.enricher.AbstractKubernetesResourceProvider;
import org.arquillian.cube.kubernetes.impl.portforward.PortForwarder;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class KuberntesServiceUrlResourceProvider
extends AbstractKubernetesResourceProvider {
    private static final String SERVICE_PATH = "api.service.kubernetes.io/path";
    private static final String SERVICE_SCHEME = "api.service.kubernetes.io/scheme";
    private static final String DEFAULT_SCHEME = "http";
    private static final String DEFAULT_PATH = "/";
    private static final String POD = "Pod";
    public static final String LOCALHOST = "127.0.0.1";
    private static final String SERVICE_A_RECORD_FORMAT = "%s.%s.svc.cluster.local";
    private static final Random RANDOM = new Random();
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    private ResourceProvider next;

    private static boolean isPortForwardingEnabled(Annotation ... qualifiers) {
        for (Annotation q : qualifiers) {
            if (!(q instanceof PortForward)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUseDnsEnabled(Annotation ... qualifiers) {
        for (Annotation q : qualifiers) {
            if (!(q instanceof UseDns)) continue;
            return true;
        }
        return false;
    }

    private static ServicePort findQualifiedServicePort(Service service, Annotation ... qualifiers) {
        Port port = null;
        for (Annotation q : qualifiers) {
            if (!(q instanceof Port)) continue;
            port = (Port)q;
        }
        if (service.getSpec() != null && service.getSpec().getPorts() != null) {
            for (ServicePort servicePort : service.getSpec().getPorts()) {
                if (port == null) {
                    return servicePort;
                }
                if (servicePort.getName() == null || !servicePort.getName().equals(port.name())) continue;
                return servicePort;
            }
        }
        return null;
    }

    private static int getPort(Service service, Annotation ... qualifiers) {
        for (Annotation q : qualifiers) {
            Port port;
            if (!(q instanceof Port) || (port = (Port)q).value() <= 0) continue;
            return port.value();
        }
        ServicePort servicePort = KuberntesServiceUrlResourceProvider.findQualifiedServicePort(service, qualifiers);
        if (servicePort != null) {
            return servicePort.getPort();
        }
        return 0;
    }

    private static int getContainerPort(Service service, Annotation ... qualifiers) {
        for (Annotation q : qualifiers) {
            Port port;
            if (!(q instanceof Port) || (port = (Port)q).value() <= 0) continue;
            return port.value();
        }
        ServicePort servicePort = KuberntesServiceUrlResourceProvider.findQualifiedServicePort(service, qualifiers);
        if (servicePort != null) {
            return servicePort.getTargetPort().getIntVal();
        }
        return 0;
    }

    private static String getScheme(Service service, Annotation ... qualifiers) {
        String s;
        for (Annotation q : qualifiers) {
            if (!(q instanceof Scheme)) continue;
            return ((Scheme)q).value();
        }
        if (service.getMetadata() != null && service.getMetadata().getAnnotations() != null && (s = (String)service.getMetadata().getAnnotations().get(SERVICE_SCHEME)) != null && s.isEmpty()) {
            return s;
        }
        return DEFAULT_SCHEME;
    }

    private static String getPath(Service service, Annotation ... qualifiers) {
        String s;
        for (Annotation q : qualifiers) {
            if (!(q instanceof Scheme)) continue;
            return ((Scheme)q).value();
        }
        if (service.getMetadata() != null && service.getMetadata().getAnnotations() != null && (s = (String)service.getMetadata().getAnnotations().get(SERVICE_SCHEME)) != null && s.isEmpty()) {
            return s;
        }
        return DEFAULT_PATH;
    }

    private static Pod getRandomPod(KubernetesClient client, String name, String namespace) {
        Endpoints endpoints = (Endpoints)((Resource)((NonNamespaceOperation)client.endpoints().inNamespace(namespace)).withName(name)).get();
        ArrayList<String> pods = new ArrayList<String>();
        if (endpoints != null) {
            for (EndpointSubset subset : endpoints.getSubsets()) {
                for (EndpointAddress address : subset.getAddresses()) {
                    String pod;
                    if (address.getTargetRef() == null || !POD.equals(address.getTargetRef().getKind()) || (pod = address.getTargetRef().getName()) == null || pod.isEmpty()) continue;
                    pods.add(pod);
                }
            }
        }
        if (pods.isEmpty()) {
            return null;
        }
        String chosen = (String)pods.get(RANDOM.nextInt(pods.size()));
        return (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(chosen)).get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int findRandomFreeLocalPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canProvide(Class<?> type) {
        return URL.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        ResourceProvider delegate;
        String name = this.getName(qualifiers);
        if (Strings.isNullOrEmpty((String)name) && (delegate = this.getNext()) != null) {
            return delegate.lookup(resource, qualifiers);
        }
        String namespace = this.getNamespace(qualifiers);
        Service service = (Service)((Resource)((NonNamespaceOperation)this.getClient().services().inNamespace(namespace)).withName(name)).get();
        String scheme = KuberntesServiceUrlResourceProvider.getScheme(service, qualifiers);
        String path = KuberntesServiceUrlResourceProvider.getPath(service, qualifiers);
        String ip = service.getSpec().getClusterIP();
        int port = 0;
        if (KuberntesServiceUrlResourceProvider.isPortForwardingEnabled(qualifiers)) {
            Pod pod = KuberntesServiceUrlResourceProvider.getRandomPod(this.getClient(), name, namespace);
            int containerPort = KuberntesServiceUrlResourceProvider.getContainerPort(service, qualifiers);
            port = this.portForward(this.getSession(), pod.getMetadata().getName(), containerPort, namespace);
            ip = LOCALHOST;
        } else if (KuberntesServiceUrlResourceProvider.isUseDnsEnabled(qualifiers)) {
            ip = String.format(SERVICE_A_RECORD_FORMAT, name, namespace);
            port = KuberntesServiceUrlResourceProvider.getPort(service, qualifiers);
        } else {
            port = KuberntesServiceUrlResourceProvider.getPort(service, qualifiers);
        }
        try {
            if (port > 0) {
                return new URL(scheme, ip, port, path);
            }
            return new URL(scheme, ip, path);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot resolve URL for service: [" + name + "] in namespace:[" + namespace + "].");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceProvider getNext() {
        if (this.next != null) {
            return this.next;
        }
        KuberntesServiceUrlResourceProvider kuberntesServiceUrlResourceProvider = this;
        synchronized (kuberntesServiceUrlResourceProvider) {
            Collection providers = ((ServiceLoader)this.serviceLoader.get()).all(ResourceProvider.class);
            for (ResourceProvider provider : providers) {
                if (provider instanceof KuberntesServiceUrlResourceProvider || !provider.canProvide(URL.class)) continue;
                this.next = provider;
                break;
            }
        }
        return this.next;
    }

    private int portForward(Session session, String podName, int targetPort, String namespace) {
        return this.portForward(session, podName, KuberntesServiceUrlResourceProvider.findRandomFreeLocalPort(), targetPort, namespace);
    }

    private int portForward(Session session, String podName, int sourcePort, int targetPort, String namespace) {
        try {
            final PortForwarder portForwarder = new PortForwarder(((ConfigBuilder)new ConfigBuilder(this.getClient().getConfiguration()).withNamespace(namespace)).build(), podName);
            final PortForwarder.PortForwardServer server = portForwarder.forwardPort(sourcePort, targetPort);
            session.addListener(new SessionListener(){

                @Override
                public void onClose() {
                    server.close();
                    portForwarder.close();
                }
            });
            return sourcePort;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

