/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.enricher.external;

import io.fabric8.kubernetes.clnt.v3_1.Config;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClient;
import io.fabric8.openshift.clnt.v3_1.DefaultOpenShiftClient;
import io.fabric8.openshift.clnt.v3_1.OpenShiftClient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.arquillian.cube.kubernetes.impl.enricher.AbstractKubernetesResourceProvider;
import org.jboss.arquillian.test.api.ArquillianResource;

public class OpenshiftClientResourceProvider
extends AbstractKubernetesResourceProvider {
    public boolean canProvide(Class<?> type) {
        return this.internalToUserType(OpenShiftClient.class.getName()).equals(type.getName());
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        KubernetesClient client = this.getClient();
        if (client == null) {
            throw new IllegalStateException("Unable to inject Kubernetes client into test.");
        }
        if (!client.isAdaptable(OpenShiftClient.class).booleanValue()) {
            throw new IllegalStateException("Could not adapt to OpenShiftClient.");
        }
        return this.createUserClient((OpenShiftClient)client.adapt(OpenShiftClient.class));
    }

    private Object createUserClient(OpenShiftClient client) {
        Config config = client.getConfiguration();
        Object userConfig = this.toUsersResource(config);
        Class userConfigClass = this.loadClass(this.internalToUserType(config.getClass().getName()));
        Class userClientClass = this.loadClass(this.internalToUserType(DefaultOpenShiftClient.class.getName()));
        try {
            Constructor constructor = userClientClass.getConstructor(userConfigClass);
            return constructor.newInstance(userConfig);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

