/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.resources;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.arquillian.cube.openshift.api.Template;
import org.arquillian.cube.openshift.impl.adapter.OpenShiftAdapter;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.resources.OpenShiftResourceFactory;
import org.arquillian.cube.openshift.impl.resources.TemplateProcessor;
import org.jboss.arquillian.test.spi.TestClass;

public class MethodTemplateProcessor
extends TemplateProcessor<Method> {
    private static final Logger LOGGER = Logger.getLogger(MethodTemplateProcessor.class.getName());
    private final Method testMethod;

    public MethodTemplateProcessor(OpenShiftAdapter openShiftAdapter, CubeOpenShiftConfiguration configuration, TestClass testClass, Method testMethod) {
        this.openShiftAdapter = openShiftAdapter;
        this.configuration = configuration;
        this.testClass = testClass;
        this.testMethod = testMethod;
    }

    @Override
    public List<Template> getTemplates() {
        return this.templates;
    }

    @Override
    protected String templateKeyPrefix() {
        return OpenShiftResourceFactory.createResourceKey(this.testClass.getJavaClass(), this.testMethod);
    }

    @Override
    protected String asynchronousDelayErrorMessage() {
        return String.format("Error waiting for template resources to deploy from class %s method %s", this.testClass.getName(), this.testMethod.getName());
    }

    @Override
    protected String noTemplateMessage() {
        return String.format("No template specified for class %s method %s", this.testClass.getName(), this.testMethod.getName());
    }

    @Override
    protected Method getType() {
        return this.testMethod;
    }

    @Override
    protected Map<String, String> scopeLabels() {
        String testMethodLabel = this.testMethod.getName().toLowerCase();
        return Collections.singletonMap("test-method", testMethodLabel);
    }

    @Override
    protected void handleExceptionForCreatingResource() throws Exception {
        OpenShiftResourceFactory.deleteTemplates(this.templateKeyPrefix(), this.templates, this.openShiftAdapter, this.configuration);
        OpenShiftResourceFactory.additionalCleanup(this.openShiftAdapter, this.scopeLabels());
    }

    @Override
    protected Logger logger() {
        return LOGGER;
    }
}

