/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;

public final class BytecodeUtils {
    private static final MethodFilter FINALIZE_FILTER = new MethodFilter(){

        public boolean isHandled(Method m) {
            return !"finalize".equals(m.getName()) || m.getParameterTypes().length != 0;
        }
    };

    public static <T> T proxy(Class<T> expected, MethodHandler handler) {
        return BytecodeUtils.proxy(expected, handler, null, null);
    }

    public static <T> T proxy(Class<T> expected, MethodHandler handler, Class<?>[] paramTypes, Object[] args) {
        Class[] interfaces = null;
        Class<T> superClass = null;
        if (expected.isInterface()) {
            interfaces = new Class[]{expected};
        } else {
            superClass = expected;
        }
        return BytecodeUtils.proxy(expected, interfaces, superClass, handler, paramTypes, args);
    }

    public static <T> T proxy(Class<T> expected, Class<?>[] interfaces, Class<?> superClass, MethodHandler handler, Class<?>[] paramTypes, Object[] args) {
        if (expected == null) {
            throw new IllegalArgumentException("Null expected class!");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Null method handler!");
        }
        InternalProxyFactory factory = new InternalProxyFactory(expected.getClassLoader());
        factory.setFilter(FINALIZE_FILTER);
        if (interfaces != null && interfaces.length > 0) {
            factory.setInterfaces(interfaces);
        }
        if (superClass != null) {
            factory.setSuperclass(superClass);
        }
        Class<?> proxyClass = BytecodeUtils.getProxyClass(factory);
        try {
            Proxy proxy;
            if (paramTypes == null || paramTypes.length == 0) {
                proxy = (Proxy)proxyClass.newInstance();
            } else {
                Constructor<?> ctor = proxyClass.getConstructor(paramTypes);
                proxy = (Proxy)ctor.newInstance(args);
            }
            proxy.setHandler(handler);
            return expected.cast(proxy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T narrow(Class<T> expected, final T target) {
        return BytecodeUtils.proxy(expected, new MethodHandler(){

            public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
                return method.invoke(target, args);
            }
        });
    }

    protected static Class<?> getProxyClass(ProxyFactory factory) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return factory.createClass();
        }
        return (Class)AccessController.doPrivileged(new ClassCreator(factory));
    }

    private static class InternalProxyFactory
    extends ProxyFactory {
        private final ClassLoader classLoader;

        private InternalProxyFactory(ClassLoader classLoader) {
            if (classLoader == null) {
                classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.classLoader = classLoader;
        }

        protected ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }

    protected static class ClassCreator
    implements PrivilegedAction<Class<?>> {
        private ProxyFactory factory;

        public ClassCreator(ProxyFactory factory) {
            this.factory = factory;
        }

        @Override
        public Class<?> run() {
            return this.factory.createClass();
        }
    }
}

