/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;

public class ReflectionUtils {
    public static Method findDeploymentMethod(Class<?> clazz) {
        List<Method> methods = ReflectionUtils.findDeploymentMethods(clazz);
        return methods.size() == 0 ? null : methods.iterator().next();
    }

    public static List<Method> findDeploymentMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ReflectionUtils.findAnnotatedMethods(clazz, Deployment.class, methods);
        return methods;
    }

    public static Method findAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ReflectionUtils.findAnnotatedMethods(clazz, annotationClass, methods);
        return methods.size() == 0 ? null : (Method)methods.iterator().next();
    }

    public static void findAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationClass, List<Method> list) {
        Method[] methods;
        if (clazz == Object.class) {
            return;
        }
        for (Method m : methods = clazz.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || !m.isAnnotationPresent(annotationClass) || ReflectionUtils.getParameterCount(m) != 0 || m.isBridge()) continue;
            list.add(m);
        }
        ReflectionUtils.findAnnotatedMethods(clazz.getSuperclass(), annotationClass, list);
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationClass) {
        if (clazz == Object.class) {
            return null;
        }
        T annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return ReflectionUtils.findAnnotation(clazz.getSuperclass(), annotationClass);
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return clazz != Object.class && (clazz.isAnnotationPresent(annotationClass) || ReflectionUtils.isAnnotationPresent(clazz.getSuperclass(), annotationClass));
    }

    public static <T> T invoke(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object instance, Object[] args, Class<T> returnType) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return returnType.cast(method.invoke(instance, args));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static int getParameterCount(Method method) {
        return method.getParameterTypes().length;
    }
}

