/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.recorder;

import java.util.UUID;
import org.arquillian.extension.recorder.DefaultFileNameBuilder;
import org.arquillian.extension.recorder.ResourceIdentifier;
import org.arquillian.extension.recorder.ResourceType;

public class ContainerAwareFileNameBuilder
extends DefaultFileNameBuilder {
    public ContainerAwareFileNameBuilder(final String containerQualifier) {
        this.withResourceIdentifier(new ResourceIdentifier<ResourceType>(){

            @Override
            public String getIdentifier(ResourceType resourceType) {
                StringBuilder sb = new StringBuilder();
                if (containerQualifier != null && !containerQualifier.isEmpty()) {
                    sb.append(containerQualifier);
                    sb.append("_");
                }
                if (ContainerAwareFileNameBuilder.this.metaData == null || ContainerAwareFileNameBuilder.this.metaData.getTestMethodName() == null || ContainerAwareFileNameBuilder.this.metaData.getTestMethodName().isEmpty()) {
                    sb.append(UUID.randomUUID().toString());
                } else {
                    sb.append(ContainerAwareFileNameBuilder.this.metaData.getTestMethodName());
                }
                if (ContainerAwareFileNameBuilder.this.when != null) {
                    sb.append("_");
                    sb.append(ContainerAwareFileNameBuilder.this.when.toString());
                }
                if (resourceType != null) {
                    sb.append(".");
                    sb.append(resourceType.toString());
                }
                return sb.toString();
            }
        });
    }
}

