/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.recorder;

import java.util.UUID;
import org.arquillian.extension.recorder.AbstractFileNameBuilder;
import org.arquillian.extension.recorder.ResourceIdentifier;
import org.arquillian.extension.recorder.ResourceMetaData;
import org.arquillian.extension.recorder.ResourceType;
import org.arquillian.extension.recorder.When;

public class DefaultFileNameBuilder
extends AbstractFileNameBuilder {
    protected ResourceMetaData metaData;
    protected When when;
    protected ResourceIdentifier<ResourceType> resourceIdentifier;

    public DefaultFileNameBuilder() {
        this.setDefaultFileIdentifier();
    }

    public DefaultFileNameBuilder withMetaData(ResourceMetaData metaData) {
        this.metaData = metaData;
        return this;
    }

    public DefaultFileNameBuilder withStage(When when) {
        this.when = when;
        return this;
    }

    public DefaultFileNameBuilder withResourceIdentifier(ResourceIdentifier<ResourceType> resourceIdentifier) {
        if (resourceIdentifier != null) {
            this.resourceIdentifier = resourceIdentifier;
        }
        return this;
    }

    @Override
    public String build() {
        ResourceType resourceType = null;
        if (this.metaData != null) {
            resourceType = this.metaData.getResourceType();
        }
        String id = this.resourceIdentifier.getIdentifier(resourceType);
        this.clear();
        return id;
    }

    @Override
    public DefaultFileNameBuilder clear() {
        this.metaData = null;
        this.when = null;
        return this;
    }

    private void setDefaultFileIdentifier() {
        this.resourceIdentifier = new ResourceIdentifier<ResourceType>(){

            @Override
            public String getIdentifier(ResourceType resourceType) {
                StringBuilder sb = new StringBuilder();
                if (DefaultFileNameBuilder.this.metaData == null || DefaultFileNameBuilder.this.metaData.getTestMethodName() == null || DefaultFileNameBuilder.this.metaData.getTestMethodName().isEmpty()) {
                    sb.append(UUID.randomUUID().toString());
                } else {
                    sb.append(DefaultFileNameBuilder.this.metaData.getTestMethodName());
                }
                if (DefaultFileNameBuilder.this.when != null) {
                    sb.append("_");
                    sb.append(DefaultFileNameBuilder.this.when.toString());
                }
                if (resourceType != null) {
                    sb.append(".");
                    sb.append(resourceType.toString());
                }
                return sb.toString();
            }
        };
    }
}

