/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.recorder;

import java.io.File;
import java.util.logging.Logger;
import org.arquillian.extension.recorder.ResourceType;
import org.jboss.arquillian.core.spi.Validate;

public final class RecorderFileUtils {
    private static final Logger LOGGER = Logger.getLogger(RecorderFileUtils.class.getName());

    private RecorderFileUtils() {
        throw new UnsupportedOperationException("no instantiation");
    }

    public static File checkFileExtension(File file, ResourceType type) {
        Validate.notNull((Object)file, (String)"file to check can not be null");
        Validate.notNull((Object)type, (String)"type can not be null");
        if (file.getName().isEmpty()) {
            throw new IllegalArgumentException("File name you are going to save the image to can not be empty.");
        }
        if (!file.getName().endsWith("." + type.toString())) {
            file = new File(file.getParent(), file.getName().concat("." + type.toString()));
        }
        return file;
    }

    public static void createDirectory(File file) {
        if (!file.exists()) {
            try {
                if (!file.mkdirs()) {
                    throw new IllegalStateException("Unable to create directory " + file.getAbsolutePath());
                }
            }
            catch (SecurityException ex) {
                LOGGER.warning("Unable to create directory due to security exception: " + ex.getMessage());
            }
        }
    }
}

