/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.recorder;

import java.lang.reflect.Method;
import org.arquillian.extension.recorder.ResourceType;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.TestResult;

public abstract class ResourceMetaData {
    private TestResult testResult;
    private TestClass testClass;
    private Method testMethod;
    private long timeStamp;
    private String optionalDescription;
    private ResourceType resourceType;

    public String getTestClassName() {
        return this.getTestClass() == null ? null : this.getTestClass().getName();
    }

    public TestClass getTestClass() {
        return this.testClass;
    }

    public ResourceMetaData setTestClass(TestClass testClass) {
        Validate.notNull((Object)testClass, (String)"Test class is a null object!");
        this.testClass = testClass;
        return this;
    }

    public String getTestMethodName() {
        return this.getTestMethod() == null ? null : this.getTestMethod().getName();
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    public ResourceMetaData setTestMethod(Method testMethod) {
        Validate.notNull((Object)testMethod, (String)"Method is a null object!");
        this.testMethod = testMethod;
        return this;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public ResourceMetaData setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    public ResourceMetaData setTestResult(TestResult testResult) {
        Validate.notNull((Object)testResult, (String)"TestResult is a null object!");
        this.testResult = testResult;
        return this;
    }

    public TestResult getTestResult() {
        return this.testResult;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getOptionalDescription() {
        return this.optionalDescription;
    }

    public void setOptionalDescription(String optionalDescription) {
        Validate.notNull((Object)optionalDescription, (String)"OptionalDescription is null!");
        this.optionalDescription = optionalDescription;
    }

    public void setResourceType(ResourceType resourceType) {
        Validate.notNull((Object)resourceType, (String)"ResourceType is null!");
        this.resourceType = resourceType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("test class\t\t:\n").append(this.getTestClass()).append("test method\t\t:\n").append(this.getTestMethod()).append("timestamp\t\t:\n").append(this.getTimeStamp()).append(this.optionalDescription.isEmpty() ? "" : "payload\t\t:\n" + this.optionalDescription);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.optionalDescription == null ? 0 : this.optionalDescription.hashCode());
        result = 31 * result + (this.resourceType == null ? 0 : this.resourceType.hashCode());
        result = 31 * result + (this.testClass == null ? 0 : this.testClass.hashCode());
        result = 31 * result + (this.testMethod == null ? 0 : this.testMethod.hashCode());
        result = 31 * result + (this.testResult == null ? 0 : this.testResult.hashCode());
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceMetaData other = (ResourceMetaData)obj;
        if (this.optionalDescription == null ? other.optionalDescription != null : !this.optionalDescription.equals(other.optionalDescription)) {
            return false;
        }
        if (this.resourceType == null ? other.resourceType != null : !this.resourceType.equals(other.resourceType)) {
            return false;
        }
        if (this.testClass == null ? other.testClass != null : !this.testClass.equals(other.testClass)) {
            return false;
        }
        if (this.testMethod == null ? other.testMethod != null : !this.testMethod.equals(other.testMethod)) {
            return false;
        }
        if (this.testResult == null ? other.testResult != null : !this.testResult.equals(other.testResult)) {
            return false;
        }
        return this.timeStamp == other.timeStamp;
    }
}

