/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.recorder.screenshooter;

import java.io.File;
import org.arquillian.extension.recorder.Configuration;
import org.arquillian.extension.recorder.screenshooter.ScreenshooterConfigurationException;
import org.arquillian.extension.recorder.screenshooter.ScreenshotType;
import org.arquillian.recorder.reporter.ReporterConfiguration;

public class ScreenshooterConfiguration
extends Configuration<ScreenshooterConfiguration> {
    private static final String ROOT_DIR = "target/screenshots";
    private static final String SCREENSHOT_TYPE = ScreenshotType.PNG.toString();
    private static final String TAKE_BEFORE_TEST = "false";
    private static final String TAKE_AFTER_TEST = "false";
    private static final String TAKE_WHEN_TEST_FAILED = "true";
    private final ReporterConfiguration reporterConfiguration;

    public ScreenshooterConfiguration(ReporterConfiguration reporterConfiguration) {
        this.reporterConfiguration = reporterConfiguration;
    }

    public File getRootDir() {
        return new File(this.getProperty("rootDir", ROOT_DIR));
    }

    public String getScreenshotType() {
        return this.getProperty("screenshotType", SCREENSHOT_TYPE).toUpperCase();
    }

    public boolean getTakeBeforeTest() {
        return Boolean.parseBoolean(this.getProperty("takeBeforeTest", "false"));
    }

    public boolean getTakeAfterTest() {
        return Boolean.parseBoolean(this.getProperty("takeAfterTest", "false"));
    }

    public boolean getTakeWhenTestFailed() {
        return Boolean.parseBoolean(this.getProperty("takeWhenTestFailed", TAKE_WHEN_TEST_FAILED));
    }

    public void validate() throws ScreenshooterConfigurationException {
        this.validate(this.reporterConfiguration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-40s %s%n", "rootDir", this.getRootDir()));
        sb.append(String.format("%-40s %s%n", "screenshotType", this.getScreenshotType()));
        sb.append(String.format("%-40s %s%n", "takeBeforeTest", this.getTakeBeforeTest()));
        sb.append(String.format("%-40s %s%n", "takeAfterTest", this.getTakeAfterTest()));
        sb.append(String.format("%-40s %s%n", "takeWhenTestFailed", this.getTakeWhenTestFailed()));
        return sb.toString();
    }

    private void validate(ReporterConfiguration reporterConfiguration) {
        try {
            ScreenshotType.valueOf(ScreenshotType.class, this.getScreenshotType());
        }
        catch (IllegalArgumentException ex) {
            throw new ScreenshooterConfigurationException("Screenshot type you specified in arquillian.xml is not valid screenshot type. The configured screenshot type is: " + this.getScreenshotType() + ". " + "The supported screenshot types are: " + ScreenshotType.getAll(), ex);
        }
        String report = reporterConfiguration.getReport().toLowerCase();
        if (report.contains("htm") || report.contains("ad") || report.equals("asciidoc")) {
            File screenshooterRootDir = new File(reporterConfiguration.getRootDir(), "screenshots");
            if (!this.getRootDir().equals(screenshooterRootDir)) {
                this.setProperty("rootDir", screenshooterRootDir.getAbsolutePath());
            }
        }
        try {
            if (!this.getRootDir().exists()) {
                boolean created = this.getRootDir().mkdir();
                if (!created) {
                    throw new ScreenshooterConfigurationException("Unable to create root directory " + this.getRootDir().getAbsolutePath());
                }
            } else {
                if (!this.getRootDir().isDirectory()) {
                    throw new ScreenshooterConfigurationException("Root directory you specified is not a directory - " + this.getRootDir().getAbsolutePath());
                }
                if (!this.getRootDir().canWrite()) {
                    throw new ScreenshooterConfigurationException("You can not write to '" + this.getRootDir().getAbsolutePath() + "'.");
                }
            }
        }
        catch (SecurityException ex) {
            throw new ScreenshooterConfigurationException("You are not permitted to operate on specified resource: " + this.getRootDir().getAbsolutePath() + "'.", ex);
        }
    }
}

