/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.recorder.screenshooter.api;

import com.jhlabs.image.BoxBlurFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public enum BlurLevel {
    NONE{

        @Override
        public BufferedImage blur(BufferedImage image) {
            return image;
        }
    }
    ,
    LOW{

        @Override
        public BufferedImage blur(BufferedImage image) {
            return this.blur(image, 10);
        }
    }
    ,
    MEDIUM{

        @Override
        public BufferedImage blur(BufferedImage image) {
            return this.blur(image, 15);
        }
    }
    ,
    HIGH{

        @Override
        public BufferedImage blur(BufferedImage image) {
            return this.blur(image, 25);
        }
    };


    protected BufferedImage blur(BufferedImage srcImage, int radius) {
        BufferedImage destImage = BlurLevel.deepCopy(srcImage);
        BoxBlurFilter boxBlurFilter = new BoxBlurFilter();
        boxBlurFilter.setRadius(radius);
        boxBlurFilter.setIterations(3);
        destImage = boxBlurFilter.filter(srcImage, destImage);
        return destImage;
    }

    private static BufferedImage deepCopy(BufferedImage srcImage) {
        ColorModel cm = srcImage.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = srcImage.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public abstract BufferedImage blur(BufferedImage var1);
}

