/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.recorder.video;

import java.io.File;
import org.arquillian.extension.recorder.Configuration;
import org.arquillian.extension.recorder.video.VideoConfigurationException;
import org.arquillian.extension.recorder.video.VideoType;
import org.arquillian.recorder.reporter.ReporterConfiguration;

public class VideoConfiguration
extends Configuration<VideoConfiguration> {
    private static final String ROOT_DIR = "target/videos";
    private static final String VIDEO_TYPE = VideoType.MP4.name();
    private static final String START_BEFORE_TEST = "false";
    private static final String START_BEFORE_CLASS = "false";
    private static final String START_BEFORE_SUITE = "false";
    private static final String TAKE_ONLY_ON_FAIL = "true";
    private static final String VIDEO_NAME = "record";
    private static final String TEST_TIMEOUT = "1800";
    private static final String WIDTH = "0";
    private static final String HEIGHT = "0";
    private final ReporterConfiguration reporterConfiguration;

    public VideoConfiguration(ReporterConfiguration reporterConfiguration) {
        this.reporterConfiguration = reporterConfiguration;
    }

    public boolean getTakeOnlyOnFail() {
        return Boolean.parseBoolean(this.getProperty("takeOnlyOnFail", TAKE_ONLY_ON_FAIL));
    }

    public int getTestTimeout() {
        return Integer.parseInt(this.getProperty("testTimeout", TEST_TIMEOUT));
    }

    public String getVideoName() {
        return this.getProperty("videoName", VIDEO_NAME);
    }

    public File getRootDir() {
        return new File(this.getProperty("rootDir", ROOT_DIR));
    }

    public String getVideoType() {
        return this.getProperty("videoType", VIDEO_TYPE).toUpperCase();
    }

    public boolean getStartBeforeTest() {
        return Boolean.parseBoolean(this.getProperty("startBeforeTest", "false"));
    }

    public boolean getStartBeforeClass() {
        return Boolean.parseBoolean(this.getProperty("startBeforeClass", "false"));
    }

    public boolean getStartBeforeSuite() {
        return Boolean.parseBoolean(this.getProperty("startBeforeSuite", "false"));
    }

    public int getHeight() {
        return Integer.parseInt(this.getProperty("height", "0"));
    }

    public int getWidth() {
        return Integer.parseInt(this.getProperty("width", "0"));
    }

    public void validate() throws VideoConfigurationException {
        this.validate(this.reporterConfiguration);
    }

    private void validate(ReporterConfiguration reporterConfiguration) {
        try {
            VideoType.valueOf(VideoType.class, this.getVideoType());
        }
        catch (IllegalArgumentException ex) {
            throw new VideoConfigurationException("Video type you specified in arquillian.xml is not valid video type. The configured video type is: " + this.getVideoType() + ". " + "The supported video types are: " + VideoType.getAll());
        }
        String report = reporterConfiguration.getReport().toLowerCase();
        if (report.contains("htm") || report.contains("ad") || report.equals("asciidoc")) {
            File recorderRootDir = new File(reporterConfiguration.getRootDir(), "videos");
            if (!this.getRootDir().equals(recorderRootDir)) {
                this.setProperty("rootDir", recorderRootDir.getAbsolutePath());
            }
        }
        try {
            if (!this.getRootDir().exists()) {
                boolean created = this.getRootDir().mkdir();
                if (!created) {
                    throw new VideoConfigurationException("Unable to create root directory " + this.getRootDir().getAbsolutePath());
                }
            } else {
                if (!this.getRootDir().isDirectory()) {
                    throw new VideoConfigurationException("Root directory you specified is not a directory - " + this.getRootDir().getAbsolutePath());
                }
                if (!this.getRootDir().canWrite()) {
                    throw new VideoConfigurationException("You can not write to '" + this.getRootDir().getAbsolutePath() + "'.");
                }
            }
        }
        catch (SecurityException ex) {
            throw new VideoConfigurationException("You are not permitted to operate on specified resource: " + this.getRootDir().getAbsolutePath() + "'.", ex);
        }
        try {
            if (Integer.parseInt(this.getProperty("width", "0")) < 0) {
                throw new VideoConfigurationException("It seems you have set width of video to be lower then 0.");
            }
        }
        catch (NumberFormatException ex) {
            throw new VideoConfigurationException("Provided width of video is not recognized to be an integer number.");
        }
        try {
            if (Integer.parseInt(this.getProperty("height", "0")) < 0) {
                throw new VideoConfigurationException("It seems you have set height of video to be lower then 0.");
            }
        }
        catch (NumberFormatException ex) {
            throw new VideoConfigurationException("Provided height of video is not recognized to be an integer number.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-40s %s%n", "startBeforeSuite", this.getStartBeforeSuite()));
        sb.append(String.format("%-40s %s%n", "startBeforeClass", this.getStartBeforeClass()));
        sb.append(String.format("%-40s %s%n", "startBeforeTest", this.getStartBeforeTest()));
        sb.append(String.format("%-40s %s%n", "takeOnlyOnFail", this.getTakeOnlyOnFail()));
        sb.append(String.format("%-40s %s%n", "testTimeOut", this.getTestTimeout()));
        sb.append(String.format("%-40s %s%n", "rootDir", this.getRootDir()));
        sb.append(String.format("%-40s %s%n", "videoName", this.getVideoName()));
        sb.append(String.format("%-40s %s%n", "videoType", this.getVideoType()));
        sb.append(String.format("%-40s %s%n", "width", this.getWidth()));
        sb.append(String.format("%-40s %s%n", "height", this.getHeight()));
        return sb.toString();
    }
}

