/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.os;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessInteraction;
import org.arquillian.spacelift.process.ProcessInteractionBuilder;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.os.ConsumeProcessOutputTask;
import org.arquillian.spacelift.task.os.ProcessBasedExecution;
import org.arquillian.spacelift.task.os.ProcessReference;
import org.arquillian.spacelift.task.os.SpawnProcessTask;
import org.arquillian.spacelift.task.os.Validate;

public class CommandTool
extends Task<Object, ProcessResult> {
    public static final File CURRENT_USER_DIR = null;
    protected CommandBuilder commandBuilder;
    protected ProcessInteraction interaction = ProcessInteractionBuilder.NO_INTERACTION;
    protected List<Integer> allowedExitCodes = new ArrayList<Integer>();
    protected File workingDirectory = null;
    protected Map<String, String> environment = new HashMap<String, String>();
    protected boolean isDaemon = false;
    protected ProcessReference processRef;

    public CommandTool programName(CharSequence programName) throws IllegalArgumentException {
        Validate.notNullOrEmpty(programName, "Program name must not be empty nor null");
        this.commandBuilder = new CommandBuilder(programName);
        return this;
    }

    public CommandTool parameters(List<? extends CharSequence> parameters) {
        this.commandBuilder.parameters(parameters);
        return this;
    }

    public CommandTool parameters(CharSequence ... parameters) {
        this.commandBuilder.parameters(parameters);
        return this;
    }

    public CommandTool parameter(CharSequence parameter) {
        this.commandBuilder.parameter(parameter);
        return this;
    }

    public CommandTool splitToParameters(CharSequence sequenceToBeParsed) {
        this.commandBuilder.splitToParameters(sequenceToBeParsed);
        return this;
    }

    public CommandTool interaction(ProcessInteraction interaction) {
        this.interaction = interaction;
        return this;
    }

    public CommandTool interaction(ProcessInteractionBuilder interactionBuilder) {
        this.interaction = interactionBuilder.build();
        return this;
    }

    public CommandTool command(Command command) {
        this.commandBuilder = new CommandBuilder((CharSequence[])command.getFullCommand().toArray(new String[0]));
        return this;
    }

    public CommandTool command(CommandBuilder commandBuilder) {
        this.commandBuilder = commandBuilder;
        return this;
    }

    public CommandTool shouldExitWith(Integer ... exitCodes) {
        if (exitCodes.length > 0) {
            this.allowedExitCodes.addAll(Arrays.asList(exitCodes));
        }
        return this;
    }

    public CommandTool workingDirectory(File workingDirectory) throws IllegalArgumentException {
        if (workingDirectory == null) {
            this.workingDirectory = null;
            return this;
        }
        if (!workingDirectory.exists()) {
            throw new IllegalArgumentException("Specified path " + workingDirectory.getAbsolutePath() + " does not exist!");
        }
        if (!workingDirectory.isDirectory()) {
            throw new IllegalArgumentException("Specified path " + workingDirectory.getAbsolutePath() + " is not a directory!");
        }
        this.workingDirectory = workingDirectory;
        return this;
    }

    public CommandTool workingDirectory(String workingDirectory) throws IllegalArgumentException {
        if (workingDirectory == null) {
            this.workingDirectory = null;
            return this;
        }
        return this.workingDirectory(new File(workingDirectory));
    }

    @Deprecated
    public CommandTool workingDir(String workingDirectory) throws IllegalArgumentException {
        return this.workingDirectory(workingDirectory);
    }

    public CommandTool addEnvironment(Map<? extends CharSequence, ? extends CharSequence> envVariables) throws IllegalArgumentException {
        Validate.notNull(envVariables, "Environment variables must not be null");
        for (Map.Entry<? extends CharSequence, ? extends CharSequence> entry : envVariables.entrySet()) {
            Validate.notNull(entry.getKey(), "Environment variable name must not be null nor empty");
            CharSequence value = entry.getValue();
            this.environment.put(entry.getKey().toString(), value != null ? value.toString() : null);
        }
        return this;
    }

    public CommandTool addEnvironment(CharSequence ... envVariables) throws IllegalArgumentException {
        if (envVariables.length % 2 == 1) {
            throw new IllegalArgumentException("Environment variables must be a sequence of key, value pairs.");
        }
        for (int i = 0; i < envVariables.length / 2; i += 2) {
            CharSequence key = envVariables[i];
            CharSequence value = envVariables[i + 1];
            Validate.notNull(key, "Environment variable name must not be null nor empty");
            this.environment.put(key.toString(), value != null ? value.toString() : null);
        }
        return this;
    }

    public CommandTool runAsDaemon() {
        this.isDaemon = true;
        return this;
    }

    public Execution<ProcessResult> execute() throws ExecutionException {
        this.processRef = new ProcessReference(this.commandBuilder.build().getProgramName());
        Execution processFutureExecution = super.execute();
        ProcessBasedExecution<ProcessResult> execution = new ProcessBasedExecution<ProcessResult>(processFutureExecution, this.processRef, this.commandBuilder.build().getProgramName(), this.allowedExitCodes);
        return execution;
    }

    protected ProcessResult process(Object input) throws Exception {
        Validate.executionNotNull(this.commandBuilder, "Command must not be null", new Object[0]);
        Command command = this.commandBuilder.build();
        Process process = null;
        Execution<Process> spawnedProcess = ((SpawnProcessTask)Spacelift.task(SpawnProcessTask.class)).redirectErrorStream(true).shouldExitWith(this.allowedExitCodes).command(command).workingDirectory(this.workingDirectory).addEnvironment(this.environment).runAsDaemon(this.isDaemon).execute();
        process = (Process)spawnedProcess.await();
        this.processRef.setProcess(process);
        Execution processConsumer = ((ConsumeProcessOutputTask)Spacelift.task(spawnedProcess, ConsumeProcessOutputTask.class)).programName(command.getProgramName()).interaction(this.interaction).execute();
        ProcessResult result = (ProcessResult)processConsumer.await();
        if (spawnedProcess.hasFailed()) {
            StringBuilder env = new StringBuilder();
            for (Map.Entry<String, String> envVar : this.environment.entrySet()) {
                env.append(envVar.getKey()).append("=\"").append(envVar.getValue()).append("\" ");
            }
            StringBuilder output = new StringBuilder();
            List outputList = result.output();
            int from = outputList.size() > 50 ? outputList.size() - 50 : 0;
            for (String s : outputList.subList(from, outputList.size())) {
                output.append("\n").append(s);
            }
            throw new ExecutionException("Invocation of \"{3} {0}\" failed with {1}, logged (last 50 lines): {2}", new Object[]{command, result.exitValue(), output, env});
        }
        return result;
    }
}

