/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter;

import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XTextGraphicObjectsSupplier;
import com.sun.star.util.XRefreshable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.artofsolving.jodconverter.AbstractConversionTask;
import org.artofsolving.jodconverter.OfficeDocumentUtils;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.artofsolving.jodconverter.office.OfficeContext;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeUtils;

public class StandardConversionTask
extends AbstractConversionTask {
    private final DocumentFormat outputFormat;
    private Map<String, ?> defaultLoadProperties;
    private DocumentFormat inputFormat;

    public StandardConversionTask(File inputFile, File outputFile, DocumentFormat outputFormat) {
        super(inputFile, outputFile);
        this.outputFormat = outputFormat;
    }

    public void setDefaultLoadProperties(Map<String, ?> defaultLoadProperties) {
        this.defaultLoadProperties = defaultLoadProperties;
    }

    public void setInputFormat(DocumentFormat inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Override
    protected void modifyDocument(XComponent document, OfficeContext context) throws OfficeException {
        XRefreshable refreshable = OfficeUtils.cast(XRefreshable.class, document);
        if (refreshable != null) {
            refreshable.refresh();
        }
        if (OfficeUtils.cast(XServiceInfo.class, document).supportsService("com.sun.star.text.GenericTextDocument")) {
            this.embedWriterImages(document, context);
        }
    }

    private void embedWriterImages(XComponent document, OfficeContext context) {
        XIndexAccess indexAccess = OfficeUtils.cast(XIndexAccess.class, OfficeUtils.cast(XTextGraphicObjectsSupplier.class, document).getGraphicObjects());
        XGraphicProvider graphicProvider = OfficeUtils.cast(XGraphicProvider.class, context.getService("com.sun.star.graphic.GraphicProvider"));
        PropertyValue[] queryProperties = new PropertyValue[]{new PropertyValue()};
        queryProperties[0].Name = "URL";
        for (int i = 0; i < indexAccess.getCount(); ++i) {
            try {
                XPropertySet graphicProperties = OfficeUtils.cast(XPropertySet.class, indexAccess.getByIndex(i));
                String graphicURL = (String)graphicProperties.getPropertyValue("GraphicURL");
                if (graphicURL.contains("vnd.sun.star.GraphicObject")) continue;
                queryProperties[0].Value = graphicURL;
                Size specifiedSize = OfficeUtils.cast(Size.class, graphicProperties.getPropertyValue("ActualSize"));
                graphicProperties.setPropertyValue("Graphic", (Object)graphicProvider.queryGraphic(queryProperties));
                this.adjustImageSize(graphicProperties, specifiedSize);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void adjustImageSize(XPropertySet graphicProperties, Size specifiedSize) {
        try {
            Size size = OfficeUtils.cast(Size.class, graphicProperties.getPropertyValue("ActualSize"));
            if (specifiedSize.Width == 0 && specifiedSize.Height == 0) {
                specifiedSize.Width = size.Width;
                specifiedSize.Height = size.Height;
            } else if (specifiedSize.Width == 0) {
                specifiedSize.Width = specifiedSize.Height * size.Width / size.Height;
            } else if (specifiedSize.Height == 0) {
                specifiedSize.Height = specifiedSize.Width * size.Height / size.Width;
            }
            graphicProperties.setPropertyValue("Size", (Object)specifiedSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Map<String, ?> getLoadProperties(File inputFile) {
        HashMap loadProperties = new HashMap();
        if (this.defaultLoadProperties != null) {
            loadProperties.putAll(this.defaultLoadProperties);
        }
        if (this.inputFormat != null && this.inputFormat.getLoadProperties() != null) {
            loadProperties.putAll(this.inputFormat.getLoadProperties());
        }
        return loadProperties;
    }

    @Override
    protected Map<String, ?> getStoreProperties(File outputFile, XComponent document) {
        DocumentFamily family = OfficeDocumentUtils.getDocumentFamily(document);
        return this.outputFormat.getStoreProperties(family);
    }
}

