/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.process;

import java.io.IOException;
import org.artofsolving.jodconverter.process.ProcessManager;
import org.artofsolving.jodconverter.process.ProcessQuery;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.ProcessFinder;

public class SigarProcessManager
implements ProcessManager {
    @Override
    public long findPid(ProcessQuery query) throws IOException {
        Sigar sigar = new Sigar();
        try {
            long[] pids = ProcessFinder.find((Sigar)sigar, (String)("State.Name.eq=" + query.getCommand()));
            for (int i = 0; i < pids.length; ++i) {
                String[] arguments = sigar.getProcArgs(pids[i]);
                if (arguments == null || !this.argumentMatches(arguments, query.getArgument())) continue;
                long l = pids[i];
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (SigarException sigarException) {
            throw new IOException("findPid failed", sigarException);
        }
        finally {
            sigar.close();
        }
    }

    @Override
    public void kill(Process process, long pid) throws IOException {
        Sigar sigar = new Sigar();
        try {
            sigar.kill(pid, "KILL");
        }
        catch (SigarException sigarException) {
            throw new IOException("kill failed", sigarException);
        }
        finally {
            sigar.close();
        }
    }

    private boolean argumentMatches(String[] arguments, String expected) {
        for (String argument : arguments) {
            if (!argument.contains(expected)) continue;
            return true;
        }
        return false;
    }
}

