/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.indexing;

import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.search.SearchDocument;
import org.aspectj.org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.jdom.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.SourceIndexerRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;

public class SourceIndexer
extends AbstractIndexer
implements SuffixConstants {
    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    public void indexDocument() {
        block7: {
            SourceIndexerRequestor requestor = new SourceIndexerRequestor(this);
            String documentPath = this.document.getPath();
            SourceElementParser parser = this.document.getParser();
            if (parser == null) {
                Path path = new Path(documentPath);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                parser = JavaModelManager.getJavaModelManager().indexManager.getSourceElementParser(JavaCore.create(project), requestor);
            } else {
                parser.setRequestor(requestor);
            }
            char[] source = null;
            char[] name = null;
            try {
                source = this.document.getCharContents();
                name = documentPath.toCharArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (source == null || name == null) {
                return;
            }
            CompilationUnit compilationUnit = new CompilationUnit(source, name);
            try {
                parser.parseCompilationUnit(compilationUnit, true, null);
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block7;
                e.printStackTrace();
            }
        }
    }
}

