/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.swing.AjdeWidgetStyles;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IHierarchyListener;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;

public class SimpleStructureViewToolPanel
extends JPanel {
    private static final long serialVersionUID = -7573973278642540506L;
    private final StructureView currentView;
    private final JButton separator_button = new JButton();
    private boolean hideNonAJEnabled = false;
    private boolean hideAssociationsEnabled = false;
    private boolean sortEnabled = false;
    Border border1;
    Border border2;
    JButton structureView_button = new JButton();
    JPanel label_panel = new JPanel();
    JLabel currConfig_field = new JLabel();
    JPanel spacer_panel = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton forward_button = new JButton();
    JPanel navigation_panel = new JPanel();
    JButton back_button = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttons_panel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    public final IHierarchyListener MODEL_LISTENER = new IHierarchyListener(){

        @Override
        public void elementsUpdated(IHierarchy model) {
            String path = Ajde.getDefault().getBuildConfigManager().getActiveConfigFile();
            String fileName = "<no active config>";
            if (path != null) {
                fileName = new File(path).getName();
            }
            SimpleStructureViewToolPanel.this.updateCurrConfigLabel(fileName);
        }
    };
    JButton hideNonAJ_button = new JButton();
    JPanel navigation_panel1 = new JPanel();
    JButton hideAssociations_button = new JButton();
    BorderLayout borderLayout5 = new BorderLayout();
    JButton sort_button = new JButton();

    public SimpleStructureViewToolPanel(StructureView currentView) {
        this.currentView = currentView;
        Ajde.getDefault().getModel().addListener(this.MODEL_LISTENER);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Message msg = new Message("Could not initialize GUI.", IMessage.ERROR, e, null);
            Ajde.getDefault().getMessageHandler().handleMessage(msg);
        }
        this.updateCurrConfigLabel("<no active config>");
    }

    private void updateCurrConfigLabel(String text) {
        this.currConfig_field.setText("  File View (" + text + ")");
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(156, 156, 158), new Color(109, 109, 110));
        this.border2 = BorderFactory.createEmptyBorder(0, 1, 0, 0);
        this.separator_button.setPreferredSize(new Dimension(2, 16));
        this.separator_button.setMinimumSize(new Dimension(2, 16));
        this.separator_button.setEnabled(false);
        this.separator_button.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
        this.separator_button.setMaximumSize(new Dimension(2, 16));
        this.structureView_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleStructureViewToolPanel.this.structureView_button_actionPerformed(e);
            }
        });
        this.structureView_button.setIcon(Ajde.getDefault().getIconRegistry().getStructureViewIcon());
        this.structureView_button.setBorder(this.border2);
        this.structureView_button.setToolTipText("Navigate back");
        this.structureView_button.setPreferredSize(new Dimension(20, 20));
        this.structureView_button.setMinimumSize(new Dimension(20, 20));
        this.structureView_button.setMaximumSize(new Dimension(24, 20));
        this.currConfig_field.setBackground(SystemColor.control);
        this.currConfig_field.setFont(new Font("SansSerif", 0, 11));
        this.currConfig_field.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
        this.currConfig_field.setText("     ");
        this.forward_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleStructureViewToolPanel.this.forward_button_actionPerformed(e);
            }
        });
        this.forward_button.setIcon(Ajde.getDefault().getIconRegistry().getForwardIcon());
        this.forward_button.setToolTipText("Navigate forward");
        this.forward_button.setPreferredSize(new Dimension(20, 20));
        this.forward_button.setMinimumSize(new Dimension(20, 20));
        this.forward_button.setMaximumSize(new Dimension(24, 20));
        this.forward_button.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
        this.navigation_panel.setLayout(this.borderLayout1);
        this.back_button.setMaximumSize(new Dimension(24, 20));
        this.back_button.setMinimumSize(new Dimension(20, 20));
        this.back_button.setPreferredSize(new Dimension(20, 20));
        this.back_button.setToolTipText("Navigate back");
        this.back_button.setIcon(Ajde.getDefault().getIconRegistry().getBackIcon());
        this.back_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleStructureViewToolPanel.this.back_button_actionPerformed(e);
            }
        });
        this.back_button.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
        this.setLayout(this.borderLayout2);
        this.buttons_panel.setLayout(this.borderLayout3);
        this.label_panel.setLayout(this.borderLayout4);
        this.hideNonAJ_button.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
        this.hideNonAJ_button.setMaximumSize(new Dimension(24, 20));
        this.hideNonAJ_button.setMinimumSize(new Dimension(20, 20));
        this.hideNonAJ_button.setPreferredSize(new Dimension(20, 20));
        this.hideNonAJ_button.setToolTipText("Hide non-AspectJ members");
        this.hideNonAJ_button.setIcon(Ajde.getDefault().getIconRegistry().getHideNonAJIcon());
        this.hideNonAJ_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleStructureViewToolPanel.this.hideNonAJ_button_actionPerformed(e);
            }
        });
        this.navigation_panel1.setLayout(this.borderLayout5);
        this.hideAssociations_button.setMaximumSize(new Dimension(24, 20));
        this.hideAssociations_button.setMinimumSize(new Dimension(20, 20));
        this.hideAssociations_button.setPreferredSize(new Dimension(20, 20));
        this.hideAssociations_button.setToolTipText("Hide associations");
        this.hideAssociations_button.setIcon(Ajde.getDefault().getIconRegistry().getHideAssociationsIcon());
        this.hideAssociations_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleStructureViewToolPanel.this.hideAssociations_button_actionPerformed(e);
            }
        });
        this.hideAssociations_button.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
        this.sort_button.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
        this.sort_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleStructureViewToolPanel.this.sort_button_actionPerformed(e);
            }
        });
        this.sort_button.setIcon(Ajde.getDefault().getIconRegistry().getOrderIcon());
        this.sort_button.setToolTipText("Sort member");
        this.sort_button.setPreferredSize(new Dimension(20, 20));
        this.sort_button.setMinimumSize(new Dimension(20, 20));
        this.sort_button.setMaximumSize(new Dimension(24, 20));
        this.label_panel.add((Component)this.currConfig_field, "Center");
        this.add((Component)this.spacer_panel, "Center");
        this.add((Component)this.buttons_panel, "East");
        this.buttons_panel.add((Component)this.navigation_panel, "Center");
        this.navigation_panel.add((Component)this.back_button, "Center");
        this.navigation_panel.add((Component)this.forward_button, "East");
        this.navigation_panel.add((Component)this.jPanel2, "West");
        this.buttons_panel.add((Component)this.navigation_panel1, "West");
        this.navigation_panel1.add((Component)this.hideAssociations_button, "East");
        this.navigation_panel1.add((Component)this.hideNonAJ_button, "Center");
        this.navigation_panel1.add((Component)this.sort_button, "West");
        this.add((Component)this.label_panel, "West");
    }

    private void forward_button_actionPerformed(ActionEvent e) {
        Ajde.getDefault().getStructureViewManager().fireNavigateForwardAction(this.currentView);
    }

    private void back_button_actionPerformed(ActionEvent e) {
        Ajde.getDefault().getStructureViewManager().fireNavigateBackAction(this.currentView);
    }

    void structureView_button_actionPerformed(ActionEvent e) {
    }

    private void hideNonAJ_button_actionPerformed(ActionEvent e) {
        if (this.hideNonAJEnabled) {
            this.hideNonAJ_button.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
            this.hideNonAJEnabled = false;
            this.currentView.getViewProperties().setFilteredMemberKinds(new ArrayList());
        } else {
            this.hideNonAJ_button.setBorder(AjdeWidgetStyles.LOWERED_BEVEL_BORDER);
            this.hideNonAJEnabled = true;
            this.currentView.getViewProperties().setFilteredMemberKinds(IProgramElement.Kind.getNonAJMemberKinds());
        }
        Ajde.getDefault().getStructureViewManager().refreshView(this.currentView);
    }

    private void hideAssociations_button_actionPerformed(ActionEvent e) {
        if (this.hideAssociationsEnabled) {
            this.hideAssociations_button.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
            this.hideAssociationsEnabled = false;
            this.currentView.getViewProperties().setRelations(Ajde.getDefault().getStructureViewManager().getAvailableRelations());
        } else {
            this.hideAssociations_button.setBorder(AjdeWidgetStyles.LOWERED_BEVEL_BORDER);
            this.hideAssociationsEnabled = true;
            this.currentView.getViewProperties().setRelations(new ArrayList());
        }
        Ajde.getDefault().getStructureViewManager().refreshView(this.currentView);
    }

    private void sort_button_actionPerformed(ActionEvent e) {
        if (this.sortEnabled) {
            this.sort_button.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
            this.sortEnabled = false;
            this.currentView.getViewProperties().setSorting(StructureViewProperties.Sorting.DECLARATIONAL);
        } else {
            this.sort_button.setBorder(AjdeWidgetStyles.LOWERED_BEVEL_BORDER);
            this.sortEnabled = true;
            this.currentView.getViewProperties().setSorting(StructureViewProperties.Sorting.ALPHABETICAL);
        }
        Ajde.getDefault().getStructureViewManager().refreshView(this.currentView);
    }
}

