/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.aspectj.ajde.EditorAdapter;
import org.aspectj.ajde.EditorListener;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.tools.ajbrowser.core.BrowserErrorHandler;
import org.aspectj.tools.ajbrowser.ui.BasicEditor;

public class EditorManager {
    private EditorAdapter editor = null;
    private BasicEditor basicEditor = null;
    private ArrayList<EditorListener> editorListeners = new ArrayList();
    private Vector<EditorAdapter> editors = new Vector();
    private JPanel editor_panel = null;
    private Box editors_box = Box.createVerticalBox();

    public static boolean isShiftDown(int modifiers) {
        return 0 != (modifiers & 1);
    }

    public EditorManager(EditorAdapter ajdeEditor) {
        if (ajdeEditor instanceof BasicEditor) {
            this.basicEditor = (BasicEditor)ajdeEditor;
            this.editors.add(this.basicEditor);
            this.editors_box.add(this.basicEditor.getPanel());
            this.editor_panel = new JPanel(new BorderLayout());
            this.editor_panel.add((Component)this.editors_box, "Center");
        } else {
            this.editors.add(ajdeEditor);
            this.editor = ajdeEditor;
        }
    }

    public void addListener(EditorListener editorListener) {
        this.editorListeners.add(editorListener);
    }

    public void removeListener(EditorListener editorListener) {
        this.editorListeners.remove(editorListener);
    }

    public void notifyCurrentFileChanged(String filePath) {
        for (EditorListener editorListener : this.editorListeners) {
            editorListener.currentFileChanged(filePath);
        }
    }

    public void addViewForSourceLine(final String filePath, final int lineNumber) {
        if (this.basicEditor == null) {
            return;
        }
        this.editors_box.remove(this.basicEditor.getPanel());
        final BasicEditor newEditor = new BasicEditor();
        this.editors.add(newEditor);
        Runnable update = new Runnable(){

            public void run() {
                EditorManager.this.editors_box.add(newEditor.getPanel());
                newEditor.showSourceLine(filePath, lineNumber, true);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            update.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(update);
            }
            catch (Exception e) {
                BrowserErrorHandler.handleError("Could not add view for source line.", e);
            }
        }
    }

    public String getCurrFile() {
        if (this.basicEditor != null) {
            return this.basicEditor.getCurrFile();
        }
        return this.editor.getCurrFile();
    }

    public void showSourceLine(ISourceLocation sourceLocation, boolean highlight) {
        if (sourceLocation != null) {
            this.showSourceLine(sourceLocation.getSourceFile().getAbsolutePath(), sourceLocation.getLine(), highlight);
        }
    }

    public void showSourceLine(String filePath, int lineNumber, boolean highlight) {
        if (this.editors.size() > 1) {
            this.editors_box.removeAll();
            this.editors_box.add(this.basicEditor.getPanel());
            this.editors.removeAllElements();
            this.editors.add(this.basicEditor);
        }
        if (this.basicEditor != null) {
            this.basicEditor.showSourceLine(filePath, lineNumber, highlight);
        } else {
            this.editor.showSourceLine(filePath, lineNumber, highlight);
        }
    }

    public void pasteToCaretPos(String text) {
        if (this.basicEditor != null) {
            this.basicEditor.pasteToCaretPos(text);
        } else {
            this.editor.pasteToCaretPos(text);
        }
    }

    public void showSourcelineAnnotation(String filePath, int lineNumber, List items) {
        this.editor.showSourcelineAnnotation(filePath, lineNumber, items);
    }

    public void saveContents() {
        try {
            for (EditorAdapter editorAdapter : this.editors) {
                editorAdapter.saveContents();
            }
        }
        catch (IOException ioe) {
            BrowserErrorHandler.handleError("Editor could not save the current file.", ioe);
        }
    }

    public JPanel getEditorPanel() {
        if (this.editor_panel != null) {
            return this.editor_panel;
        }
        return this.basicEditor.getPanel();
    }
}

