/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.ajc;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.aspectj.ajdt.ajc.ConfigParser;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.apt.dispatch.AptProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.Main;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IModule;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.Dump;
import org.aspectj.weaver.WeaverMessages;

public class BuildArgParser
extends Main {
    private static final String BUNDLE_NAME = "org.aspectj.ajdt.ajc.messages";
    private static boolean LOADED_BUNDLE = false;
    private final StringBuffer errorSink;
    private IMessageHandler handler;

    public static String getUsage() {
        return BuildArgParser._bind("misc.usage", new String[]{BuildArgParser._bind("compiler.name", null)});
    }

    public static String getXOptionUsage() {
        return BuildArgParser._bind("xoption.usage", new String[]{BuildArgParser._bind("compiler.name", null)});
    }

    public BuildArgParser(PrintWriter writer, IMessageHandler handler) {
        super(writer, writer, false, null, null);
        this.errorSink = writer instanceof StringPrintWriter ? ((StringPrintWriter)writer).stringWriter.getBuffer() : null;
        this.handler = handler;
    }

    public BuildArgParser(IMessageHandler handler) {
        this(new StringPrintWriter(new StringWriter()), handler);
    }

    public AjBuildConfig genBuildConfig(String[] args) {
        AjBuildConfig config = new AjBuildConfig(this);
        this.populateBuildConfig(config, args, true, null);
        return config;
    }

    public AjBuildConfig populateBuildConfig(AjBuildConfig buildConfig, String[] args, boolean setClasspath, File configFile) {
        Dump.saveCommandLine(args);
        buildConfig.setConfigFile(configFile);
        try {
            File outjar;
            this.filenames = new String[]{""};
            AjcConfigParser parser = new AjcConfigParser(buildConfig, this.handler);
            parser.parseCommandLine(args);
            boolean swi = buildConfig.getShowWeavingInformation();
            if (this.handler instanceof CountingMessageHandler) {
                IMessageHandler delegate = ((CountingMessageHandler)this.handler).delegate;
                if (swi) {
                    delegate.dontIgnore(IMessage.WEAVEINFO);
                } else {
                    delegate.ignore(IMessage.WEAVEINFO);
                }
            }
            boolean incrementalMode = buildConfig.isIncrementalMode() || buildConfig.isIncrementalFileMode();
            ArrayList<File> xmlfileList = new ArrayList<File>();
            xmlfileList.addAll(parser.getXmlFiles());
            ArrayList<File> fileList = new ArrayList<File>();
            List<File> files = parser.getFiles();
            if (!LangUtil.isEmpty(files)) {
                if (incrementalMode) {
                    MessageUtil.error(this.handler, "incremental mode only handles source files using -sourceroots");
                } else {
                    fileList.addAll(files);
                }
            }
            ArrayList<String> javaArgList = new ArrayList<String>();
            javaArgList.add("-warn:none");
            javaArgList.add("-classpath");
            javaArgList.add(parser.classpath == null ? System.getProperty("user.dir") : parser.classpath);
            javaArgList.addAll(parser.getUnparsedArgs());
            super.configure(javaArgList.toArray(new String[javaArgList.size()]));
            if (parser.getModuleInfoArgument() != null) {
                IModule moduleDesc = super.getModuleDesc(parser.getModuleInfoArgument());
                buildConfig.setModuleDesc(moduleDesc);
            }
            if (!this.proceed) {
                buildConfig.doNotProceed();
                return buildConfig;
            }
            if (buildConfig.getSourceRoots() != null) {
                Iterator<File> i = buildConfig.getSourceRoots().iterator();
                while (i.hasNext()) {
                    fileList.addAll(this.collectSourceRootFiles(i.next()));
                }
            }
            buildConfig.setXmlFiles(xmlfileList);
            buildConfig.setFiles(fileList);
            if (this.destinationPath != null) {
                buildConfig.setOutputDir(new File(this.destinationPath));
            }
            if (setClasspath) {
                buildConfig.setClasspath(this.getClasspath(parser));
                if (this.checkVMVersion(0x350000L)) {
                    File jmods = new File(this.getJavaHome(), "jmods");
                    parser.modulepath = parser.modulepath == null ? jmods.getAbsolutePath() : parser.modulepath + File.pathSeparator + jmods.getAbsolutePath();
                }
                buildConfig.setModulepath(this.getModulepath(parser));
                buildConfig.setModulepathClasspathEntries(this.handleModulepath(parser.modulepath));
                buildConfig.setModulesourcepath(this.getModulesourcepath(parser));
                buildConfig.setModulesourcepathClasspathEntries(this.handleModuleSourcepath(parser.modulesourcepath));
                buildConfig.setBootclasspath(this.getBootclasspath(parser));
            }
            if (incrementalMode && 0 == buildConfig.getSourceRoots().size()) {
                MessageUtil.error(this.handler, "specify a source root when in incremental mode");
            }
            if ((outjar = buildConfig.getOutputJar()) != null) {
                String message;
                for (File injar : buildConfig.getInJars()) {
                    if (!injar.equals(outjar)) continue;
                    message = WeaverMessages.format("outjarInInputPath");
                    MessageUtil.error(this.handler, message);
                }
                for (File inPathElement : buildConfig.getInpath()) {
                    if (inPathElement.isDirectory() || !inPathElement.equals(outjar)) continue;
                    message = WeaverMessages.format("outjarInInputPath");
                    MessageUtil.error(this.handler, message);
                }
                for (File aspectPathElement : buildConfig.getAspectpath()) {
                    if (aspectPathElement.isDirectory() || !aspectPathElement.equals(outjar)) continue;
                    message = WeaverMessages.format("outjarInInputPath");
                    MessageUtil.error(this.handler, message);
                }
            }
            this.setDebugOptions();
            buildConfig.getOptions().set(this.options);
        }
        catch (IllegalArgumentException iae) {
            SourceLocation location = null;
            if (buildConfig.getConfigFile() != null) {
                location = new SourceLocation(buildConfig.getConfigFile(), 0);
            }
            Message m = new Message(iae.getMessage(), IMessage.ERROR, null, location);
            this.handler.handleMessage(m);
        }
        return buildConfig;
    }

    private void augmentCheckedClasspaths(List<File> extraPathEntries, String encoding) {
        if (extraPathEntries.size() == 0) {
            return;
        }
        ArrayList<String> asList = this.toArrayList(extraPathEntries);
        ArrayList<FileSystem.Classpath> newClasspathEntries = this.handleClasspath(asList, encoding);
        FileSystem.Classpath[] newCheckedClasspaths = new FileSystem.Classpath[this.checkedClasspaths.length + newClasspathEntries.size()];
        System.arraycopy(this.checkedClasspaths, 0, newCheckedClasspaths, 0, this.checkedClasspaths.length);
        for (int i = 0; i < newClasspathEntries.size(); ++i) {
            newCheckedClasspaths[i + this.checkedClasspaths.length] = (FileSystem.Classpath)newClasspathEntries.get(i);
        }
        this.checkedClasspaths = newCheckedClasspaths;
    }

    private ArrayList<String> toArrayList(List<File> files) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : files) {
            arrayList.add(file.getAbsolutePath());
        }
        return arrayList;
    }

    @Override
    public void printVersion() {
        String version = this.bind("misc.version", new String[]{this.bind("compiler.name"), "1.9.1 - Built: Friday Apr 20, 2018 at 16:47:33 GMT", this.bind("compiler.version"), this.bind("compiler.copyright")});
        System.out.println(version);
    }

    @Override
    public void addExtraProblems(CategorizedProblem problem) {
        super.addExtraProblems(problem);
        if (problem instanceof AptProblem) {
            this.handler.handleMessage(this.newAptMessage((AptProblem)problem));
        }
    }

    private IMessage newAptMessage(AptProblem problem) {
        String message = problem.getMessage();
        boolean isError = problem.isError();
        if (problem._referenceContext != null) {
            return new Message(message, new EclipseSourceLocation(problem._referenceContext.compilationResult(), problem.getSourceStart(), problem.getSourceEnd()), isError);
        }
        return new Message(message, null, isError);
    }

    @Override
    public void initializeAnnotationProcessorManager() {
        if (this.compilerOptions.complianceLevel < 0x320000L || !this.compilerOptions.processAnnotations) {
            return;
        }
        super.initializeAnnotationProcessorManager();
    }

    @Override
    public void printUsage() {
        System.out.println(BuildArgParser.getUsage());
        System.out.flush();
    }

    public String getOtherMessages(boolean flush) {
        if (null == this.errorSink) {
            return null;
        }
        String result = this.errorSink.toString().trim();
        if (0 == result.length()) {
            result = null;
        }
        if (flush) {
            this.errorSink.setLength(0);
        }
        return result;
    }

    private void setDebugOptions() {
        this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
    }

    private Collection collectSourceRootFiles(File dir) {
        return Arrays.asList(FileUtil.listFiles(dir, FileUtil.aspectjSourceFileFilter));
    }

    public List<String> getBootclasspath(AjcConfigParser parser) {
        ArrayList<String> ret = new ArrayList<String>();
        if (parser.bootclasspath == null) {
            if (LangUtil.is19VMOrGreater()) {
                this.addClasspath(LangUtil.getJrtFsFilePath(), ret);
            } else {
                this.addClasspath(System.getProperty("sun.boot.class.path", ""), ret);
            }
        } else {
            this.addClasspath(parser.bootclasspath, ret);
        }
        return ret;
    }

    public List<String> getModulepath(AjcConfigParser parser) {
        ArrayList<String> ret = new ArrayList<String>();
        this.addClasspath(parser.modulepath, ret);
        return ret;
    }

    public List<String> getModulesourcepath(AjcConfigParser parser) {
        ArrayList<String> ret = new ArrayList<String>();
        this.addClasspath(parser.modulesourcepath, ret);
        return ret;
    }

    @Override
    public ArrayList<FileSystem.Classpath> handleClasspath(ArrayList<String> classpaths, String customEncoding) {
        return super.handleClasspath(classpaths, customEncoding);
    }

    public List getClasspath(AjcConfigParser parser) {
        ArrayList<String> ret = new ArrayList<String>();
        String extdirs = parser.extdirs;
        if (extdirs == null) {
            extdirs = System.getProperty("java.ext.dirs", "");
        }
        this.addExtDirs(extdirs, ret);
        if (parser.classpath == null) {
            this.addClasspath(System.getProperty("java.class.path", ""), ret);
            ArrayList<String> fixedList = new ArrayList<String>();
            for (String entry : ret) {
                if (entry.endsWith("aspectjtools.jar")) continue;
                fixedList.add(entry);
            }
            ret = fixedList;
        } else {
            this.addClasspath(parser.classpath, ret);
        }
        return ret;
    }

    private void addExtDirs(String extdirs, List classpathCollector) {
        StringTokenizer tokenizer = new StringTokenizer(extdirs, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            File dirFile = new File(tokenizer.nextToken());
            if (!dirFile.canRead() || !dirFile.isDirectory()) continue;
            File[] files = dirFile.listFiles(FileUtil.ZIP_FILTER);
            for (int i = 0; i < files.length; ++i) {
                classpathCollector.add(files[i].getAbsolutePath());
            }
        }
    }

    private void addClasspath(String classpath, List<String> classpathCollector) {
        if (classpath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            classpathCollector.add(tokenizer.nextToken());
        }
    }

    @Override
    public boolean checkVMVersion(long minimalSupportedVersion) {
        return super.checkVMVersion(minimalSupportedVersion);
    }

    @Override
    public void initRootModules(LookupEnvironment environment, FileSystem fileSystem) {
        super.initRootModules(environment, fileSystem);
    }

    static {
        Main.bundleName = BUNDLE_NAME;
        Main.ResourceBundleFactory.getBundle(Locale.getDefault());
        if (!LOADED_BUNDLE) {
            LOADED_BUNDLE = true;
        }
    }

    private class AjcConfigParser
    extends ConfigParser {
        private String bootclasspath = null;
        private String classpath = null;
        private String modulepath = null;
        private String modulesourcepath = null;
        private String extdirs = null;
        private List unparsedArgs = new ArrayList();
        private AjBuildConfig buildConfig;
        private IMessageHandler handler;
        private String moduleInfoArgument;

        public AjcConfigParser(AjBuildConfig buildConfig, IMessageHandler handler) {
            this.buildConfig = buildConfig;
            this.handler = handler;
        }

        public List getUnparsedArgs() {
            return this.unparsedArgs;
        }

        public String getModuleInfoArgument() {
            return this.moduleInfoArgument;
        }

        @Override
        public void parseOption(String arg, LinkedList<ConfigParser.Arg> args) {
            int nextArgIndex = args.indexOf(arg) + 1;
            this.buildConfig.setXlazyTjp(true);
            if (LangUtil.isEmpty(arg)) {
                this.showWarning("empty arg found");
            } else if (arg.endsWith("module-info.java")) {
                this.moduleInfoArgument = arg;
            } else if (arg.equals("-inpath")) {
                if (args.size() > nextArgIndex) {
                    StringTokenizer st = new StringTokenizer(args.get(nextArgIndex).getValue(), File.pathSeparator);
                    boolean inpathChange = false;
                    while (st.hasMoreTokens()) {
                        String filename = st.nextToken();
                        File file = this.makeFile(filename);
                        if (FileUtil.isZipFile(file)) {
                            this.buildConfig.addToInpath(file);
                            inpathChange = true;
                            continue;
                        }
                        if (file.isDirectory()) {
                            this.buildConfig.addToInpath(file);
                            inpathChange = true;
                            continue;
                        }
                        this.showWarning("skipping missing, empty or corrupt inpath entry: " + filename);
                    }
                    if (inpathChange) {
                        this.buildConfig.processInPath();
                    }
                    args.remove(args.get(nextArgIndex));
                }
            } else if (arg.equals("-injars")) {
                if (args.size() > nextArgIndex) {
                    StringTokenizer st = new StringTokenizer(args.get(nextArgIndex).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        String filename = st.nextToken();
                        File jarFile = this.makeFile(filename);
                        if (FileUtil.isZipFile(jarFile)) {
                            this.buildConfig.getInJars().add(jarFile);
                            continue;
                        }
                        File dirFile = this.makeFile(filename);
                        if (dirFile.isDirectory()) {
                            this.buildConfig.getInJars().add(dirFile);
                            continue;
                        }
                        this.showWarning("skipping missing, empty or corrupt injar: " + filename);
                    }
                    args.remove(args.get(nextArgIndex));
                }
            } else if (arg.equals("-aspectpath")) {
                if (args.size() > nextArgIndex) {
                    StringTokenizer st = new StringTokenizer(args.get(nextArgIndex).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        String filename = st.nextToken();
                        File jarFile = this.makeFile(filename);
                        if (FileUtil.isZipFile(jarFile) || jarFile.isDirectory()) {
                            this.buildConfig.addToAspectpath(jarFile);
                            continue;
                        }
                        this.showWarning("skipping missing, empty or corrupt aspectpath entry: " + filename);
                    }
                    args.remove(args.get(nextArgIndex));
                }
            } else if (arg.equals("-makeAjReflectable")) {
                this.buildConfig.setMakeReflectable(true);
            } else if (arg.equals("-sourceroots")) {
                if (args.size() > nextArgIndex) {
                    ArrayList<File> sourceRoots = new ArrayList<File>();
                    StringTokenizer st = new StringTokenizer(args.get(nextArgIndex).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        File f = this.makeFile(st.nextToken());
                        if (f.isDirectory() && f.canRead()) {
                            sourceRoots.add(f);
                            continue;
                        }
                        this.showError("bad sourceroot: " + f);
                    }
                    if (0 < sourceRoots.size()) {
                        this.buildConfig.setSourceRoots(sourceRoots);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-sourceroots requires list of directories");
                }
            } else if (arg.equals("-outjar")) {
                if (args.size() > nextArgIndex) {
                    File jarFile = this.makeFile(args.get(nextArgIndex).getValue());
                    if (!jarFile.isDirectory()) {
                        try {
                            if (!jarFile.exists()) {
                                jarFile.createNewFile();
                            }
                            this.buildConfig.setOutputJar(jarFile);
                        }
                        catch (IOException ioe) {
                            this.showError("unable to create outjar file: " + jarFile);
                        }
                    } else {
                        this.showError("invalid -outjar file: " + jarFile);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-outjar requires jar path argument");
                }
            } else if (arg.equals("-outxml")) {
                this.buildConfig.setOutxmlName("META-INF/aop-ajc.xml");
            } else if (arg.equals("-outxmlfile")) {
                if (args.size() > nextArgIndex) {
                    String name = args.get(nextArgIndex).getValue();
                    this.buildConfig.setOutxmlName(name);
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-outxmlfile requires file name argument");
                }
            } else if (arg.equals("-log")) {
                args.remove(args.get(nextArgIndex));
            } else if (arg.equals("-messageHolder")) {
                args.remove(args.get(nextArgIndex));
            } else if (arg.equals("-incremental")) {
                this.buildConfig.setIncrementalMode(true);
            } else if (arg.equals("-XincrementalFile")) {
                if (args.size() > nextArgIndex) {
                    File file = this.makeFile(args.get(nextArgIndex).getValue());
                    this.buildConfig.setIncrementalFile(file);
                    if (!file.canRead()) {
                        this.showError("bad -XincrementalFile : " + file);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-XincrementalFile requires file argument");
                }
            } else if (arg.equals("-crossrefs")) {
                this.buildConfig.setGenerateCrossRefsMode(true);
                this.buildConfig.setGenerateModelMode(true);
            } else if (arg.startsWith("-checkRuntimeVersion:")) {
                String lcArg = arg.toLowerCase();
                if (lcArg.endsWith(":false")) {
                    this.buildConfig.setCheckRuntimeVersion(false);
                } else if (lcArg.endsWith(":true")) {
                    this.buildConfig.setCheckRuntimeVersion(true);
                } else {
                    this.showError("bad value for -checkRuntimeVersion option, must be true or false");
                }
            } else if (arg.equals("-emacssym")) {
                this.buildConfig.setEmacsSymMode(true);
                this.buildConfig.setGenerateModelMode(true);
            } else if (arg.equals("-XjavadocsInModel")) {
                this.buildConfig.setGenerateModelMode(true);
                this.buildConfig.setGenerateJavadocsInModelMode(true);
            } else if (arg.equals("-Xdev:NoAtAspectJProcessing")) {
                this.buildConfig.setNoAtAspectJAnnotationProcessing(true);
            } else if (arg.equals("-XaddSerialVersionUID")) {
                this.buildConfig.setAddSerialVerUID(true);
            } else if (arg.equals("-xmlConfigured")) {
                this.buildConfig.setXmlConfigured(true);
            } else if (arg.equals("-Xdev:Pinpoint")) {
                this.buildConfig.setXdevPinpointMode(true);
            } else if (arg.startsWith("-Xjoinpoints:")) {
                this.buildConfig.setXJoinpoints(arg.substring(13));
            } else if (arg.equals("-noWeave") || arg.equals("-XnoWeave")) {
                this.showWarning("the noweave option is no longer required and is being ignored");
            } else if (arg.equals("-XterminateAfterCompilation")) {
                this.buildConfig.setTerminateAfterCompilation(true);
            } else if (arg.equals("-XserializableAspects")) {
                this.buildConfig.setXserializableAspects(true);
            } else if (arg.equals("-XlazyTjp")) {
                this.showWarning("-XlazyTjp should no longer be used, build tjps lazily is now the default");
            } else if (arg.startsWith("-Xreweavable")) {
                this.showWarning("-Xreweavable is on by default");
                if (arg.endsWith(":compress")) {
                    this.showWarning("-Xreweavable:compress is no longer available - reweavable is now default");
                }
            } else if (arg.startsWith("-Xset:")) {
                this.buildConfig.setXconfigurationInfo(arg.substring(6));
            } else if (arg.startsWith("-aspectj.pushin=")) {
                try {
                    System.setProperty("aspectj.pushin", arg.substring(16));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (arg.startsWith("-XnotReweavable")) {
                this.buildConfig.setXnotReweavable(true);
            } else if (arg.equals("-XnoInline")) {
                this.buildConfig.setXnoInline(true);
            } else if (arg.equals("-XhasMember")) {
                this.buildConfig.setXHasMemberSupport(true);
            } else if (arg.startsWith("-showWeaveInfo")) {
                this.buildConfig.setShowWeavingInformation(true);
            } else if (arg.equals("-Xlintfile")) {
                if (args.size() > nextArgIndex) {
                    File lintSpecFile = this.makeFile(args.get(nextArgIndex).getValue());
                    if (lintSpecFile.canRead() && lintSpecFile.getName().endsWith(".properties")) {
                        this.buildConfig.setLintSpecFile(lintSpecFile);
                    } else {
                        this.showError("bad -Xlintfile file: " + lintSpecFile);
                        this.buildConfig.setLintSpecFile(null);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-Xlintfile requires .properties file argument");
                }
            } else if (arg.equals("-Xlint")) {
                this.buildConfig.setLintMode("default");
            } else if (arg.startsWith("-Xlint:")) {
                if (7 < arg.length()) {
                    this.buildConfig.setLintMode(arg.substring(7));
                } else {
                    this.showError("invalid lint option " + arg);
                }
            } else if (arg.equals("-bootclasspath")) {
                if (args.size() > nextArgIndex) {
                    String bcpArg = args.get(nextArgIndex).getValue();
                    StringBuffer bcp = new StringBuffer();
                    StringTokenizer strTok = new StringTokenizer(bcpArg, File.pathSeparator);
                    while (strTok.hasMoreTokens()) {
                        bcp.append(this.makeFile(strTok.nextToken()));
                        if (!strTok.hasMoreTokens()) continue;
                        bcp.append(File.pathSeparator);
                    }
                    this.bootclasspath = bcp.toString();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-bootclasspath requires classpath entries");
                }
            } else if (arg.equals("-classpath") || arg.equals("-cp")) {
                if (args.size() > nextArgIndex) {
                    String cpArg = args.get(nextArgIndex).getValue();
                    StringBuffer cp = new StringBuffer();
                    StringTokenizer strTok = new StringTokenizer(cpArg, File.pathSeparator);
                    while (strTok.hasMoreTokens()) {
                        cp.append(this.makeFile(strTok.nextToken()));
                        if (!strTok.hasMoreTokens()) continue;
                        cp.append(File.pathSeparator);
                    }
                    this.classpath = cp.toString();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-classpath requires classpath entries");
                }
            } else if (arg.equals("--module-path") || arg.equals("-p")) {
                if (args.size() > nextArgIndex) {
                    String mpArg;
                    this.modulepath = mpArg = args.get(nextArgIndex).getValue();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("--module-path requires modulepath entries");
                }
            } else if (arg.equals("--module-source-path") || arg.equals("-p")) {
                if (args.size() > nextArgIndex) {
                    String mspArg;
                    this.modulesourcepath = mspArg = args.get(nextArgIndex).getValue();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("--module-source-path requires modulepath entries");
                }
            } else if (arg.equals("-extdirs")) {
                if (args.size() > nextArgIndex) {
                    String extdirsArg = args.get(nextArgIndex).getValue();
                    StringBuffer ed = new StringBuffer();
                    StringTokenizer strTok = new StringTokenizer(extdirsArg, File.pathSeparator);
                    while (strTok.hasMoreTokens()) {
                        ed.append(this.makeFile(strTok.nextToken()));
                        if (!strTok.hasMoreTokens()) continue;
                        ed.append(File.pathSeparator);
                    }
                    this.extdirs = ed.toString();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-extdirs requires list of external directories");
                }
            } else if (arg.equals("-d")) {
                this.dirLookahead(arg, args, nextArgIndex);
            } else if (arg.equals("-proceedOnError")) {
                this.buildConfig.setProceedOnError(true);
            } else if (arg.equals("-processorpath")) {
                this.addPairToUnparsed(args, arg, nextArgIndex, "-processorpath requires list of external directories or zip archives");
            } else if (arg.equals("-processor")) {
                this.addPairToUnparsed(args, arg, nextArgIndex, "-processor requires list of processors' classes");
            } else if (arg.equals("-s")) {
                this.addPairToUnparsed(args, arg, nextArgIndex, "-s requires directory");
            } else if (arg.equals("-classNames")) {
                this.addPairToUnparsed(args, arg, nextArgIndex, "-classNames requires list of classes");
            } else if (new File(arg).isDirectory()) {
                this.showError("dir arg not permitted: " + arg);
            } else if (arg.startsWith("-Xajruntimetarget")) {
                if (arg.endsWith(":1.2")) {
                    this.buildConfig.setTargetAspectjRuntimeLevel("1.2");
                } else if (arg.endsWith(":1.5")) {
                    this.buildConfig.setTargetAspectjRuntimeLevel("1.5");
                } else if (arg.endsWith(":1.9")) {
                    this.buildConfig.setTargetAspectjRuntimeLevel("1.9");
                } else {
                    this.showError("-Xajruntimetarget:<level> supports a target level of 1.2, 1.5, 1.9");
                }
            } else if (arg.equals("-timers")) {
                this.buildConfig.setTiming(true);
            } else if (arg.equals("-1.5")) {
                this.buildConfig.setBehaveInJava5Way(true);
                this.unparsedArgs.add("-1.5");
            } else if (arg.equals("-1.6")) {
                this.buildConfig.setBehaveInJava5Way(true);
                this.unparsedArgs.add("-1.6");
            } else if (arg.equals("-1.7")) {
                this.buildConfig.setBehaveInJava5Way(true);
                this.unparsedArgs.add("-1.7");
            } else if (arg.equals("-1.8")) {
                this.buildConfig.setBehaveInJava5Way(true);
                this.unparsedArgs.add("-1.8");
            } else if (arg.equals("-1.9")) {
                this.buildConfig.setBehaveInJava5Way(true);
                this.unparsedArgs.add("-1.9");
            } else if (arg.equals("-10")) {
                this.buildConfig.setBehaveInJava5Way(true);
                this.unparsedArgs.add("-10");
            } else if (arg.equals("-source")) {
                if (args.size() > nextArgIndex) {
                    String level = args.get(nextArgIndex).getValue();
                    if (level.equals("1.5") || level.equals("5") || level.equals("1.6") || level.equals("6") || level.equals("1.7") || level.equals("7") || level.equals("8") || level.equals("1.8") || level.equals("9") || level.equals("1.9") || level.equals("10")) {
                        this.buildConfig.setBehaveInJava5Way(true);
                    }
                    this.unparsedArgs.add("-source");
                    this.unparsedArgs.add(level);
                    args.remove(args.get(nextArgIndex));
                }
            } else {
                this.unparsedArgs.add(arg);
            }
        }

        protected void dirLookahead(String arg, LinkedList argList, int nextArgIndex) {
            this.unparsedArgs.add(arg);
            ConfigParser.Arg next = (ConfigParser.Arg)argList.get(nextArgIndex);
            String value = next.getValue();
            if (!LangUtil.isEmpty(value) && new File(value).isDirectory()) {
                this.unparsedArgs.add(value);
                argList.remove(next);
                return;
            }
        }

        @Override
        public void showError(String message) {
            SourceLocation location = null;
            if (this.buildConfig.getConfigFile() != null) {
                location = new SourceLocation(this.buildConfig.getConfigFile(), 0);
            }
            Message errorMessage = new Message(CONFIG_MSG + message, IMessage.ERROR, null, location);
            this.handler.handleMessage(errorMessage);
        }

        @Override
        protected void showWarning(String message) {
            SourceLocation location = null;
            if (this.buildConfig.getConfigFile() != null) {
                location = new SourceLocation(this.buildConfig.getConfigFile(), 0);
            }
            Message errorMessage = new Message(CONFIG_MSG + message, IMessage.WARNING, null, location);
            this.handler.handleMessage(errorMessage);
        }

        protected File makeFile(File dir, String name) {
            name = name.replace('/', File.separatorChar);
            File ret = new File(name);
            if (dir == null || ret.isAbsolute()) {
                return ret;
            }
            try {
                dir = dir.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new File(dir, name);
        }

        private void addPairToUnparsed(LinkedList<ConfigParser.Arg> args, String arg, int nextArgIndex, String errorMessage) {
            if (args.size() <= nextArgIndex) {
                this.showError(errorMessage);
                return;
            }
            ConfigParser.Arg nextArg = args.get(nextArgIndex);
            args.remove(nextArg);
            this.unparsedArgs.add(arg);
            this.unparsedArgs.add(nextArg.getValue());
        }

        private int indexOf(LinkedList<ConfigParser.Arg> args, String arg) {
            int index = 0;
            for (ConfigParser.Arg argument : args) {
                if (arg.equals(argument.getValue())) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
    }

    private static class StringPrintWriter
    extends PrintWriter {
        public final StringWriter stringWriter;

        StringPrintWriter(StringWriter sw) {
            super(sw);
            this.stringWriter = sw;
        }
    }
}

