/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.aspectj.ajdt.ajc.BuildArgParser;
import org.aspectj.ajdt.internal.compiler.CompilationResultDestinationManager;
import org.aspectj.ajdt.internal.core.builder.AjCompilerOptions;
import org.aspectj.ajdt.internal.core.builder.CompilerConfigurationChangeFlags;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.ClasspathJep247;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IModule;
import org.aspectj.util.FileUtil;

public class AjBuildConfig
implements CompilerConfigurationChangeFlags {
    public static final FileSystem.Classpath[] NO_CHECKED_CLASSPATHS = new FileSystem.Classpath[0];
    private boolean shouldProceed = true;
    public static final String AJLINT_IGNORE = "ignore";
    public static final String AJLINT_WARN = "warn";
    public static final String AJLINT_ERROR = "error";
    public static final String AJLINT_DEFAULT = "default";
    private File outputDir;
    private File outputJar;
    private String outxmlName;
    private CompilationResultDestinationManager compilationResultDestinationManager = null;
    private List<File> sourceRoots = new ArrayList<File>();
    private List<File> changedFiles;
    private List<File> files = new ArrayList<File>();
    private List<File> xmlfiles = new ArrayList<File>();
    private String processor;
    private String processorPath;
    private List<BinarySourceFile> binaryFiles = new ArrayList<BinarySourceFile>();
    private List<File> inJars = new ArrayList<File>();
    private List<File> inPath = new ArrayList<File>();
    private Map<String, File> sourcePathResources = new HashMap<String, File>();
    private List<File> aspectpath = new ArrayList<File>();
    private List<String> classpath = new ArrayList<String>();
    private List<String> modulepath = new ArrayList<String>();
    private Collection<FileSystem.Classpath> modulepathClasspathEntries = null;
    private List<String> modulesourcepath = new ArrayList<String>();
    private Collection<FileSystem.Classpath> modulesourcepathClasspathEntries = null;
    private FileSystem.Classpath[] checkedClasspaths = null;
    private List<String> bootclasspath = new ArrayList<String>();
    private List<String> cpElementsWithModifiedContents = new ArrayList<String>();
    private IModule moduleDesc;
    private File configFile;
    private String lintMode = "default";
    private Map<String, String> lintOptionsMap = null;
    private File lintSpecFile = null;
    private int changes = 65535;
    private final AjCompilerOptions options;
    private final BuildArgParser buildArgParser;
    private boolean incrementalMode;
    private File incrementalFile;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("BuildConfig[" + (this.configFile == null ? "null" : this.configFile.getAbsoluteFile().toString()) + "] #Files=" + this.files.size() + " AopXmls=#" + this.xmlfiles.size());
        return sb.toString();
    }

    public AjBuildConfig(BuildArgParser buildArgParser) {
        this.buildArgParser = buildArgParser;
        this.options = new AjCompilerOptions();
    }

    public BuildArgParser getBuildArgParser() {
        return this.buildArgParser;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public List<File> getXmlFiles() {
        return this.xmlfiles;
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public String getProcessor() {
        return this.processor;
    }

    public void setProcessorPath(String processorPath) {
        this.processorPath = processorPath;
    }

    public String getProcessorPath() {
        return this.processorPath;
    }

    public List<BinarySourceFile> getBinaryFiles() {
        return this.binaryFiles;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public CompilationResultDestinationManager getCompilationResultDestinationManager() {
        return this.compilationResultDestinationManager;
    }

    public void setCompilationResultDestinationManager(CompilationResultDestinationManager mgr) {
        this.compilationResultDestinationManager = mgr;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void setXmlFiles(List<File> xmlfiles) {
        this.xmlfiles = xmlfiles;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public AjCompilerOptions getOptions() {
        return this.options;
    }

    public List<String> getClasspath() {
        return this.classpath;
    }

    public void setClasspath(List<String> classpath) {
        this.classpath = classpath;
        this.checkedClasspaths = null;
    }

    public List<String> getModulepath() {
        return this.modulepath;
    }

    public List<String> getModulesourcepath() {
        return this.modulesourcepath;
    }

    public void setModulepath(List<String> modulepath) {
        this.modulepath = modulepath;
        this.checkedClasspaths = null;
    }

    public void setModulesourcepath(List<String> modulesourcepath) {
        this.modulesourcepath = modulesourcepath;
        this.checkedClasspaths = null;
    }

    public void setCheckedClasspaths(FileSystem.Classpath[] checkedClasspaths) {
        this.checkedClasspaths = checkedClasspaths;
        checkedClasspaths = null;
    }

    private List<FileSystem.Classpath> processFilePath(List<File> path, String encoding) {
        ArrayList<FileSystem.Classpath> entries = new ArrayList<FileSystem.Classpath>();
        for (File file : path) {
            entries.add(FileSystem.getClasspath(file.getAbsolutePath(), encoding, null, 2, null));
        }
        return entries;
    }

    private List<FileSystem.Classpath> processStringPath(List<String> path, String encoding) {
        ArrayList<FileSystem.Classpath> entries = new ArrayList<FileSystem.Classpath>();
        for (String file : path) {
            entries.add(FileSystem.getClasspath(file, encoding, null, 2, null));
        }
        return entries;
    }

    public FileSystem.Classpath[] getCheckedClasspaths() {
        if (this.checkedClasspaths == null) {
            this.computeCheckedClasspath();
        }
        return this.checkedClasspaths;
    }

    public List<String> getBootclasspath() {
        return this.bootclasspath;
    }

    public void setBootclasspath(List<String> bootclasspath) {
        this.bootclasspath = bootclasspath;
    }

    public File getOutputJar() {
        return this.outputJar;
    }

    public String getOutxmlName() {
        return this.outxmlName;
    }

    public List<File> getInpath() {
        return Collections.unmodifiableList(this.inPath);
    }

    public List<File> getInJars() {
        return this.inJars;
    }

    public Map<String, File> getSourcePathResources() {
        return this.sourcePathResources;
    }

    public void setOutputJar(File outputJar) {
        this.outputJar = outputJar;
    }

    public void setOutxmlName(String name) {
        this.outxmlName = name;
    }

    public void setInJars(List<File> sourceJars) {
        this.inJars = sourceJars;
        this.checkedClasspaths = null;
    }

    public void processInPath() {
        this.binaryFiles = new ArrayList<BinarySourceFile>();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getPath().endsWith(".class");
            }
        };
        for (File inpathElement : this.inPath) {
            File[] files;
            if (!inpathElement.isDirectory()) continue;
            for (File file : files = FileUtil.listFiles(inpathElement, filter)) {
                this.binaryFiles.add(new BinarySourceFile(inpathElement, file));
            }
        }
    }

    public void setInPath(List<File> dirsOrJars) {
        this.inPath = dirsOrJars;
        this.checkedClasspaths = null;
        this.processInPath();
    }

    public List<File> getSourceRoots() {
        return this.sourceRoots;
    }

    public void setSourceRoots(List<File> sourceRootDir) {
        this.sourceRoots = sourceRootDir;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public void setIncrementalMode(boolean incrementalMode) {
        this.incrementalMode = incrementalMode;
    }

    public boolean isIncrementalMode() {
        return this.incrementalMode;
    }

    public void setIncrementalFile(File incrementalFile) {
        this.incrementalFile = incrementalFile;
    }

    public boolean isIncrementalFileMode() {
        return null != this.incrementalFile;
    }

    public List<String> getFullClasspath() {
        ArrayList<String> full = new ArrayList<String>(this.getBootclasspath());
        for (File file : this.inJars) {
            full.add(file.getAbsolutePath());
        }
        for (File file : this.inPath) {
            full.add(file.getAbsolutePath());
        }
        for (File file : this.aspectpath) {
            full.add(file.getAbsolutePath());
        }
        full.addAll(this.getClasspath());
        return full;
    }

    public File getLintSpecFile() {
        return this.lintSpecFile;
    }

    public void setLintSpecFile(File lintSpecFile) {
        this.lintSpecFile = lintSpecFile;
    }

    public List<File> getAspectpath() {
        return Collections.unmodifiableList(this.aspectpath);
    }

    public void setAspectpath(List<File> aspectpath) {
        this.aspectpath = aspectpath;
        this.checkedClasspaths = null;
    }

    public void addToAspectpath(File file) {
        this.aspectpath.add(file);
        this.checkedClasspaths = null;
    }

    public void addToInjars(File file) {
        this.inJars.add(file);
        this.checkedClasspaths = null;
    }

    public boolean hasSources() {
        return null != this.configFile || 0 < this.sourceRoots.size() || 0 < this.files.size() || 0 < this.inJars.size() || 0 < this.inPath.size();
    }

    public void installGlobals(AjBuildConfig global) {
        this.options.defaultEncoding = global.options.defaultEncoding;
        this.join(this.aspectpath, global.aspectpath);
        this.join(this.classpath, global.classpath);
        if (null == this.configFile) {
            this.configFile = global.configFile;
        }
        if (!this.isEmacsSymMode() && global.isEmacsSymMode()) {
            this.setEmacsSymMode(true);
        }
        this.join(this.files, global.files);
        this.join(this.xmlfiles, global.xmlfiles);
        if (!this.isGenerateModelMode() && global.isGenerateModelMode()) {
            this.setGenerateModelMode(true);
        }
        if (null == this.incrementalFile) {
            this.incrementalFile = global.incrementalFile;
        }
        if (!this.incrementalMode && global.incrementalMode) {
            this.incrementalMode = true;
        }
        if (this.isCheckRuntimeVersion() && !global.isCheckRuntimeVersion()) {
            this.setCheckRuntimeVersion(false);
        }
        this.join(this.inJars, global.inJars);
        this.join(this.inPath, global.inPath);
        if (null == this.lintMode || AJLINT_DEFAULT.equals(this.lintMode)) {
            this.setLintMode(global.lintMode);
        }
        if (null == this.lintSpecFile) {
            this.lintSpecFile = global.lintSpecFile;
        }
        if (!this.isTerminateAfterCompilation() && global.isTerminateAfterCompilation()) {
            this.setTerminateAfterCompilation(true);
        }
        if (null == this.outputDir && null == this.outputJar) {
            if (null != global.outputDir) {
                this.outputDir = global.outputDir;
            }
            if (null != global.outputJar) {
                this.outputJar = global.outputJar;
            }
        }
        this.join(this.sourceRoots, global.sourceRoots);
        if (!this.isXnoInline() && global.isXnoInline()) {
            this.setXnoInline(true);
        }
        if (!this.isXserializableAspects() && global.isXserializableAspects()) {
            this.setXserializableAspects(true);
        }
        if (!this.isXlazyTjp() && global.isXlazyTjp()) {
            this.setXlazyTjp(true);
        }
        if (!this.getProceedOnError() && global.getProceedOnError()) {
            this.setProceedOnError(true);
        }
        this.setTargetAspectjRuntimeLevel(global.getTargetAspectjRuntimeLevel());
        this.setXJoinpoints(global.getXJoinpoints());
        if (!this.isXHasMemberEnabled() && global.isXHasMemberEnabled()) {
            this.setXHasMemberSupport(true);
        }
        if (!this.isXNotReweavable() && global.isXNotReweavable()) {
            this.setXnotReweavable(true);
        }
        this.setOutxmlName(global.getOutxmlName());
        this.setXconfigurationInfo(global.getXconfigurationInfo());
        this.setAddSerialVerUID(global.isAddSerialVerUID());
        if (!this.isXmlConfigured() && global.isXmlConfigured()) {
            this.setXmlConfigured(global.isXmlConfigured());
        }
        this.setTiming(global.isTiming());
        this.setMakeReflectable(global.isMakeReflectable());
    }

    void join(Collection local, Collection global) {
        for (Object next : global) {
            if (local.contains(next)) continue;
            local.add(next);
        }
    }

    public void setSourcePathResources(Map<String, File> map) {
        this.sourcePathResources = map;
    }

    public boolean shouldProceed() {
        return this.shouldProceed;
    }

    public void doNotProceed() {
        this.shouldProceed = false;
    }

    public String getLintMode() {
        return this.lintMode;
    }

    public Map<String, String> getLintOptionsMap() {
        return this.lintOptionsMap;
    }

    public void setLintMode(String lintMode) {
        String lintValue = null;
        this.lintMode = lintMode;
        if (AJLINT_IGNORE.equals(lintMode)) {
            lintValue = AJLINT_IGNORE;
        } else if (AJLINT_WARN.equals(lintMode)) {
            lintValue = "warning";
        } else if (AJLINT_ERROR.equals(lintMode)) {
            lintValue = AJLINT_ERROR;
        } else if (lintMode.contains("=")) {
            this.lintMode = AJLINT_DEFAULT;
            this.lintOptionsMap = new HashMap<String, String>();
            StringTokenizer tokenizer = new StringTokenizer(lintMode, ",");
            while (tokenizer.hasMoreElements()) {
                String option = tokenizer.nextToken();
                int equals = option.indexOf("=");
                if (equals == -1) continue;
                String key = option.substring(0, equals);
                String value = option.substring(equals + 1);
                this.lintOptionsMap.put(key, value);
            }
        }
        if (lintValue != null || this.lintOptionsMap != null) {
            HashMap<String, String> lintOptions = new HashMap<String, String>();
            this.setOption("org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.WildcardTypeName", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.UnresolvableMember", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField", lintValue, lintOptions);
            this.setOption("org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility", lintValue, lintOptions);
            this.options.set(lintOptions);
        }
    }

    private void setOption(String optionKey, String lintValue, Map<String, String> lintOptionsAccumulator) {
        if (this.lintOptionsMap != null && this.lintOptionsMap.containsKey(optionKey)) {
            String v = this.lintOptionsMap.get(this.lintOptionsMap);
            if (AJLINT_IGNORE.equals(v)) {
                lintValue = AJLINT_IGNORE;
            } else if (AJLINT_WARN.equals(v)) {
                lintValue = "warning";
            } else if (AJLINT_ERROR.equals(v)) {
                lintValue = AJLINT_ERROR;
            }
        }
        if (lintValue != null) {
            lintOptionsAccumulator.put(optionKey, lintValue);
        }
    }

    public boolean isTerminateAfterCompilation() {
        return this.options.terminateAfterCompilation;
    }

    public void setTerminateAfterCompilation(boolean b) {
        this.options.terminateAfterCompilation = b;
    }

    public boolean isXserializableAspects() {
        return this.options.xSerializableAspects;
    }

    public void setXserializableAspects(boolean xserializableAspects) {
        this.options.xSerializableAspects = xserializableAspects;
    }

    public void setXJoinpoints(String jps) {
        this.options.xOptionalJoinpoints = jps;
    }

    public String getXJoinpoints() {
        return this.options.xOptionalJoinpoints;
    }

    public boolean isXnoInline() {
        return this.options.xNoInline;
    }

    public void setXnoInline(boolean xnoInline) {
        this.options.xNoInline = xnoInline;
    }

    public boolean isXlazyTjp() {
        return this.options.xLazyThisJoinPoint;
    }

    public void setXlazyTjp(boolean b) {
        this.options.xLazyThisJoinPoint = b;
    }

    public void setXnotReweavable(boolean b) {
        this.options.xNotReweavable = b;
    }

    public void setXconfigurationInfo(String info) {
        this.options.xConfigurationInfo = info;
    }

    public String getXconfigurationInfo() {
        return this.options.xConfigurationInfo;
    }

    public void setXHasMemberSupport(boolean enabled) {
        this.options.xHasMember = enabled;
    }

    public boolean isXHasMemberEnabled() {
        return this.options.xHasMember;
    }

    public void setXdevPinpointMode(boolean enabled) {
        this.options.xdevPinpoint = enabled;
    }

    public boolean isXdevPinpoint() {
        return this.options.xdevPinpoint;
    }

    public void setAddSerialVerUID(boolean b) {
        this.options.addSerialVerUID = b;
    }

    public boolean isAddSerialVerUID() {
        return this.options.addSerialVerUID;
    }

    public void setXmlConfigured(boolean b) {
        this.options.xmlConfigured = b;
    }

    public void setMakeReflectable(boolean b) {
        this.options.makeReflectable = b;
    }

    public boolean isXmlConfigured() {
        return this.options.xmlConfigured;
    }

    public boolean isMakeReflectable() {
        return this.options.makeReflectable;
    }

    public boolean isXNotReweavable() {
        return this.options.xNotReweavable;
    }

    public boolean isGenerateJavadocsInModelMode() {
        return this.options.generateJavaDocsInModel;
    }

    public void setGenerateJavadocsInModelMode(boolean generateJavadocsInModelMode) {
        this.options.generateJavaDocsInModel = generateJavadocsInModelMode;
    }

    public boolean isGenerateCrossRefsMode() {
        return this.options.generateCrossRefs;
    }

    public void setGenerateCrossRefsMode(boolean on) {
        this.options.generateCrossRefs = on;
    }

    public boolean isCheckRuntimeVersion() {
        return this.options.checkRuntimeVersion;
    }

    public void setCheckRuntimeVersion(boolean on) {
        this.options.checkRuntimeVersion = on;
    }

    public boolean isEmacsSymMode() {
        return this.options.generateEmacsSymFiles;
    }

    public void setEmacsSymMode(boolean emacsSymMode) {
        this.options.generateEmacsSymFiles = emacsSymMode;
    }

    public boolean isGenerateModelMode() {
        return this.options.generateModel;
    }

    public void setGenerateModelMode(boolean structureModelMode) {
        this.options.generateModel = structureModelMode;
    }

    public boolean isNoAtAspectJAnnotationProcessing() {
        return this.options.noAtAspectJProcessing;
    }

    public void setNoAtAspectJAnnotationProcessing(boolean noProcess) {
        this.options.noAtAspectJProcessing = noProcess;
    }

    public void setShowWeavingInformation(boolean b) {
        this.options.showWeavingInformation = true;
    }

    public boolean getShowWeavingInformation() {
        return this.options.showWeavingInformation;
    }

    public void setProceedOnError(boolean b) {
        this.options.proceedOnError = b;
    }

    public boolean getProceedOnError() {
        return this.options.proceedOnError;
    }

    public void setBehaveInJava5Way(boolean b) {
        this.options.behaveInJava5Way = b;
    }

    public boolean getBehaveInJava5Way() {
        return this.options.behaveInJava5Way;
    }

    public void setTiming(boolean b) {
        this.options.timing = b;
    }

    public boolean isTiming() {
        return this.options.timing;
    }

    public void setTargetAspectjRuntimeLevel(String level) {
        this.options.targetAspectjRuntimeLevel = level;
    }

    public String getTargetAspectjRuntimeLevel() {
        return this.options.targetAspectjRuntimeLevel;
    }

    public void setChanged(int changes) {
        this.changes = changes;
    }

    public int getChanged() {
        return this.changes;
    }

    public void setModifiedFiles(List<File> projectSourceFilesChanged) {
        this.changedFiles = projectSourceFilesChanged;
    }

    public List<File> getModifiedFiles() {
        return this.changedFiles;
    }

    public void setClasspathElementsWithModifiedContents(List<String> cpElementsWithModifiedContents) {
        this.cpElementsWithModifiedContents = cpElementsWithModifiedContents;
    }

    public List<String> getClasspathElementsWithModifiedContents() {
        return this.cpElementsWithModifiedContents;
    }

    public void setProjectEncoding(String projectEncoding) {
        this.options.defaultEncoding = projectEncoding;
    }

    public String getProjectEncoding() {
        return this.options.defaultEncoding;
    }

    public void setModuleDesc(IModule moduleDesc) {
        this.moduleDesc = moduleDesc;
    }

    public IModule getModuleDesc() {
        return this.moduleDesc;
    }

    public void addToInpath(Set<File> newInpathEntries) {
        if (newInpathEntries != null && newInpathEntries.size() != 0) {
            for (File newInpathEntry : newInpathEntries) {
                if (this.inPath.contains(newInpathEntry)) continue;
                this.inPath.add(newInpathEntry);
            }
            this.checkedClasspaths = null;
        }
    }

    public void addToInpath(File newInpathEntry) {
        this.inPath.add(newInpathEntry);
        this.checkedClasspaths = null;
    }

    public void addToAspectpath(Set<File> newAspectpathEntries) {
        if (newAspectpathEntries != null && newAspectpathEntries.size() != 0) {
            for (File newAspectpathEntry : newAspectpathEntries) {
                if (this.aspectpath.contains(newAspectpathEntry)) continue;
                this.aspectpath.add(newAspectpathEntry);
            }
            this.checkedClasspaths = null;
        }
    }

    public void setModulepathClasspathEntries(ArrayList<FileSystem.Classpath> modulepathClasspathEntries) {
        this.modulepathClasspathEntries = modulepathClasspathEntries;
    }

    public void setModulesourcepathClasspathEntries(ArrayList<FileSystem.Classpath> modulesourcepathClasspathEntries) {
        this.modulesourcepathClasspathEntries = modulesourcepathClasspathEntries;
    }

    public File removeAspectPathEntry(int i) {
        this.checkedClasspaths = null;
        return this.aspectpath.remove(i);
    }

    public String removeClasspathEntry(int i) {
        this.checkedClasspaths = null;
        return this.classpath.remove(i);
    }

    public File removeInpathEntry(int i) {
        this.checkedClasspaths = null;
        return this.inPath.remove(i);
    }

    public File removeInjarsEntry(int i) {
        this.checkedClasspaths = null;
        return this.inJars.remove(0);
    }

    private void computeCheckedClasspath() {
        String encoding = this.getProjectEncoding();
        ArrayList<FileSystem.Classpath> allPaths = new ArrayList<FileSystem.Classpath>();
        if (Arrays.stream(this.buildArgParser.getCheckedClasspaths()).anyMatch(cp -> cp instanceof ClasspathJep247)) {
            allPaths.addAll(Arrays.stream(this.buildArgParser.getCheckedClasspaths()).filter(cp -> cp instanceof ClasspathJep247).collect(Collectors.toList()));
        } else {
            allPaths.addAll(this.processStringPath(this.bootclasspath, encoding));
        }
        allPaths.addAll(this.processFilePath(this.inJars, encoding));
        allPaths.addAll(this.processFilePath(this.inPath, encoding));
        allPaths.addAll(this.processFilePath(this.aspectpath, encoding));
        if (this.modulepathClasspathEntries != null) {
            allPaths.addAll(this.modulepathClasspathEntries);
        }
        if (this.modulesourcepathClasspathEntries != null) {
            allPaths.addAll(this.modulesourcepathClasspathEntries);
        }
        allPaths.addAll(this.processStringPath(this.classpath, encoding));
        allPaths.removeIf(Objects::isNull);
        allPaths = FileSystem.ClasspathNormalizer.normalize(allPaths);
        this.checkedClasspaths = new FileSystem.Classpath[allPaths.size()];
        allPaths.toArray(this.checkedClasspaths);
        for (FileSystem.Classpath checkedClasspath : this.checkedClasspaths) {
            if (checkedClasspath != null) continue;
            throw new IllegalStateException();
        }
    }

    public static class BinarySourceFile {
        public File fromInPathDirectory;
        public File binSrc;

        public BinarySourceFile(File dir, File src) {
            this.fromInPathDirectory = dir;
            this.binSrc = src;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof BinarySourceFile) {
                BinarySourceFile other = (BinarySourceFile)obj;
                return this.binSrc.equals(other.binSrc);
            }
            return false;
        }

        public int hashCode() {
            return this.binSrc != null ? this.binSrc.hashCode() : 0;
        }
    }
}

