/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.assertions.generator.AssertionGenerator;
import org.assertj.assertions.generator.AssertionsEntryPointGenerator;
import org.assertj.assertions.generator.AssertionsEntryPointType;
import org.assertj.assertions.generator.Template;
import org.assertj.assertions.generator.description.ClassDescription;
import org.assertj.assertions.generator.description.DataDescription;
import org.assertj.assertions.generator.description.FieldDescription;
import org.assertj.assertions.generator.description.GetterDescription;
import org.assertj.assertions.generator.description.TypeName;

public class BaseAssertionGenerator
implements AssertionGenerator,
AssertionsEntryPointGenerator {
    static final String DEFAULT_IS_ASSERTION_TEMPLATE = "is_assertion_template.txt";
    static final String DEFAULT_HAS_ELEMENTS_ASSERTION_TEMPLATE_FOR_ARRAY = "has_elements_assertion_template_for_array.txt";
    static final String DEFAULT_HAS_ELEMENTS_ASSERTION_TEMPLATE_FOR_ITERABLE = "has_elements_assertion_template_for_iterable.txt";
    static final String DEFAULT_HAS_ASSERTION_TEMPLATE = "has_assertion_template.txt";
    static final String DEFAULT_HAS_ASSERTION_TEMPLATE_FOR_PRIMITIVE = "has_assertion_template_for_primitive.txt";
    static final String DEFAULT_HAS_ASSERTION_TEMPLATE_FOR_REAL_NUMBER = "has_assertion_template_for_real_number.txt";
    static final String DEFAULT_CUSTOM_ASSERTION_CLASS_TEMPLATE = "custom_assertion_class_template.txt";
    static final String DEFAULT_CUSTOM_HIERARCHICAL_ASSERTION_CLASS_TEMPLATE = "custom_hierarchical_assertion_class_template.txt";
    static final String DEFAULT_CUSTOM_ABSTRACT_ASSERTION_CLASS_TEMPLATE = "custom_abstract_assertion_class_template.txt";
    static final String DEFAULT_ASSERTIONS_ENTRY_POINT_CLASS_TEMPLATE = "standard_assertions_entry_point_class_template.txt";
    static final String DEFAULT_ASSERTION_ENTRY_POINT_METHOD_TEMPLATE = "standard_assertion_entry_point_method_template.txt";
    static final String DEFAULT_SOFT_ENTRY_POINT_ASSERTIONS_CLASS_TEMPLATE = "soft_assertions_entry_point_class_template.txt";
    static final String DEFAULT_JUNIT_SOFT_ENTRY_POINT_ASSERTIONS_CLASS_TEMPLATE = "junit_soft_assertions_entry_point_class_template.txt";
    static final String DEFAULT_SOFT_ENTRY_POINT_ASSERTION_METHOD_TEMPLATE = "soft_assertion_entry_point_method_template.txt";
    static final String DEFAULT_BDD_ENTRY_POINT_ASSERTIONS_CLASS_TEMPLATE = "bdd_assertions_entry_point_class_template.txt";
    static final String DEFAULT_BDD_ENTRY_POINT_ASSERTION_METHOD_TEMPLATE = "bdd_assertion_entry_point_method_template.txt";
    static final String ABSTRACT_ASSERT_CLASS_PREFIX = "Abstract";
    static final String ASSERT_CLASS_SUFFIX = "Assert";
    static final String ASSERT_CLASS_FILE_SUFFIX = "Assert.java";
    static final String TEMPLATES_DIR = "templates" + File.separator;
    private static final String IMPORT_LINE = "import %s;%s";
    private static final String PROPERTY_WITH_UPPERCASE_FIRST_CHAR = "${Property}";
    private static final String PROPERTY_WITH_LOWERCASE_FIRST_CHAR = "${property}";
    private static final String PACKAGE = "${package}";
    private static final String PROPERTY_TYPE = "${propertyType}";
    private static final String CLASS_TO_ASSERT = "${class_to_assert}";
    private static final String CUSTOM_ASSERTION_CLASS = "${custom_assertion_class}";
    private static final String SUPER_ASSERTION_CLASS = "${super_assertion_class}";
    private static final String SELF_TYPE = "${self_type}";
    private static final String MYSELF = "${myself}";
    private static final String ELEMENT_TYPE = "${elementType}";
    private static final String ALL_ASSERTIONS_ENTRY_POINTS = "${all_assertions_entry_points}";
    private static final String IMPORTS = "${imports}";
    private static final String THROWS = "${throws}";
    private static final String THROWS_JAVADOC = "${throws_javadoc}";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String targetBaseDirectory = ".";
    private Template classAssertionTemplate;
    private Template hierarchicalClassAssertionTemplate;
    private Template abstractClassAssertionTemplate;
    private Template hasAssertionTemplate;
    private Template hasAssertionTemplateForPrimitive;
    private Template hasAssertionTemplateForRealNumber;
    private Template hasIterableElementsAssertionTemplate;
    private Template hasArrayElementsAssertionTemplate;
    private Template isAssertionTemplate;
    private Template standardAssertionsEntryPointClassTemplate;
    private Template standardAssertionEntryPointMethodTemplate;
    private Template softAssertionsEntryPointClassTemplate;
    private Template junitSoftAssertionsEntryPointClassTemplate;
    private Template softAssertionEntryPointMethodTemplate;
    private Template bddAssertionsEntryPointClassTemplate;
    private Template bddAssertionEntryPointMethodTemplate;

    public BaseAssertionGenerator() throws IOException {
        this(TEMPLATES_DIR);
    }

    public BaseAssertionGenerator(String templatesDirectory) throws IOException {
        this(new Template(Template.Type.ASSERT_CLASS, new File(templatesDirectory, DEFAULT_CUSTOM_ASSERTION_CLASS_TEMPLATE)), new Template(Template.Type.HIERARCHICAL_ASSERT_CLASS, new File(templatesDirectory, DEFAULT_CUSTOM_HIERARCHICAL_ASSERTION_CLASS_TEMPLATE)), new Template(Template.Type.ABSTRACT_ASSERT_CLASS, new File(templatesDirectory, DEFAULT_CUSTOM_ABSTRACT_ASSERTION_CLASS_TEMPLATE)), new Template(Template.Type.HAS, new File(templatesDirectory, DEFAULT_HAS_ASSERTION_TEMPLATE)), new Template(Template.Type.HAS_FOR_PRIMITIVE, new File(templatesDirectory, DEFAULT_HAS_ASSERTION_TEMPLATE_FOR_PRIMITIVE)), new Template(Template.Type.HAS_FOR_ITERABLE, new File(templatesDirectory, DEFAULT_HAS_ELEMENTS_ASSERTION_TEMPLATE_FOR_ITERABLE)), new Template(Template.Type.HAS_FOR_ARRAY, new File(templatesDirectory, DEFAULT_HAS_ELEMENTS_ASSERTION_TEMPLATE_FOR_ARRAY)), new Template(Template.Type.IS, new File(templatesDirectory, DEFAULT_IS_ASSERTION_TEMPLATE)), new Template(Template.Type.ASSERTIONS_ENTRY_POINT_CLASS, new File(templatesDirectory, DEFAULT_ASSERTIONS_ENTRY_POINT_CLASS_TEMPLATE)), new Template(Template.Type.ASSERTION_ENTRY_POINT, new File(templatesDirectory, DEFAULT_ASSERTION_ENTRY_POINT_METHOD_TEMPLATE)), new Template(Template.Type.SOFT_ASSERTIONS_ENTRY_POINT_CLASS, new File(templatesDirectory, DEFAULT_SOFT_ENTRY_POINT_ASSERTIONS_CLASS_TEMPLATE)), new Template(Template.Type.JUNIT_SOFT_ASSERTIONS_ENTRY_POINT_CLASS, new File(templatesDirectory, DEFAULT_JUNIT_SOFT_ENTRY_POINT_ASSERTIONS_CLASS_TEMPLATE)), new Template(Template.Type.SOFT_ENTRY_POINT_METHOD_ASSERTION, new File(templatesDirectory, DEFAULT_SOFT_ENTRY_POINT_ASSERTION_METHOD_TEMPLATE)), new Template(Template.Type.BDD_ASSERTIONS_ENTRY_POINT_CLASS, new File(templatesDirectory, DEFAULT_BDD_ENTRY_POINT_ASSERTIONS_CLASS_TEMPLATE)), new Template(Template.Type.BDD_ENTRY_POINT_METHOD_ASSERTION, new File(templatesDirectory, DEFAULT_BDD_ENTRY_POINT_ASSERTION_METHOD_TEMPLATE)), new Template(Template.Type.HAS_FOR_REAL_NUMBER, new File(templatesDirectory, DEFAULT_HAS_ASSERTION_TEMPLATE_FOR_REAL_NUMBER)));
    }

    public BaseAssertionGenerator(Template classAssertionTemplate, Template hierarchicalClassAssertionTemplate, Template abstractClassAssertionTemplate, Template hasAssertionTemplate, Template hasAssertionTemplateForPrimitive, Template hasIterableElementsAssertionTemplate, Template hasArrayElementsAssertionTemplate, Template isAssertionTemplate, Template entryPointAssertionsClassTemplate, Template entryPointAssertionTemplate, Template entryPointSoftAssertionsClassTemplate, Template entryPointJUnitSoftAssertionsClassTemplate, Template entryPointSoftAssertionTemplate, Template bddAssertionsEntryPointClassTemplate, Template bddAssertionEntryPointMethodTemplate, Template hasAssertionTemplateForRealNumber) {
        this.setAssertionClassTemplate(classAssertionTemplate);
        this.setHierarchicalAssertionClassTemplate(hierarchicalClassAssertionTemplate);
        this.setAbstractAssertionClassTemplate(abstractClassAssertionTemplate);
        this.setHasAssertionTemplate(hasAssertionTemplate);
        this.setHasAssertionTemplateForPrimitive(hasAssertionTemplateForPrimitive);
        this.setHasAssertionTemplateForRealNumber(hasAssertionTemplateForRealNumber);
        this.setHasElementsAssertionForIterableTemplate(hasIterableElementsAssertionTemplate);
        this.setHasElementsAssertionForArrayTemplate(hasArrayElementsAssertionTemplate);
        this.setIsAssertionTemplate(isAssertionTemplate);
        this.setStandardAssertionsEntryPointClassTemplate(entryPointAssertionsClassTemplate);
        this.setStandardAssertionEntryPointMethodTemplate(entryPointAssertionTemplate);
        this.setSoftAssertionsEntryPointClassTemplate(entryPointSoftAssertionsClassTemplate);
        this.setJUnitSoftAssertionsEntryPointClassTemplate(entryPointJUnitSoftAssertionsClassTemplate);
        this.setSoftAssertionEntryPointMethodTemplate(entryPointSoftAssertionTemplate);
        this.setBddAssertionsEntryPointClassTemplate(bddAssertionsEntryPointClassTemplate);
        this.setBddAssertionEntryPointMethodTemplate(bddAssertionEntryPointMethodTemplate);
    }

    public final void setAssertionClassTemplate(Template assertionClassTemplate) {
        BaseAssertionGenerator.checkTemplateParameter(assertionClassTemplate, Template.Type.ASSERT_CLASS);
        this.classAssertionTemplate = assertionClassTemplate;
    }

    public final void setHierarchicalAssertionClassTemplate(Template hierarchicalAssertionClassTemplate) {
        BaseAssertionGenerator.checkTemplateParameter(hierarchicalAssertionClassTemplate, Template.Type.HIERARCHICAL_ASSERT_CLASS);
        this.hierarchicalClassAssertionTemplate = hierarchicalAssertionClassTemplate;
    }

    public final void setAbstractAssertionClassTemplate(Template abstractAssertionClassTemplate) {
        BaseAssertionGenerator.checkTemplateParameter(abstractAssertionClassTemplate, Template.Type.ABSTRACT_ASSERT_CLASS);
        this.abstractClassAssertionTemplate = abstractAssertionClassTemplate;
    }

    public final void setHasAssertionTemplate(Template hasAssertionTemplate) {
        BaseAssertionGenerator.checkTemplateParameter(hasAssertionTemplate, Template.Type.HAS);
        this.hasAssertionTemplate = hasAssertionTemplate;
    }

    public final void setHasAssertionTemplateForPrimitive(Template hasAssertionTemplateForPrimitive) {
        BaseAssertionGenerator.checkTemplateParameter(hasAssertionTemplateForPrimitive, Template.Type.HAS_FOR_PRIMITIVE);
        this.hasAssertionTemplateForPrimitive = hasAssertionTemplateForPrimitive;
    }

    public final void setHasAssertionTemplateForRealNumber(Template hasAssertionTemplateForRealNumber) {
        BaseAssertionGenerator.checkTemplateParameter(hasAssertionTemplateForRealNumber, Template.Type.HAS_FOR_REAL_NUMBER);
        this.hasAssertionTemplateForRealNumber = hasAssertionTemplateForRealNumber;
    }

    public final void setHasElementsAssertionForIterableTemplate(Template hasIterableElementsAssertionTemplate) {
        BaseAssertionGenerator.checkTemplateParameter(hasIterableElementsAssertionTemplate, Template.Type.HAS_FOR_ITERABLE);
        this.hasIterableElementsAssertionTemplate = hasIterableElementsAssertionTemplate;
    }

    public final void setHasElementsAssertionForArrayTemplate(Template hasArrayElementsAssertionTemplate) {
        BaseAssertionGenerator.checkTemplateParameter(hasArrayElementsAssertionTemplate, Template.Type.HAS_FOR_ARRAY);
        this.hasArrayElementsAssertionTemplate = hasArrayElementsAssertionTemplate;
    }

    public final void setIsAssertionTemplate(Template isAssertionTemplate) {
        BaseAssertionGenerator.checkTemplateParameter(isAssertionTemplate, Template.Type.IS);
        this.isAssertionTemplate = isAssertionTemplate;
    }

    public void setStandardAssertionsEntryPointClassTemplate(Template standardAssertionsEntryPointClassTemplate) {
        BaseAssertionGenerator.checkTemplateParameter(standardAssertionsEntryPointClassTemplate, Template.Type.ASSERTIONS_ENTRY_POINT_CLASS);
        this.standardAssertionsEntryPointClassTemplate = standardAssertionsEntryPointClassTemplate;
    }

    public void setStandardAssertionEntryPointMethodTemplate(Template standardAssertionEntryPointMethodTemplate) {
        BaseAssertionGenerator.checkTemplateParameter(standardAssertionEntryPointMethodTemplate, Template.Type.ASSERTION_ENTRY_POINT);
        this.standardAssertionEntryPointMethodTemplate = standardAssertionEntryPointMethodTemplate;
    }

    public void setDirectoryWhereAssertionFilesAreGenerated(String targetBaseDirectory) {
        this.targetBaseDirectory = targetBaseDirectory;
    }

    public void setSoftAssertionsEntryPointClassTemplate(Template softAssertionsEntryPointClassTemplate) {
        this.softAssertionsEntryPointClassTemplate = softAssertionsEntryPointClassTemplate;
    }

    public void setJUnitSoftAssertionsEntryPointClassTemplate(Template junitSoftAssertionsEntryPointClassTemplate) {
        this.junitSoftAssertionsEntryPointClassTemplate = junitSoftAssertionsEntryPointClassTemplate;
    }

    public void setSoftAssertionEntryPointMethodTemplate(Template softAssertionEntryPointMethodTemplate) {
        this.softAssertionEntryPointMethodTemplate = softAssertionEntryPointMethodTemplate;
    }

    public void setBddAssertionsEntryPointClassTemplate(Template bddAssertionsEntryPointClassTemplate) {
        this.bddAssertionsEntryPointClassTemplate = bddAssertionsEntryPointClassTemplate;
    }

    public void setBddAssertionEntryPointMethodTemplate(Template bddAssertionEntryPointMethodTemplate) {
        this.bddAssertionEntryPointMethodTemplate = bddAssertionEntryPointMethodTemplate;
    }

    @Override
    public File generateCustomAssertionFor(ClassDescription classDescription) throws IOException {
        String assertionFileContent = this.generateCustomAssertionContentFor(classDescription);
        String targetDirectory = this.getDirectoryPathCorrespondingToPackage(classDescription.getPackageName());
        new File(targetDirectory).mkdirs();
        return this.createFile(assertionFileContent, BaseAssertionGenerator.assertClassNameOf(classDescription) + ".java", targetDirectory);
    }

    @Override
    public File[] generateHierarchicalCustomAssertionFor(ClassDescription classDescription, Set<Class<?>> allClasses) throws IOException {
        String[] assertionFileContent = this.generateHierarchicalCustomAssertionContentFor(classDescription, allClasses);
        String targetDirectory = this.getDirectoryPathCorrespondingToPackage(classDescription.getPackageName());
        new File(targetDirectory).mkdirs();
        File[] assertionClassesFile = new File[2];
        String concreteAsserClassFileName = BaseAssertionGenerator.assertClassNameOf(classDescription) + ".java";
        String abstractAsserClassFileName = BaseAssertionGenerator.abstractAssertClassNameOf(classDescription) + ".java";
        assertionClassesFile[0] = this.createFile(assertionFileContent[0], abstractAsserClassFileName, targetDirectory);
        assertionClassesFile[1] = this.createFile(assertionFileContent[1], concreteAsserClassFileName, targetDirectory);
        return assertionClassesFile;
    }

    @Override
    public String[] generateHierarchicalCustomAssertionContentFor(ClassDescription classDescription, Set<Class<?>> allClasses) {
        StringBuilder abstractAssertClassContentBuilder = new StringBuilder(this.abstractClassAssertionTemplate.getContent());
        abstractAssertClassContentBuilder.append(this.generateAssertionsForDeclaredGettersOf(classDescription));
        abstractAssertClassContentBuilder.append(this.generateAssertionsForDeclaredPublicFieldsOf(classDescription));
        abstractAssertClassContentBuilder.append(LINE_SEPARATOR).append("}").append(LINE_SEPARATOR);
        StringBuilder concreteAssertClassContentBuilder = new StringBuilder(this.hierarchicalClassAssertionTemplate.getContent());
        String[] assertionClassesContent = new String[]{this.fillAssertClassTemplate(abstractAssertClassContentBuilder.toString(), classDescription, allClasses, false), this.fillAssertClassTemplate(concreteAssertClassContentBuilder.toString(), classDescription, null, true)};
        return assertionClassesContent;
    }

    private String fillAssertClassTemplate(String template, ClassDescription classDescription, Set<Class<?>> classesHierarchy, boolean concrete) {
        TypeName superAssertionClass;
        TreeSet<TypeName> assertjImports = new TreeSet<TypeName>();
        if (template.contains("Assertions.")) {
            assertjImports.add(new TypeName("org.assertj.core.api.Assertions"));
        }
        if (template.contains("Objects.")) {
            assertjImports.add(new TypeName("org.assertj.core.util.Objects"));
        }
        if (template.contains("Iterables.")) {
            assertjImports.add(new TypeName("org.assertj.core.internal.Iterables"));
        }
        if (classesHierarchy == null || !classesHierarchy.contains(classDescription.getSuperType())) {
            superAssertionClass = new TypeName("org.assertj.core.api.AbstractAssert");
        } else {
            TypeName superTypeName = new TypeName(classDescription.getSuperType());
            superAssertionClass = new TypeName(BaseAssertionGenerator.abstractAssertClassNameOf(superTypeName), superTypeName.getPackageName());
        }
        assertjImports.add(superAssertionClass);
        String customAssertionClass = concrete ? BaseAssertionGenerator.assertClassNameOf(classDescription) : BaseAssertionGenerator.abstractAssertClassNameOf(classDescription);
        String selfType = concrete ? customAssertionClass : "S";
        String myself = concrete ? "this" : "myself";
        template = StringUtils.replace((String)template, (String)PACKAGE, (String)classDescription.getPackageName());
        template = StringUtils.replace((String)template, (String)CUSTOM_ASSERTION_CLASS, (String)customAssertionClass);
        template = StringUtils.replace((String)template, (String)SUPER_ASSERTION_CLASS, (String)superAssertionClass.getSimpleNameWithOuterClassNotSeparatedByDots());
        template = StringUtils.replace((String)template, (String)CLASS_TO_ASSERT, (String)classDescription.getClassNameWithOuterClass());
        template = StringUtils.replace((String)template, (String)SELF_TYPE, (String)selfType);
        template = StringUtils.replace((String)template, (String)MYSELF, (String)myself);
        template = StringUtils.replace((String)template, (String)IMPORTS, (String)BaseAssertionGenerator.listNeededImports(assertjImports, classDescription.getPackageName()));
        return template;
    }

    private String fillAssertClassTemplate(String template, ClassDescription classDescription) {
        return this.fillAssertClassTemplate(template, classDescription, null, true);
    }

    @Override
    public String generateCustomAssertionContentFor(ClassDescription classDescription) {
        StringBuilder assertionFileContentBuilder = new StringBuilder(this.classAssertionTemplate.getContent());
        assertionFileContentBuilder.append(this.generateAssertionsForGettersOf(classDescription));
        assertionFileContentBuilder.append(this.generateAssertionsForPublicFieldsOf(classDescription));
        assertionFileContentBuilder.append(LINE_SEPARATOR).append("}").append(LINE_SEPARATOR);
        return this.fillAssertClassTemplate(assertionFileContentBuilder.toString(), classDescription);
    }

    @Override
    public String generateAssertionsEntryPointClassContentFor(Set<ClassDescription> classDescriptionSet, AssertionsEntryPointType assertionsEntryPointType, String entryPointClassPackage) {
        if (BaseAssertionGenerator.noClassDescriptionsGiven(classDescriptionSet)) {
            return "";
        }
        Template assertionEntryPointMethodTemplate = this.chooseAssertionEntryPointMethodTemplate(assertionsEntryPointType);
        Template assertionsEntryPointClassTemplate = this.chooseAssertionEntryPointClassTemplate(assertionsEntryPointType);
        return this.generateAssertionsEntryPointClassContent(classDescriptionSet, assertionsEntryPointClassTemplate, assertionEntryPointMethodTemplate, entryPointClassPackage);
    }

    private Template chooseAssertionEntryPointMethodTemplate(AssertionsEntryPointType assertionsEntryPointType) {
        switch (assertionsEntryPointType) {
            case SOFT: 
            case JUNIT_SOFT: {
                return this.softAssertionEntryPointMethodTemplate;
            }
            case BDD: {
                return this.bddAssertionEntryPointMethodTemplate;
            }
        }
        return this.standardAssertionEntryPointMethodTemplate;
    }

    private Template chooseAssertionEntryPointClassTemplate(AssertionsEntryPointType assertionsEntryPointType) {
        switch (assertionsEntryPointType) {
            case SOFT: {
                return this.softAssertionsEntryPointClassTemplate;
            }
            case JUNIT_SOFT: {
                return this.junitSoftAssertionsEntryPointClassTemplate;
            }
            case BDD: {
                return this.bddAssertionsEntryPointClassTemplate;
            }
        }
        return this.standardAssertionsEntryPointClassTemplate;
    }

    @Override
    public File generateAssertionsEntryPointClassFor(Set<ClassDescription> classDescriptionSet, AssertionsEntryPointType assertionsEntryPointType, String entryPointClassPackage) throws IOException {
        if (BaseAssertionGenerator.noClassDescriptionsGiven(classDescriptionSet)) {
            return null;
        }
        String assertionsEntryPointFileContent = this.generateAssertionsEntryPointClassContentFor(classDescriptionSet, assertionsEntryPointType, entryPointClassPackage);
        return this.createAssertionsFileFor(classDescriptionSet, assertionsEntryPointFileContent, assertionsEntryPointType.getFileName(), entryPointClassPackage);
    }

    private String generateAssertionsEntryPointClassContent(Set<ClassDescription> classDescriptionSet, Template entryPointAssertionsClassTemplate, Template entryPointAssertionMethodTemplate, String entryPointClassPackage) {
        String entryPointAssertionsClassContent = entryPointAssertionsClassTemplate.getContent();
        String classPackage = StringUtils.isEmpty((CharSequence)entryPointClassPackage) ? this.determineBestEntryPointsAssertionsClassPackage(classDescriptionSet) : entryPointClassPackage;
        entryPointAssertionsClassContent = StringUtils.replace((String)entryPointAssertionsClassContent, (String)PACKAGE, (String)classPackage);
        String allEntryPointsAssertionContent = this.generateAssertionEntryPointMethodsFor(classDescriptionSet, entryPointAssertionMethodTemplate);
        entryPointAssertionsClassContent = StringUtils.replace((String)entryPointAssertionsClassContent, (String)ALL_ASSERTIONS_ENTRY_POINTS, (String)allEntryPointsAssertionContent);
        return entryPointAssertionsClassContent;
    }

    private File createAssertionsFileFor(Set<ClassDescription> classDescriptionSet, String fileContent, String fileName, String assertionsClassPackage) throws IOException {
        String classPackage = StringUtils.isEmpty((CharSequence)assertionsClassPackage) ? this.determineBestEntryPointsAssertionsClassPackage(classDescriptionSet) : assertionsClassPackage;
        String assertionsDirectory = this.getDirectoryPathCorrespondingToPackage(classPackage);
        new File(assertionsDirectory).mkdirs();
        return this.createFile(fileContent, fileName, assertionsDirectory);
    }

    private String generateAssertionEntryPointMethodsFor(Set<ClassDescription> classDescriptionSet, Template assertionEntryPointMethodTemplate) {
        TreeSet<ClassDescription> sortedClassDescriptionSet = new TreeSet<ClassDescription>(classDescriptionSet);
        StringBuilder allAssertThatsContentBuilder = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        for (ClassDescription classDescription : sortedClassDescriptionSet) {
            String assertionEntryPointMethodContent = assertionEntryPointMethodTemplate.getContent();
            assertionEntryPointMethodContent = StringUtils.replace((String)assertionEntryPointMethodContent, (String)CUSTOM_ASSERTION_CLASS, (String)BaseAssertionGenerator.fullyQualifiedAssertClassName(classDescription));
            assertionEntryPointMethodContent = StringUtils.replace((String)assertionEntryPointMethodContent, (String)CLASS_TO_ASSERT, (String)classDescription.getFullyQualifiedClassName());
            allAssertThatsContentBuilder.append(lineSeparator).append(assertionEntryPointMethodContent);
        }
        return allAssertThatsContentBuilder.toString();
    }

    private String determineBestEntryPointsAssertionsClassPackage(Set<ClassDescription> classDescriptionSet) {
        TreeSet<String> packages = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }
        });
        for (ClassDescription classDescription : classDescriptionSet) {
            packages.add(classDescription.getPackageName());
        }
        return (String)packages.first();
    }

    private static String assertClassNameOf(ClassDescription classDescription) {
        return BaseAssertionGenerator.assertClassNameOf(classDescription.getTypeName());
    }

    private static String assertClassNameOf(TypeName type) {
        return type.getSimpleNameWithOuterClassNotSeparatedByDots() + ASSERT_CLASS_SUFFIX;
    }

    private static String abstractAssertClassNameOf(ClassDescription classDescription) {
        return BaseAssertionGenerator.abstractAssertClassNameOf(classDescription.getTypeName());
    }

    private static String abstractAssertClassNameOf(TypeName type) {
        return ABSTRACT_ASSERT_CLASS_PREFIX + BaseAssertionGenerator.assertClassNameOf(type);
    }

    private static String fullyQualifiedAssertClassName(ClassDescription classDescription) {
        return classDescription.getPackageName() + "." + classDescription.getClassNameWithOuterClassNotSeparatedByDots() + ASSERT_CLASS_SUFFIX;
    }

    private String getDirectoryPathCorrespondingToPackage(String packageName) {
        return this.targetBaseDirectory + File.separator + packageName.replace('.', File.separatorChar);
    }

    private static String listNeededImports(Set<TypeName> typesToImport, String classPackage) {
        StringBuilder importsBuilder = new StringBuilder();
        for (TypeName type : typesToImport) {
            if (type.isPrimitive() || type.belongsToJavaLangPackage() || type.getPackageName().equals(classPackage)) continue;
            importsBuilder.append(String.format(IMPORT_LINE, type, LINE_SEPARATOR));
        }
        return importsBuilder.toString();
    }

    protected String generateAssertionsForGettersOf(ClassDescription classDescription) {
        return this.generateAssertionsForGetters(classDescription.getGettersDescriptions(), classDescription);
    }

    protected String generateAssertionsForDeclaredGettersOf(ClassDescription classDescription) {
        return this.generateAssertionsForGetters(classDescription.getDeclaredGettersDescriptions(), classDescription);
    }

    protected String generateAssertionsForGetters(Set<GetterDescription> getters, ClassDescription classDescription) {
        StringBuilder assertionsForGetters = new StringBuilder();
        for (GetterDescription getter : getters) {
            String assertionContent = this.assertionContentForProperty(getter, classDescription);
            assertionsForGetters.append(assertionContent).append(LINE_SEPARATOR);
        }
        return assertionsForGetters.toString();
    }

    protected String generateAssertionsForPublicFieldsOf(ClassDescription classDescription) {
        return this.generateAssertionsForPublicFields(classDescription.getFieldsDescriptions(), classDescription);
    }

    protected String generateAssertionsForDeclaredPublicFieldsOf(ClassDescription classDescription) {
        return this.generateAssertionsForPublicFields(classDescription.getDeclaredFieldsDescriptions(), classDescription);
    }

    protected String generateAssertionsForPublicFields(Set<FieldDescription> fields, ClassDescription classDescription) {
        StringBuilder assertionsForPublicFields = new StringBuilder();
        for (FieldDescription field : fields) {
            String assertionContent = this.assertionContentForField(field, classDescription);
            assertionsForPublicFields.append(assertionContent).append(LINE_SEPARATOR);
        }
        return assertionsForPublicFields.toString();
    }

    private String assertionContentForField(FieldDescription field, ClassDescription classDescription) {
        String assertionContent = this.baseAssertionContentFor(field, classDescription);
        assertionContent = assertionContent.replace("get${Property}()", PROPERTY_WITH_LOWERCASE_FIRST_CHAR).replace("is${Property}())", "${property})");
        assertionContent = StringUtils.remove((String)assertionContent, (String)THROWS);
        assertionContent = StringUtils.remove((String)assertionContent, (String)THROWS_JAVADOC);
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_UPPERCASE_FIRST_CHAR, (String)StringUtils.capitalize((String)field.getName()));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_TYPE, (String)field.getFullyQualifiedTypeNameIfNeeded(classDescription.getPackageName()));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_LOWERCASE_FIRST_CHAR, (String)field.getName());
        return assertionContent;
    }

    private String assertionContentForProperty(GetterDescription getter, ClassDescription classDescription) {
        String assertionContent = this.baseAssertionContentFor(getter, classDescription);
        assertionContent = this.declareExceptions(getter, assertionContent, classDescription);
        String propertyName = getter.getPropertyName();
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_UPPERCASE_FIRST_CHAR, (String)StringUtils.capitalize((String)propertyName));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_TYPE, (String)getter.getFullyQualifiedTypeNameIfNeeded(classDescription.getPackageName()));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_LOWERCASE_FIRST_CHAR, (String)propertyName);
        return assertionContent;
    }

    private String baseAssertionContentFor(DataDescription fieldOrProperty, ClassDescription classDescription) {
        String assertionContent = this.hasAssertionTemplate.getContent();
        if (fieldOrProperty.isBooleanType()) {
            assertionContent = this.isAssertionTemplate.getContent();
        } else if (fieldOrProperty.isIterableType()) {
            assertionContent = StringUtils.replace((String)this.hasIterableElementsAssertionTemplate.getContent(), (String)ELEMENT_TYPE, (String)fieldOrProperty.getElementTypeName(classDescription.getPackageName()));
        } else if (fieldOrProperty.isArrayType()) {
            assertionContent = StringUtils.replace((String)this.hasArrayElementsAssertionTemplate.getContent(), (String)ELEMENT_TYPE, (String)fieldOrProperty.getElementTypeName(classDescription.getPackageName()));
        } else if (fieldOrProperty.isRealNumberType()) {
            assertionContent = this.hasAssertionTemplateForRealNumber.getContent();
        } else if (fieldOrProperty.isPrimitiveType()) {
            assertionContent = this.hasAssertionTemplateForPrimitive.getContent();
        }
        return assertionContent;
    }

    private String declareExceptions(GetterDescription getter, String assertionContent, ClassDescription classDescription) {
        StringBuilder throwsClause = new StringBuilder();
        StringBuilder throwsJavaDoc = new StringBuilder();
        boolean first = true;
        for (TypeName exception : getter.getExceptions()) {
            if (first) {
                throwsClause.append("throws ");
            } else {
                throwsClause.append(", ");
            }
            first = false;
            String exceptionName = exception.getFullyQualifiedTypeNameIfNeeded(classDescription.getPackageName());
            throwsClause.append(exceptionName);
            throwsJavaDoc.append(LINE_SEPARATOR).append("   * @throws ").append(exceptionName);
            throwsJavaDoc.append(" if actual.").append(getter.isBooleanType() ? "is" : "get").append("${Property}() throws one.");
        }
        if (!getter.getExceptions().isEmpty()) {
            throwsClause.append(' ');
        }
        assertionContent = assertionContent.replace(THROWS_JAVADOC, throwsJavaDoc.toString());
        assertionContent = assertionContent.replace(THROWS, throwsClause.toString());
        return assertionContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillFile(String customAssertionContent, File assertionJavaFile) throws IOException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(assertionJavaFile);
            fileWriter.write(customAssertionContent);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    private File createFile(String fileContent, String fileName, String targetDirectory) throws IOException {
        File file = new File(targetDirectory, fileName);
        file.createNewFile();
        this.fillFile(fileContent, file);
        return file;
    }

    private static void checkTemplateParameter(Template assertionClassTemplate, Template.Type templateType) {
        if (assertionClassTemplate == null) {
            throw new NullPointerException("Expecting a non null Template");
        }
        if (templateType != assertionClassTemplate.getType()) {
            throw new IllegalArgumentException("Expecting a Template type to be '" + (Object)((Object)templateType) + "' but was '" + (Object)((Object)assertionClassTemplate.getType()) + "'");
        }
        if (assertionClassTemplate.getContent() == null) {
            throw new NullPointerException("Expecting a non null content in the Template");
        }
    }

    private static boolean noClassDescriptionsGiven(Set<ClassDescription> classDescriptionSet) {
        return classDescriptionSet == null || classDescriptionSet.isEmpty();
    }
}

