/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.commons.io.IOUtils;

public class Template {
    private String content;
    private final Type type;

    public Template(Type type, String templateContent) {
        this.content = templateContent;
        this.type = type;
    }

    public Template(Type type, URL url) {
        this.type = type;
        try {
            File urlFile = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
            if (!urlFile.isFile()) {
                throw new RuntimeException("Failed to read template from an URL which is not a file, URL was :" + url);
            }
            this.content = this.readContentThenClose(url.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read template from " + url, e);
        }
    }

    public Template(Type type, File file) {
        this.type = type;
        String path = file.getPath();
        try {
            this.content = this.readTemplateFile(file, file.getPath());
        }
        catch (RuntimeException e) {
            this.content = this.readTemplateFile(file, path.replace('\\', '/'));
        }
    }

    private String readTemplateFile(File file, String path) {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            return this.readContentThenClose(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read template from file " + file, e);
        }
    }

    public String getContent() {
        return this.content;
    }

    public Type getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContentThenClose(InputStream input) throws IOException {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            IOUtils.copy((InputStream)input, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public static enum Type {
        IS,
        HAS_FOR_ARRAY,
        HAS_FOR_ITERABLE,
        HAS,
        HAS_FOR_PRIMITIVE,
        ASSERT_CLASS,
        HIERARCHICAL_ASSERT_CLASS,
        ABSTRACT_ASSERT_CLASS,
        ASSERTIONS_ENTRY_POINT_CLASS,
        ASSERTION_ENTRY_POINT,
        SOFT_ASSERTIONS_ENTRY_POINT_CLASS,
        JUNIT_SOFT_ASSERTIONS_ENTRY_POINT_CLASS,
        SOFT_ENTRY_POINT_METHOD_ASSERTION,
        BDD_ASSERTIONS_ENTRY_POINT_CLASS,
        BDD_ENTRY_POINT_METHOD_ASSERTION,
        HAS_FOR_REAL_NUMBER;

    }
}

