/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectEnumerableAssert;
import org.assertj.core.api.filter.FilterOperator;
import org.assertj.core.api.filter.Filters;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.FieldsOrPropertiesExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.IgnoringFieldsComparator;
import org.assertj.core.internal.IterableElementComparisonStrategy;
import org.assertj.core.internal.Iterables;
import org.assertj.core.internal.ObjectArrays;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.OnFieldsComparator;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractIterableAssert<S extends AbstractIterableAssert<S, A, T>, A extends Iterable<? extends T>, T>
extends AbstractAssert<S, A>
implements ObjectEnumerableAssert<S, T> {
    @VisibleForTesting
    Iterables iterables = Iterables.instance();

    protected AbstractIterableAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.iterables.assertNullOrEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public void isEmpty() {
        this.iterables.assertEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.iterables.assertNotEmpty(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.iterables.assertHasSize(this.info, (Iterable)this.actual, expected);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S contains(T ... values) {
        this.iterables.assertContains(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsOnly(T ... values) {
        this.iterables.assertContainsOnly(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsOnlyOnce(T ... values) {
        this.iterables.assertContainsOnlyOnce(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsExactly(T ... values) {
        this.iterables.assertContainsExactly(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S isSubsetOf(Iterable<? extends T> values) {
        this.iterables.assertIsSubsetOf(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsSequence(T ... sequence) {
        this.iterables.assertContainsSequence(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsSubsequence(T ... sequence) {
        this.iterables.assertContainsSubsequence(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotContain(T ... values) {
        this.iterables.assertDoesNotContain(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotContainAnyElementsOf(Iterable<? extends T> iterable) {
        this.iterables.assertDoesNotContainAnyElementsOf(this.info, (Iterable)this.actual, iterable);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotHaveDuplicates() {
        this.iterables.assertDoesNotHaveDuplicates(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S startsWith(T ... sequence) {
        this.iterables.assertStartsWith(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S endsWith(T ... sequence) {
        this.iterables.assertEndsWith(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsNull() {
        this.iterables.assertContainsNull(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotContainNull() {
        this.iterables.assertDoesNotContainNull(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S are(Condition<? super T> condition) {
        this.iterables.assertAre(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areNot(Condition<? super T> condition) {
        this.iterables.assertAreNot(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S have(Condition<? super T> condition) {
        this.iterables.assertHave(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doNotHave(Condition<? super T> condition) {
        this.iterables.assertDoNotHave(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areAtLeastOne(Condition<? super T> condition) {
        this.areAtLeast(1, (Condition)condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areAtLeast(int times, Condition<? super T> condition) {
        this.iterables.assertAreAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areAtMost(int times, Condition<? super T> condition) {
        this.iterables.assertAreAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areExactly(int times, Condition<? super T> condition) {
        this.iterables.assertAreExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S haveAtLeastOne(Condition<? super T> condition) {
        return (S)this.haveAtLeast(1, (Condition)condition);
    }

    @Override
    public S haveAtLeast(int times, Condition<? super T> condition) {
        this.iterables.assertHaveAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S haveAtMost(int times, Condition<? super T> condition) {
        this.iterables.assertHaveAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S haveExactly(int times, Condition<? super T> condition) {
        this.iterables.assertHaveExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasAtLeastOneElementOfType(Class<?> expectedType) {
        ObjectArrays.instance().assertHasAtLeastOneElementOfType(this.info, IterableUtil.toArray((Iterable)this.actual), expectedType);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasOnlyElementsOfType(Class<?> expectedType) {
        ObjectArrays.instance().assertHasOnlyElementsOfType(this.info, IterableUtil.toArray((Iterable)this.actual), expectedType);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsAll(Iterable<? extends T> iterable) {
        this.iterables.assertContainsAll(this.info, (Iterable)this.actual, iterable);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super T> elementComparator) {
        this.iterables = new Iterables(new ComparatorBasedComparisonStrategy(elementComparator));
        this.objects = new Objects(new IterableElementComparisonStrategy<T>(elementComparator));
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.usingDefaultComparator();
        this.iterables = Iterables.instance();
        return (S)((AbstractIterableAssert)this.myself);
    }

    public ListAssert<Object> extracting(String propertyOrField) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertyOrField));
        return new ListAssert<Object>(values);
    }

    public ListAssert<Object> extractingResultOf(String method) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.resultOf(method));
        return new ListAssert<Object>(values);
    }

    public <P> ListAssert<P> extractingResultOf(String method, Class<P> extractedType) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.resultOf(method));
        return new ListAssert<Object>(values);
    }

    public <P> ListAssert<P> extracting(String propertyOrField, Class<P> extractingType) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertyOrField));
        return new ListAssert<Object>(values);
    }

    public ListAssert<Tuple> extracting(String ... propertiesOrFields) {
        List<Tuple> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertiesOrFields));
        return new ListAssert<Tuple>(values);
    }

    public <V> ListAssert<V> extracting(Extractor<? super T, V> extractor) {
        List<V> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, extractor);
        return new ListAssert<V>(values);
    }

    public <V> ListAssert<V> flatExtracting(Extractor<? super T, ? extends Collection<V>> extractor) {
        ArrayList result = Lists.newArrayList();
        List<Collection<V>> extractedValues = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, extractor);
        for (Collection<V> iterable : extractedValues) {
            result.addAll(iterable);
        }
        return new ListAssert(result);
    }

    public ListAssert<Object> flatExtracting(String propertyName) {
        ArrayList extractedValues = Lists.newArrayList();
        List<Object> extractedGroups = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertyName));
        for (Object group : extractedGroups) {
            if (Arrays.isArray(group)) {
                int size = Array.getLength(group);
                for (int i = 0; i < size; ++i) {
                    extractedValues.add(Array.get(group, i));
                }
                continue;
            }
            if (group instanceof Iterable) {
                Iterable iterable = (Iterable)group;
                for (Object value : iterable) {
                    extractedValues.add(value);
                }
                continue;
            }
            CommonErrors.wrongElementTypeForFlatExtracting(group);
        }
        return new ListAssert<Object>(extractedValues);
    }

    @Override
    public S containsExactlyElementsOf(Iterable<? extends T> iterable) {
        return (S)this.containsExactly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public S containsOnlyElementsOf(Iterable<? extends T> iterable) {
        return (S)this.containsOnly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public S hasSameElementsAs(Iterable<? extends T> iterable) {
        return (S)this.containsOnlyElementsOf((Iterable)iterable);
    }

    public S usingFieldByFieldElementComparator() {
        return (S)this.usingElementComparator((Comparator)new FieldByFieldComparator());
    }

    public S usingElementComparatorOnFields(String ... fields) {
        return (S)this.usingElementComparator((Comparator)new OnFieldsComparator(fields));
    }

    protected S usingComparisonStrategy(ComparisonStrategy comparisonStrategy) {
        this.iterables = new Iterables(comparisonStrategy);
        return (S)((AbstractIterableAssert)this.myself);
    }

    public S usingElementComparatorIgnoringFields(String ... fields) {
        return (S)this.usingElementComparator((Comparator)new IgnoringFieldsComparator(fields));
    }

    @Override
    public S inHexadecimal() {
        return (S)((AbstractIterableAssert)super.inHexadecimal());
    }

    @Override
    public S inBinary() {
        return (S)((AbstractIterableAssert)super.inBinary());
    }

    public S filteredOn(String propertyOrFieldName, Object expectedValue) {
        Filters filter = Filters.filter((Iterable)this.actual);
        Iterable filteredIterable = filter.with(propertyOrFieldName, expectedValue).get();
        return (S)new ListAssert(Lists.newArrayList(filteredIterable));
    }

    public S filteredOnNull(String propertyOrFieldName) {
        return this.filteredOn(propertyOrFieldName, (Object)null);
    }

    public S filteredOn(String propertyOrFieldName, FilterOperator<?> filterOperator) {
        Preconditions.checkNotNull(filterOperator);
        Filters filter = Filters.filter((Iterable)this.actual).with(propertyOrFieldName);
        filterOperator.applyOn(filter);
        return (S)new ListAssert(Lists.newArrayList(filter.get()));
    }

    public S filteredOn(Condition<? super T> condition) {
        Filters<? super T> filter = Filters.filter((Iterable)this.actual);
        Iterable<? super T> filteredIterable = filter.being(condition).get();
        return (S)new ListAssert<T>(Lists.newArrayList(filteredIterable));
    }
}

