/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.net.URI;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Uris;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractUriAssert<S extends AbstractUriAssert<S>>
extends AbstractAssert<S, URI> {
    @VisibleForTesting
    protected Uris uris = Uris.instance();

    protected AbstractUriAssert(URI actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S hasPath(String expected) {
        this.uris.assertHasPath(this.info, (URI)this.actual, expected);
        return (S)((AbstractUriAssert)this.myself);
    }

    public S hasNoPath() {
        this.uris.assertHasPath(this.info, (URI)this.actual, null);
        return (S)((AbstractUriAssert)this.myself);
    }

    public S hasPort(int expected) {
        this.uris.assertHasPort(this.info, (URI)this.actual, expected);
        return (S)((AbstractUriAssert)this.myself);
    }

    public S hasNoPort() {
        this.uris.assertHasPort(this.info, (URI)this.actual, -1);
        return (S)((AbstractUriAssert)this.myself);
    }

    public S hasHost(String expected) {
        this.uris.assertHasHost(this.info, (URI)this.actual, expected);
        return (S)((AbstractUriAssert)this.myself);
    }

    public S hasAuthority(String expected) {
        this.uris.assertHasAuthority(this.info, (URI)this.actual, expected);
        return (S)((AbstractUriAssert)this.myself);
    }

    public S hasFragment(String expected) {
        this.uris.assertHasFragment(this.info, (URI)this.actual, expected);
        return (S)((AbstractUriAssert)this.myself);
    }

    public S hasNoFragment() {
        this.uris.assertHasFragment(this.info, (URI)this.actual, null);
        return (S)((AbstractUriAssert)this.myself);
    }

    public S hasQuery(String expected) {
        this.uris.assertHasQuery(this.info, (URI)this.actual, expected);
        return (S)((AbstractUriAssert)this.myself);
    }

    public S hasNoQuery() {
        this.uris.assertHasQuery(this.info, (URI)this.actual, null);
        return (S)((AbstractUriAssert)this.myself);
    }

    public S hasScheme(String expected) {
        this.uris.assertHasScheme(this.info, (URI)this.actual, expected);
        return (S)((AbstractUriAssert)this.myself);
    }

    public S hasUserInfo(String expected) {
        this.uris.assertHasUserInfo(this.info, (URI)this.actual, expected);
        return (S)((AbstractUriAssert)this.myself);
    }

    public S hasNoUserInfo() {
        this.uris.assertHasUserInfo(this.info, (URI)this.actual, null);
        return (S)((AbstractUriAssert)this.myself);
    }
}

