/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * Copyright 2012-2020 the original author or authors.
 */
package org.assertj.core.api;

/**
 * Parent interface for soft assertion implementations.
 *
 * @author Fr Jeremy Krieg
 * @see AbstractSoftAssertions
 * @see SoftAssertions
 */
public interface AutoCloseableSoftAssertionsProvider extends SoftAssertionsProvider, AutoCloseable {

  /**
   * Allows the SoftAssertionsProvider to be used as an {@link AutoCloseable} by calling {@link #assertAll()}.
   *
   * @see #assertAll
   */
  @Override
  default void close() {
    assertAll();
  }

}
