/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Map;
import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldHaveSizeBetween;
import org.assertj.core.error.ShouldHaveSizeGreaterThan;
import org.assertj.core.error.ShouldHaveSizeGreaterThanOrEqualTo;
import org.assertj.core.error.ShouldHaveSizeLessThan;
import org.assertj.core.error.ShouldHaveSizeLessThanOrEqualTo;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Preconditions;
import org.assertj.vavr.api.AbstractValueAssert;
import org.assertj.vavr.internal.Maps;

abstract class AbstractMapAssert<SELF extends AbstractMapAssert<SELF, ACTUAL, KEY, VALUE>, ACTUAL extends Map<KEY, VALUE>, KEY, VALUE>
extends AbstractValueAssert<SELF, ACTUAL>
implements EnumerableAssert<SELF, Tuple2<? extends KEY, ? extends VALUE>> {
    private final Maps maps = Maps.instance();
    private ComparisonStrategy elementComparisonStrategy = StandardComparisonStrategy.instance();

    AbstractMapAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF allSatisfy(BiConsumer<? super KEY, ? super VALUE> entryRequirements) {
        Preconditions.checkNotNull(entryRequirements, (String)"The BiConsumer<K, V> expressing the assertions requirements must not be null");
        this.isNotNull();
        ((Map)this.actual).forEach(entry -> entryRequirements.accept((Object)entry._1, (Object)entry._2));
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(KEY key, Condition<? super VALUE> valueCondition) {
        this.maps.assertHasEntrySatisfying((AssertionInfo)this.info, (Map)this.actual, key, valueCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public void isNullOrEmpty() {
        if (this.actual != null && !((Map)this.actual).isEmpty()) {
            this.throwAssertionError(ShouldBeNullOrEmpty.shouldBeNullOrEmpty((Object)this.actual));
        }
    }

    public void isEmpty() {
        this.isNotNull();
        if (!((Map)this.actual).isEmpty()) {
            this.throwAssertionError(ShouldBeEmpty.shouldBeEmpty((Object)this.actual));
        }
    }

    public SELF isNotEmpty() {
        this.isNotNull();
        if (((Map)this.actual).isEmpty()) {
            this.throwAssertionError(ShouldNotBeEmpty.shouldNotBeEmpty());
        }
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF contains(Tuple2<KEY, VALUE> ... entries) {
        this.maps.assertContains((AssertionInfo)this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsAnyOf(Tuple2<KEY, VALUE> ... entries) {
        this.maps.assertContainsAnyOf((AssertionInfo)this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsAllEntriesOf(Iterable<Tuple2<KEY, VALUE>> other) {
        Tuple2[] entries = (Tuple2[])StreamSupport.stream(other.spliterator(), false).toArray(Tuple2[]::new);
        this.maps.assertContains((AssertionInfo)this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsEntry(KEY key, VALUE value) {
        this.maps.assertContains((AssertionInfo)this.info, (Map)this.actual, (Tuple2[])Arrays.array((Object[])new Tuple2[]{Tuple.of(key, value)}));
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContain(Tuple2<KEY, VALUE> ... entries) {
        this.maps.assertDoesNotContain((AssertionInfo)this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainEntry(KEY key, VALUE value) {
        this.maps.assertDoesNotContain((AssertionInfo)this.info, (Map)this.actual, (Tuple2[])Arrays.array((Object[])new Tuple2[]{Tuple.of(key, value)}));
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsOnly(Iterable<Tuple2<KEY, VALUE>> entries) {
        this.isNotNull();
        this.maps.assertContainsOnly((AssertionInfo)this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsExactly(Tuple2<? extends KEY, ? extends VALUE> ... entries) {
        this.maps.assertContainsExactly((AssertionInfo)this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsKey(KEY key) {
        return this.containsKeys(key);
    }

    public SELF containsKeys(KEY ... keys) {
        this.maps.assertContainsKeys((AssertionInfo)this.info, (Map)this.actual, keys);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsOnlyKeys(KEY ... keys) {
        this.maps.assertContainsOnlyKeys((AssertionInfo)this.info, (Map)this.actual, keys);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainKey(KEY key) {
        return this.doesNotContainKeys(key);
    }

    public SELF doesNotContainKeys(KEY ... keys) {
        this.maps.assertDoesNotContainKeys((AssertionInfo)this.info, (Map)this.actual, keys);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsValue(VALUE value) {
        this.maps.assertContainsValue((AssertionInfo)this.info, (Map)this.actual, value);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsValues(VALUE ... values) {
        this.maps.assertContainsValues((AssertionInfo)this.info, (Map)this.actual, values);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainValue(VALUE value) {
        this.maps.assertDoesNotContainValue((AssertionInfo)this.info, (Map)this.actual, value);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainValues(VALUE ... values) {
        this.maps.assertDoesNotContainValues((AssertionInfo)this.info, (Map)this.actual, values);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasSize(int expectedSize) {
        this.isNotNull();
        if (((Map)this.actual).size() != expectedSize) {
            this.throwAssertionError(ShouldHaveSize.shouldHaveSize((Object)this.actual, (int)((Map)this.actual).size(), (int)expectedSize));
        }
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasSizeGreaterThan(int boundary) {
        this.isNotNull();
        if (((Map)this.actual).size() <= boundary) {
            this.throwAssertionError(ShouldHaveSizeGreaterThan.shouldHaveSizeGreaterThan((Object)this.actual, (int)((Map)this.actual).size(), (int)boundary));
        }
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasSizeGreaterThanOrEqualTo(int boundary) {
        this.isNotNull();
        if (((Map)this.actual).size() < boundary) {
            this.throwAssertionError(ShouldHaveSizeGreaterThanOrEqualTo.shouldHaveSizeGreaterThanOrEqualTo((Object)this.actual, (int)((Map)this.actual).size(), (int)boundary));
        }
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasSizeLessThan(int boundary) {
        this.isNotNull();
        if (((Map)this.actual).size() >= boundary) {
            this.throwAssertionError(ShouldHaveSizeLessThan.shouldHaveSizeLessThan((Object)this.actual, (int)((Map)this.actual).size(), (int)boundary));
        }
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasSizeLessThanOrEqualTo(int boundary) {
        this.isNotNull();
        if (((Map)this.actual).size() > boundary) {
            this.throwAssertionError(ShouldHaveSizeLessThanOrEqualTo.shouldHaveSizeLessThanOrEqualTo((Object)this.actual, (int)((Map)this.actual).size(), (int)boundary));
        }
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasSizeBetween(int lowerBoundary, int higherBoundary) {
        this.isNotNull();
        if (((Map)this.actual).size() > higherBoundary || ((Map)this.actual).size() < lowerBoundary) {
            this.throwAssertionError(ShouldHaveSizeBetween.shouldHaveSizeBetween((Object)this.actual, (int)((Map)this.actual).size(), (int)lowerBoundary, (int)higherBoundary));
        }
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasSameSizeAs(Iterable<?> other) {
        this.isNotNull();
        Preconditions.checkNotNull(other, (String)"The other Iterable to compare actual size with should not be null");
        long expectedSize = IterableUtil.sizeOf(other);
        if ((long)((Map)this.actual).size() != expectedSize) {
            this.throwAssertionError(ShouldHaveSameSizeAs.shouldHaveSameSizeAs((Object)this.actual, other, (Object)((Map)this.actual).size(), (Object)expectedSize));
        }
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasSameSizeAs(Object array) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, array);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF usingElementComparator(Comparator<? super Tuple2<? extends KEY, ? extends VALUE>> customComparator) {
        this.elementComparisonStrategy = new ComparatorBasedComparisonStrategy(customComparator);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF usingDefaultElementComparator() {
        this.elementComparisonStrategy = StandardComparisonStrategy.instance();
        return (SELF)((AbstractMapAssert)this.myself);
    }
}

