/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.control.Either;
import org.assertj.core.error.BasicErrorMessageFactory;

class EitherShouldContain
extends BasicErrorMessageFactory {
    private static final String EXPECTING_TO_CONTAIN_ON_LEFT = "%nExpecting:%n  <%s>%nto contain:%n  <%s> on the [LEFT]%nbut did not.";
    private static final String EXPECTING_TO_CONTAIN_ON_RIGHT = "%nExpecting:%n  <%s>%nto contain:%n  <%s> on the [RIGHT]%nbut did not.";
    private static final String EXPECTING_TO_CONTAIN_SAME = "%nExpecting:%n  <%s>%nto contain the instance (i.e. compared with ==):%n  <%s>%nbut did not.";
    private static final String EXPECTING_TO_CONTAIN_BUT_IS_LEFT = "%nExpecting:%n  <%s>%nto contain on the [LEFT]:%n  <%s>%nbut was left sided.";
    private static final String EXPECTING_TO_CONTAIN_BUT_IS_RIGHT = "%nExpecting:%n  <%s>%nto contain on the [RIGHT]:%n  <%s>%nbut was right sided.";
    private static final String EXPECTING_TO_CONTAIN_ON_THE_LEFT = "%nExpecting:%n  <%s>%nto contain:%n  <%s> on the [LEFT]%nbut did not.";
    private static final String EXPECTING_TO_CONTAIN_ON_THE_RIGHT = "%nExpecting:%n  <%s>%nto contain:%n  <%s> on the [RIGHT]%nbut did not.";
    private static final String EXPECTING_ON_THE_LEFT = "%nExpecting:%n  <%s>%nto contain on the [LEFT]:%n  <%s>%nbut had <%s> on the [RIGHT].";
    private static final String EXPECTING_ON_THE_RIGHT = "%nExpecting:%n  <%s>%nto contain on the [RIGHT]:%n  <%s>%nbut had <%s> on the [LEFT].";

    private EitherShouldContain(String message, Object actual, Object expected) {
        super(message, new Object[]{actual, expected});
    }

    private EitherShouldContain(String format, Object ... arguments) {
        super(format, arguments);
    }

    static <LEFT, RIGHT> EitherShouldContain shouldContain(Either<LEFT, RIGHT> either, Object expected) {
        return either.isLeft() ? new EitherShouldContain("%nExpecting:%n  <%s>%nto contain:%n  <%s> on the [LEFT]%nbut did not.", (Object)either, expected) : new EitherShouldContain("%nExpecting:%n  <%s>%nto contain:%n  <%s> on the [RIGHT]%nbut did not.", (Object)either, expected);
    }

    static <LEFT, RIGHT> EitherShouldContain shouldContainOnOtherSide(Either<LEFT, RIGHT> either, Object expected) {
        return either.isRight() ? new EitherShouldContain(EXPECTING_ON_THE_LEFT, either, expected, either.get()) : new EitherShouldContain(EXPECTING_ON_THE_RIGHT, either, expected, either.getLeft());
    }

    static <LEFT, RIGHT> EitherShouldContain shouldContainOnRight(Either<LEFT, RIGHT> either, RIGHT expectedValue) {
        return either.isRight() ? new EitherShouldContain("%nExpecting:%n  <%s>%nto contain:%n  <%s> on the [RIGHT]%nbut did not.", (Object)either, (Object)expectedValue) : EitherShouldContain.shouldContainButIsLeft(either, expectedValue);
    }

    static <LEFT, RIGHT> EitherShouldContain shouldContainSameOnRight(Either<LEFT, RIGHT> either, RIGHT expectedValue) {
        return either.isRight() ? new EitherShouldContain(EXPECTING_TO_CONTAIN_SAME, (Object)either, (Object)expectedValue) : EitherShouldContain.shouldContainButIsLeft(either, expectedValue);
    }

    static <LEFT, RIGHT> EitherShouldContain shouldContainOnLeft(Either<LEFT, RIGHT> either, LEFT expectedValue) {
        return either.isLeft() ? new EitherShouldContain("%nExpecting:%n  <%s>%nto contain:%n  <%s> on the [LEFT]%nbut did not.", (Object)either, (Object)expectedValue) : EitherShouldContain.shouldContainButIsRight(either, expectedValue);
    }

    static <LEFT, RIGHT> EitherShouldContain shouldContainSameOnLeft(Either<LEFT, RIGHT> either, LEFT expectedValue) {
        return either.isLeft() ? new EitherShouldContain(EXPECTING_TO_CONTAIN_SAME, (Object)either, (Object)expectedValue) : EitherShouldContain.shouldContainButIsRight(either, expectedValue);
    }

    static EitherShouldContain shouldContainButIsLeft(Either<?, ?> either, Object expectedRightValue) {
        return new EitherShouldContain(EXPECTING_TO_CONTAIN_BUT_IS_LEFT, (Object)either, expectedRightValue);
    }

    static EitherShouldContain shouldContainButIsRight(Either<?, ?> either, Object expectedRightValue) {
        return new EitherShouldContain(EXPECTING_TO_CONTAIN_BUT_IS_RIGHT, (Object)either, expectedRightValue);
    }
}

