/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.control.Either;
import org.assertj.core.error.BasicErrorMessageFactory;

class EitherShouldContainInstanceOf
extends BasicErrorMessageFactory {
    private static final String EXPECTING_TO_CONTAIN_BUT_IS_LEFT = "%nExpecting:%n  <%s>%nto contain on right side:%n  <%s>%nbut was left-sided.";
    private static final String EXPECTING_TO_CONTAIN_BUT_IS_RIGHT = "%nExpecting:%n  <%s>%nto contain on left side:%n  <%s>%nbut was right-sided.";
    private static final String EXPECTING_TO_CONTAIN_DIFFERENT_INSTANCE = "%nExpecting:%n <%s>%nto contain a value that is an instance of:%n <%s>%nbut did contain an instance of:%n <%s>";

    private EitherShouldContainInstanceOf(String message) {
        super(message, new Object[0]);
    }

    static EitherShouldContainInstanceOf shouldContainOnRightInstanceOf(Object value, Class<?> expectedClazz) {
        Either either = (Either)value;
        if (either.isRight()) {
            return new EitherShouldContainInstanceOf(String.format(EXPECTING_TO_CONTAIN_DIFFERENT_INSTANCE, either.getClass().getSimpleName(), expectedClazz.getName(), either.get().getClass().getName()));
        }
        return new EitherShouldContainInstanceOf(String.format(EXPECTING_TO_CONTAIN_BUT_IS_LEFT, either.getClass().getSimpleName(), expectedClazz.getName()));
    }

    static EitherShouldContainInstanceOf shouldContainOnLeftInstanceOf(Object value, Class<?> expectedClazz) {
        Either either = (Either)value;
        if (either.isLeft()) {
            return new EitherShouldContainInstanceOf(String.format(EXPECTING_TO_CONTAIN_DIFFERENT_INSTANCE, either.getClass().getSimpleName(), expectedClazz.getName(), either.getLeft().getClass().getName()));
        }
        return new EitherShouldContainInstanceOf(String.format(EXPECTING_TO_CONTAIN_BUT_IS_RIGHT, either.getClass().getSimpleName(), expectedClazz.getName()));
    }
}

