/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.collection.HashSet;
import io.vavr.collection.Set;
import io.vavr.collection.SortedSet;
import java.util.Comparator;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ObjectAssertFactory;
import org.assertj.vavr.api.AbstractSetAssert;

public class SetAssert<ELEMENT>
extends AbstractSetAssert<SetAssert<ELEMENT>, Set<ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> {
    private final AssertFactory<ELEMENT, ObjectAssert<ELEMENT>> assertFactory = new ObjectAssertFactory();

    SetAssert(Set<ELEMENT> set) {
        super(set, SetAssert.class);
        Comparator comparator;
        if (set instanceof SortedSet && (comparator = ((SortedSet)set).comparator()) != null) {
            this.usingElementComparator(comparator);
        }
    }

    protected ObjectAssert<ELEMENT> toAssert(ELEMENT value, String description) {
        return (ObjectAssert)((ObjectAssert)this.assertFactory.createAssert(value)).as(description, new Object[0]);
    }

    protected SetAssert<ELEMENT> newAbstractIterableAssert(Iterable<? extends ELEMENT> iterable) {
        return new SetAssert<ELEMENT>(HashSet.ofAll(iterable));
    }
}

