/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.internal;

import io.vavr.Predicates;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import java.util.function.Predicate;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.error.ElementsShouldBe;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainAnyOf;
import org.assertj.core.error.ShouldContainExactly;
import org.assertj.core.error.ShouldContainKeys;
import org.assertj.core.error.ShouldContainOnly;
import org.assertj.core.error.ShouldContainOnlyKeys;
import org.assertj.core.error.ShouldContainValue;
import org.assertj.core.error.ShouldContainValues;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotContainKeys;
import org.assertj.core.error.ShouldNotContainValue;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.vavr.api.ShouldNotContainValues;

public final class Maps {
    private static final Maps INSTANCE = new Maps();
    private Failures failures = Failures.instance();
    private Conditions conditions = Conditions.instance();

    private Maps() {
    }

    public static Maps instance() {
        return INSTANCE;
    }

    public <K, V> void assertHasEntrySatisfying(AssertionInfo info, Map<K, V> actual, K key, Condition<? super V> valueCondition) {
        this.conditions.assertIsNotNull(valueCondition);
        this.assertContainsKeys(info, actual, key);
        Option value = actual.get(key);
        value.filter(arg_0 -> valueCondition.matches(arg_0)).getOrElseThrow(() -> this.failures.failure(info, ElementsShouldBe.elementsShouldBe((Object)actual, (Object)value, (Condition)valueCondition)));
    }

    public <K, V> void assertContainsAnyOf(AssertionInfo info, Map<K, V> actual, Tuple2<K, V>[] entries) {
        this.doCommonContainsCheck(info, actual, entries);
        if (actual.isEmpty() && entries.length == 0) {
            return;
        }
        CommonValidations.failIfEmptySinceActualIsNotEmpty((Object[])entries);
        for (Tuple2<K, V> entry : entries) {
            if (!this.containsEntry(actual, entry)) continue;
            return;
        }
        throw this.failures.failure(info, ShouldContainAnyOf.shouldContainAnyOf(actual, entries));
    }

    public <K, V> void assertContains(AssertionInfo info, Map<K, V> actual, Tuple2<K, V>[] entries) {
        this.doCommonContainsCheck(info, actual, entries);
        if (actual.isEmpty() && entries.length == 0) {
            return;
        }
        CommonValidations.failIfEmptySinceActualIsNotEmpty((Object[])entries);
        Set notFound = Array.of((Object[])entries).filter(Maps.entryNotPresentIn(actual)).toSet();
        if (Maps.isNotEmpty((Traversable)notFound)) {
            throw this.failures.failure(info, ShouldContain.shouldContain(actual, entries, (Object)notFound));
        }
    }

    public <K, V> void assertDoesNotContain(AssertionInfo info, Map<K, V> actual, Tuple2<K, V>[] entries) {
        Maps.failIfNullOrEmpty(entries);
        Maps.assertNotNull(info, actual);
        CommonValidations.failIfEmptySinceActualIsNotEmpty((Object[])entries);
        Set found = Array.of((Object[])entries).filter(arg_0 -> actual.contains(arg_0)).toSet();
        if (Maps.isNotEmpty((Traversable)found)) {
            throw this.failures.failure(info, ShouldNotContain.shouldNotContain(actual, entries, (Object)found));
        }
    }

    public <K, V> void assertContainsKeys(AssertionInfo info, Map<K, V> actual, K ... keys) {
        this.doCommonContainsCheck(info, actual, keys);
        if (this.doCommonEmptinessChecks(actual, keys)) {
            return;
        }
        HashSet expected = HashSet.of((Object[])keys);
        Set notFound = expected.filter(Maps.keyNotPresentIn(actual.keySet()));
        if (Maps.isNotEmpty((Traversable)notFound)) {
            throw this.failures.failure(info, ShouldContainKeys.shouldContainKeys(actual, (java.util.Set)notFound.toJavaSet()));
        }
    }

    public <K, V> void assertDoesNotContainKeys(AssertionInfo info, Map<K, V> actual, K ... keys) {
        this.doCommonContainsCheck(info, actual, keys);
        if (this.doCommonEmptinessChecks(actual, keys)) {
            return;
        }
        HashSet expected = HashSet.of((Object[])keys);
        Set found = expected.filter(Maps.keyPresentIn(actual.keySet()));
        if (Maps.isNotEmpty((Traversable)found)) {
            throw this.failures.failure(info, ShouldNotContainKeys.shouldNotContainKeys(actual, (java.util.Set)found.toJavaSet()));
        }
    }

    public <K, V> void assertContainsOnly(AssertionInfo info, Map<K, V> actual, Iterable<Tuple2<K, V>> entries) {
        Maps.assertNotNull(info, actual);
        Maps.failIfNull(entries);
        if (actual.isEmpty() && !entries.iterator().hasNext()) {
            return;
        }
        Maps.failIfEmpty(entries);
        HashMap expected = HashMap.ofEntries(entries);
        Map notExpected = actual.filter(Maps.entryNotPresentIn(expected));
        if (Maps.isNotEmpty((Traversable)notExpected)) {
            Map notFound = expected.filter(Maps.entryNotPresentIn(actual));
            throw this.failures.failure(info, ShouldContainOnly.shouldContainOnly(actual, (Object)expected, (Iterable)notFound, (Iterable)notExpected));
        }
    }

    public <K, V> void assertContainsExactly(AssertionInfo info, Map<K, V> actual, Tuple2<? extends K, ? extends V> ... entries) {
        this.doCommonContainsCheck(info, actual, entries);
        if (actual.isEmpty() && entries.length == 0) {
            return;
        }
        Maps.failIfEmpty(entries);
        this.assertHasSameSizeAs(info, actual, entries);
        Map expectedEntries = Maps.asLinkedMap(entries);
        Map notExpected = actual.filter(entry -> !expectedEntries.contains(entry));
        Map notFound = expectedEntries.filter(entry -> !actual.contains(entry));
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            int index = 0;
            for (Object keyFromActual : actual.keySet()) {
                if (Maps.areNotEqual(keyFromActual, entries[index]._1)) {
                    Tuple2 actualEntry = Tuple.of(keyFromActual, (Object)actual.get(keyFromActual).get());
                    throw this.failures.failure(info, ShouldContainExactly.elementsDifferAtIndex((Object)actualEntry, entries[index], (int)index));
                }
                ++index;
            }
            return;
        }
        throw this.failures.failure(info, ShouldContainExactly.shouldContainExactly(actual, (Iterable)List.of((Object[])entries), (Iterable)notFound, (Iterable)notExpected));
    }

    public <K, V> void assertContainsOnlyKeys(AssertionInfo info, Map<K, V> actual, K[] keys) {
        this.doCommonContainsCheck(info, actual, keys);
        if (this.doCommonEmptinessChecks(actual, keys)) {
            return;
        }
        HashSet expected = HashSet.of((Object[])keys);
        Set notExpected = actual.keySet().filter(Maps.keyNotPresentIn(expected));
        if (Maps.isNotEmpty((Traversable)notExpected)) {
            Set notFound = expected.filter(Maps.keyNotPresentIn(actual.keySet()));
            throw this.failures.failure(info, ShouldContainOnlyKeys.shouldContainOnlyKeys(actual, (Object)expected, (Object)notFound, (Iterable)notExpected));
        }
    }

    public <K, V> void assertContainsValues(AssertionInfo info, Map<K, V> actual, V ... values) {
        Maps.assertNotNull(info, actual);
        Preconditions.checkNotNull(values, (String)"The array of values to look for should not be null");
        if (actual.isEmpty() && values.length == 0) {
            return;
        }
        HashSet expected = HashSet.of((Object[])values);
        Set notFound = expected.filter(Maps.valueNotPresentIn(actual.values()));
        if (Maps.isNotEmpty((Traversable)notFound)) {
            throw this.failures.failure(info, ShouldContainValues.shouldContainValues(actual, (java.util.Set)notFound.toJavaSet()));
        }
    }

    public <K, V> void assertDoesNotContainValues(AssertionInfo info, Map<K, V> actual, V ... values) {
        Maps.assertNotNull(info, actual);
        Preconditions.checkNotNull(values, (String)"The array of values to look for should not be null");
        if (actual.isEmpty() && values.length == 0) {
            return;
        }
        HashSet expected = HashSet.of((Object[])values);
        Set found = expected.filter(Maps.valuePresentIn(actual.values()));
        if (Maps.isNotEmpty((Traversable)found)) {
            throw this.failures.failure(info, ShouldNotContainValues.shouldNotContainValues(actual, found.toJavaSet()));
        }
    }

    public <K, V> void assertContainsValue(AssertionInfo info, Map<K, V> actual, V value) {
        Maps.assertNotNull(info, actual);
        if (!actual.containsValue(value)) {
            throw this.failures.failure(info, ShouldContainValue.shouldContainValue(actual, value));
        }
    }

    public <K, V> void assertDoesNotContainValue(AssertionInfo info, Map<K, V> actual, V value) {
        Maps.assertNotNull(info, actual);
        if (actual.containsValue(value)) {
            throw this.failures.failure(info, ShouldNotContainValue.shouldNotContainValue(actual, value));
        }
    }

    public void assertHasSameSizeAs(AssertionInfo info, Map<?, ?> map, Object other) {
        Maps.assertNotNull(info, map);
        Arrays.assertIsArray((AssertionInfo)info, (Object)other);
        CommonValidations.hasSameSizeAsCheck((AssertionInfo)info, map, (Object)other, (int)map.size());
    }

    private <K, V> void doCommonContainsCheck(AssertionInfo info, Map<K, V> actual, Tuple2<? extends K, ? extends V>[] entries) {
        Maps.assertNotNull(info, actual);
        Maps.failIfNull(entries);
    }

    private <K, V> void doCommonContainsCheck(AssertionInfo info, Map<K, V> actual, K[] keys) {
        Maps.assertNotNull(info, actual);
        Maps.failIfNull(keys);
    }

    private <K, V> boolean doCommonEmptinessChecks(Map<K, V> actual, K[] keys) {
        if (actual.isEmpty() && keys.length == 0) {
            return true;
        }
        Maps.failIfEmpty(keys);
        return false;
    }

    private <K, V> boolean containsEntry(Map<K, V> actual, Tuple2<? extends K, ? extends V> entry) {
        Preconditions.checkNotNull(entry, (String)"Entries to look for should not be null");
        return actual.containsKey(entry._1) && org.assertj.core.util.Objects.areEqual((Object)actual.get(entry._1).get(), (Object)entry._2);
    }

    private static <K, V> void failIfEmpty(Tuple2<? extends K, ? extends V>[] entries) {
        Preconditions.checkArgument((entries.length > 0 ? 1 : 0) != 0, (String)"The array of entries to look for should not be empty", (Object[])new Object[0]);
    }

    private static <K, V> void failIfEmpty(Iterable<Tuple2<K, V>> entries) {
        Preconditions.checkArgument((boolean)entries.iterator().hasNext(), (String)"The entries to look for should not be empty", (Object[])new Object[0]);
    }

    private static <K> void failIfEmpty(K[] keys) {
        Preconditions.checkArgument((keys.length > 0 ? 1 : 0) != 0, (String)"The array of keys to look for should not be empty", (Object[])new Object[0]);
    }

    private static <K, V> void failIfNullOrEmpty(Tuple2<? extends K, ? extends V>[] entries) {
        Maps.failIfNull(entries);
        Maps.failIfEmpty(entries);
    }

    private static <K, V> void failIfNull(Tuple2<? extends K, ? extends V>[] entries) {
        Preconditions.checkNotNull(entries, (String)"The array of entries to look for should not be null");
    }

    private static <K, V> void failIfNull(Iterable<Tuple2<K, V>> entries) {
        Preconditions.checkNotNull(entries, (String)"The entries to look for should not be null");
    }

    private static <K> void failIfNull(K[] keys) {
        Preconditions.checkNotNull(keys, (String)"The array of keys to look for should not be null");
    }

    private static <K> boolean areNotEqual(K actualKey, K expectedKey) {
        return !org.assertj.core.util.Objects.areEqual(actualKey, expectedKey);
    }

    private static void assertNotNull(AssertionInfo info, Map<?, ?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private static <K, V> Map<K, V> asLinkedMap(Tuple2<? extends K, ? extends V>[] entries) {
        if (entries.length != Maps.nonNullEntries(entries).length()) {
            throw new NullPointerException("One of expected entries is null");
        }
        return LinkedHashMap.ofEntries(entries);
    }

    private static <K, V> Array<Tuple2<? extends K, ? extends V>> nonNullEntries(Tuple2<? extends K, ? extends V>[] entries) {
        return Array.of((Object[])entries).filter(java.util.Objects::nonNull);
    }

    private static <K, V> Predicate<Tuple2<K, V>> entryNotPresentIn(Map<K, V> map) {
        return tuple -> !map.contains(tuple);
    }

    private static <K> Predicate<K> keyNotPresentIn(Set<K> elements) {
        return Predicates.not(Maps.keyPresentIn(elements));
    }

    private static <K> Predicate<K> keyPresentIn(Set<K> elements) {
        return arg_0 -> elements.contains(arg_0);
    }

    private static <V> Predicate<V> valuePresentIn(Seq<V> elements) {
        return arg_0 -> elements.contains(arg_0);
    }

    private static <V> Predicate<V> valueNotPresentIn(Seq<V> elements) {
        return Predicates.not(Maps.valuePresentIn(elements));
    }

    private static boolean isNotEmpty(Traversable traversable) {
        return !traversable.isEmpty();
    }
}

