/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.io.IOException;
import java.net.InetAddress;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.RejectedExecutionException;
import org.asteriskjava.fastagi.AbstractAgiServer;
import org.asteriskjava.fastagi.AgiChannelFactory;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.AgiServer;
import org.asteriskjava.fastagi.ClassNameMappingStrategy;
import org.asteriskjava.fastagi.CompositeMappingStrategy;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.ResourceBundleMappingStrategy;
import org.asteriskjava.fastagi.StaticMappingStrategy;
import org.asteriskjava.fastagi.internal.AgiConnectionHandler;
import org.asteriskjava.fastagi.internal.DefaultAgiChannelFactory;
import org.asteriskjava.fastagi.internal.FastAgiConnectionHandler;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;
import org.asteriskjava.util.ServerSocketFacade;
import org.asteriskjava.util.SocketConnectionFacade;
import org.asteriskjava.util.internal.ServerSocketFacadeImpl;

public class DefaultAgiServer
extends AbstractAgiServer
implements AgiServer {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String DEFAULT_CONFIG_RESOURCE_BUNDLE_NAME = "fastagi";
    private static final int DEFAULT_BIND_PORT = 4573;
    private static final int BACKLOG = 200;
    private ServerSocketFacade serverSocket;
    private String configResourceBundleName = "fastagi";
    private int port = 4573;
    private InetAddress address = null;
    private int socketReadTimeout = 10800000;

    public DefaultAgiServer() {
        this(null, null);
    }

    public DefaultAgiServer(AgiChannelFactory agiChannelFactory) {
        this(null, null, agiChannelFactory);
    }

    public DefaultAgiServer(String configResourceBundleName) {
        this(configResourceBundleName, null);
    }

    public DefaultAgiServer(MappingStrategy mappingStrategy) {
        this(null, mappingStrategy);
    }

    public DefaultAgiServer(AgiScript agiScript) {
        this(null, new StaticMappingStrategy(agiScript));
    }

    public DefaultAgiServer(String configResourceBundleName, MappingStrategy mappingStrategy) {
        this(configResourceBundleName, mappingStrategy, new DefaultAgiChannelFactory());
    }

    public DefaultAgiServer(String configResourceBundleName, MappingStrategy mappingStrategy, AgiChannelFactory agiChannelFactory) {
        super(agiChannelFactory);
        if (mappingStrategy == null) {
            CompositeMappingStrategy compositeMappingStrategy = new CompositeMappingStrategy();
            compositeMappingStrategy.addStrategy(new ResourceBundleMappingStrategy());
            compositeMappingStrategy.addStrategy(new ClassNameMappingStrategy());
            if (ReflectionUtil.isClassAvailable("javax.script.ScriptEngineManager")) {
                MappingStrategy scriptEngineMappingStrategy = (MappingStrategy)ReflectionUtil.newInstance("org.asteriskjava.fastagi.ScriptEngineMappingStrategy");
                if (scriptEngineMappingStrategy != null) {
                    compositeMappingStrategy.addStrategy(scriptEngineMappingStrategy);
                }
            } else {
                this.logger.warn("ScriptEngine support disabled: It is only availble when running at least Java 6");
            }
            this.setMappingStrategy(compositeMappingStrategy);
        } else {
            this.setMappingStrategy(mappingStrategy);
        }
        if (configResourceBundleName != null) {
            this.configResourceBundleName = configResourceBundleName;
        }
        this.loadConfig();
    }

    @Deprecated
    public void setBindPort(int bindPort) {
        this.port = bindPort;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    private void loadConfig() {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle(this.configResourceBundleName);
        }
        catch (MissingResourceException e) {
            return;
        }
        try {
            String portString;
            try {
                portString = resourceBundle.getString("port");
            }
            catch (MissingResourceException e) {
                portString = resourceBundle.getString("bindPort");
            }
            this.port = Integer.parseInt(portString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setPoolSize(Integer.parseInt(resourceBundle.getString("poolSize")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setMaximumPoolSize(Integer.parseInt(resourceBundle.getString("maximumPoolSize")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setSocketReadTimeout(int socketReadTimeout) {
        this.socketReadTimeout = socketReadTimeout;
    }

    protected ServerSocketFacade createServerSocket() throws IOException {
        ServerSocketFacadeImpl serverSocketFacade = new ServerSocketFacadeImpl(this.port, 200, this.address);
        serverSocketFacade.setSocketReadTimeout(this.socketReadTimeout);
        return serverSocketFacade;
    }

    @Override
    public void startup() throws IOException, IllegalStateException {
        try {
            this.serverSocket = this.createServerSocket();
        }
        catch (IOException e) {
            this.logger.error("Unable start AgiServer: cannot to bind to *:" + this.port + ".", e);
            throw e;
        }
        this.logger.info("Listening on *:" + this.port + ".");
        while (true) {
            SocketConnectionFacade socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException e) {
                if (this.isDie()) break;
                this.handleException("IOException while waiting for connections.", e);
                continue;
            }
            this.logger.debug("Received connection from " + socket.getRemoteAddress());
            FastAgiConnectionHandler connectionHandler = new FastAgiConnectionHandler(this.getMappingStrategy(), socket, this.getAgiChannelFactory());
            try {
                this.execute(connectionHandler);
            }
            catch (RejectedExecutionException e) {
                this.logger.warn("Execution was rejected by pool. Try to increase the pool size.");
                ((AgiConnectionHandler)connectionHandler).release();
            }
        }
        this.logger.info("AgiServer shut down.");
    }

    @Deprecated
    public void run() {
        try {
            this.startup();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void shutdown() throws IllegalStateException {
        super.shutdown();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                this.logger.warn("IOException while closing server socket.", e);
            }
        }
    }

    @Override
    protected void finalize() throws Throwable {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.finalize();
    }

    @Deprecated
    public static void main(String[] args) throws Exception {
        DefaultAgiServer server = new DefaultAgiServer();
        server.startup();
    }
}

