/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import com.google.common.util.concurrent.RateLimiter;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.internal.Dispatcher;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.pbx.util.LogTime;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AsyncEventPump
implements Dispatcher,
Runnable {
    private final Log logger = LogFactory.getLog(AsyncEventPump.class);
    private static final long MAX_SAFE_EVENT_AGE = 500L;
    private final LinkedBlockingQueue<EventWrapper> queue = new LinkedBlockingQueue(20000);
    private final Dispatcher dispatcher;
    private volatile boolean stop = false;
    private final WeakReference<Object> owner;
    private final Thread thread;
    private volatile boolean terminated = false;
    private final String name;

    AsyncEventPump(Object owner, Dispatcher dispatcher, String threadName) {
        this.dispatcher = dispatcher;
        this.owner = new WeakReference<Object>(owner);
        this.name = threadName + ":AsyncEventPump";
        this.thread = new Thread((Runnable)this, this.name);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.logger.info("starting");
            RateLimiter rateLimiter = RateLimiter.create((double)2.0);
            while (!this.stop || !this.queue.isEmpty()) {
                try {
                    EventWrapper wrapper = this.queue.poll(1L, TimeUnit.MINUTES);
                    if (wrapper != null) {
                        if (wrapper.timer.timeTaken() > 500L && rateLimiter.tryAcquire()) {
                            this.logger.warn("The following message will only appear once per second!\nEvent dispatched " + wrapper.timer.timeTaken() + " MS after arriving, your ManagerEvent handlers are too slow!\nYou should also check for Garbage Collection issues.\nThere are " + this.queue.size() + " events waiting to be processed in the queue.\nEvent was " + wrapper.getPayloadAsString());
                        }
                        int requiredHandlingTime = (int)(500L / (long)Math.max(1, this.queue.size()));
                        if (wrapper.response != null) {
                            this.dispatcher.dispatchResponse(wrapper.response, requiredHandlingTime);
                            continue;
                        }
                        if (wrapper.event != null) {
                            this.dispatcher.dispatchEvent(wrapper.event, requiredHandlingTime);
                            continue;
                        }
                        if (wrapper.poison == null) continue;
                        wrapper.poison.countDown();
                        continue;
                    }
                    if (this.owner.get() != null) continue;
                    this.stop = true;
                    this.logger.error("The owner has been garbage collected!");
                }
                catch (InterruptedException e) {
                    this.logger.error(e);
                }
                catch (Exception e) {
                    this.logger.error(e, e);
                }
            }
        }
        finally {
            this.terminated = true;
            this.logger.warn("AsyncEventPump has exited");
        }
    }

    @Override
    public void stop() {
        this.logger.info(this.name + " Requesting AsyncEventPump to stop");
        if (this.terminated) {
            this.logger.warn(this.name + " AsyncEventPump is already stopped");
            if (!this.queue.isEmpty()) {
                this.logger.error(this.name + " There are unprocessed events in the queue");
            }
            return;
        }
        EventWrapper poisonWrapper = new EventWrapper();
        this.queue.add(poisonWrapper);
        this.stop = true;
        LogTime timer = new LogTime();
        try {
            int queueSize = this.queue.size();
            while (!poisonWrapper.poison.await(5L, TimeUnit.SECONDS)) {
                if (queueSize == this.queue.size()) {
                    if (!this.terminated) {
                        Locker.dumpThread(this.thread, this.name + " AsyncEventPump thread is blocked here...");
                    }
                    throw new RuntimeException(this.name + " Failed to shutdown AsyncEventPump cleanly!");
                }
                queueSize = this.queue.size();
                this.logger.info(this.name + " Waiting for AsyncEventPump to Stop... ");
                if (timer.timeTaken() <= 60000L) continue;
                throw new RuntimeException(this.name + " Failed to shutdown AsyncEventPump cleanly!");
            }
        }
        catch (InterruptedException e1) {
            this.logger.error(this.name + e1.getMessage());
        }
    }

    @Override
    public void dispatchResponse(ManagerResponse response, Integer requiredHandlingTime) {
        if (!this.queue.offer(new EventWrapper(response))) {
            this.logger.error(this.name + " Event queue is full, not processing ManagerResponse " + response);
        }
    }

    @Override
    public void dispatchEvent(ManagerEvent event, Integer requiredHandlingTime) {
        if (!this.queue.offer(new EventWrapper(event))) {
            this.logger.error(this.name + " Event queue is full, not processing ManagerEvent " + event);
        }
    }

    private static class EventWrapper {
        LogTime timer = new LogTime();
        ManagerResponse response;
        ManagerEvent event;
        CountDownLatch poison;

        EventWrapper() {
            this.poison = new CountDownLatch(1);
        }

        public String getPayloadAsString() {
            if (this.response != null) {
                return this.response.toString();
            }
            if (this.event != null) {
                return this.event.toString();
            }
            return "Poison";
        }

        EventWrapper(ManagerResponse response) {
            this.response = response;
        }

        EventWrapper(ManagerEvent event) {
            this.event = event;
        }
    }
}

