/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.classpath;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.File;

class ClasspathCacheElement {
    private final File element;
    private final ImmutableSet<String> classes;
    private final ImmutableSet<String> resources;

    public static Builder builder(File element) {
        return new Builder(element);
    }

    private ClasspathCacheElement(File element, ImmutableSet<String> classes, ImmutableSet<String> resources) {
        this.element = element;
        this.classes = classes;
        this.resources = resources;
    }

    void putClasses(Multimap<String, File> classMap, Predicate<String> excludePredicate) {
        for (String className : Collections2.filter(this.classes, (Predicate)Predicates.not(excludePredicate))) {
            classMap.put((Object)className, (Object)this.element);
        }
    }

    void putResources(Multimap<String, File> resourceMap, Predicate<String> excludePredicate) {
        for (String resource : Collections2.filter(this.resources, (Predicate)Predicates.not(excludePredicate))) {
            resourceMap.put((Object)resource, (Object)this.element);
        }
    }

    static class Builder {
        private final File element;
        private final ImmutableSet.Builder<String> classBuilder = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> resourcesBuilder = ImmutableSet.builder();

        private Builder(File element) {
            this.element = element;
        }

        void addClass(String className) {
            this.classBuilder.add((Object)className);
        }

        void addResource(String resource) {
            this.resourcesBuilder.add((Object)resource);
        }

        ClasspathCacheElement build() {
            return new ClasspathCacheElement(this.element, this.classBuilder.build(), this.resourcesBuilder.build());
        }
    }
}

