/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.classpath;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

class PackageNameHolder {
    private final ImmutableList<String> packages;
    private final String packageName;
    private final String path;

    PackageNameHolder(List<String> packages) {
        this.packages = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(packages, (Object)"packages is null")));
        this.packageName = Joiner.on((char)'.').join(packages);
        this.path = Joiner.on((char)'/').join(packages);
    }

    PackageNameHolder() {
        this.packages = ImmutableList.of();
        this.packageName = "";
        this.path = "";
    }

    PackageNameHolder getChildPackage(String packageName) {
        Preconditions.checkNotNull((Object)packageName, (Object)"packageName is null");
        Preconditions.checkArgument((packageName.length() > 0 ? 1 : 0) != 0, (Object)"package name must have at least one character");
        return new PackageNameHolder((List<String>)ImmutableList.builder().addAll(this.packages).add((Object)packageName).build());
    }

    String getQualifiedName(String className) {
        Preconditions.checkNotNull((Object)className, (Object)"className is null");
        return this.packages.isEmpty() ? className : this.packageName + "." + className;
    }

    String getQualifiedPath(String className) {
        Preconditions.checkNotNull((Object)className, (Object)"className is null");
        return this.packages.isEmpty() ? className : this.path + "/" + className;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.packageName + ")";
    }
}

