/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.jna.win;

import com.github.markusbernhardt.proxy.jna.win.WinHttp;
import com.github.markusbernhardt.proxy.util.Logger;
import com.sun.jna.LastErrorException;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.PointerByReference;

public class WinHttpHelpers {
    private static final int ERROR_WINHTTP_AUTODETECTION_FAILED = 12180;

    private WinHttpHelpers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectAutoProxyConfigUrl(WinDef.DWORD dwAutoDetectFlags) {
        PointerByReference ppwszAutoConfigUrl = new PointerByReference();
        boolean result = false;
        try {
            result = WinHttp.INSTANCE.WinHttpDetectAutoProxyConfigUrl(dwAutoDetectFlags, ppwszAutoConfigUrl);
            if (result) {
                Pointer h = ppwszAutoConfigUrl.getValue();
                String string = h == null ? null : h.getWideString(0L);
                return string;
            }
            String h = null;
            return h;
        }
        catch (LastErrorException ex) {
            Logger.log(WinHttpHelpers.class, Logger.LogLevel.ERROR, "Windows function WinHttpDetectAutoProxyConfigUrl returned error : {}", ex.getErrorCode());
            if (ex.getErrorCode() == 12180) {
                String string = null;
                return string;
            }
            Logger.log(WinHttpHelpers.class, Logger.LogLevel.ERROR, "Windows function WinHttpDetectAutoProxyConfigUrl returned error : {}", ex.getMessage());
            String string = null;
            return string;
        }
        finally {
            WinHttpHelpers.freeGlobalMemory(ppwszAutoConfigUrl.getValue());
        }
    }

    public static void freeGlobalMemory(Pointer p) {
        Pointer free;
        if (p != null && (free = Kernel32.INSTANCE.GlobalFree(p)) != null) {
            Logger.log(WinHttpHelpers.class, Logger.LogLevel.ERROR, "Windows function GlobalFree failed while freeing memory", new Object[0]);
        }
    }

    public static String getAndFreeGlobalString(WTypes.LPWSTR h) {
        if (h == null || h.getPointer() == null) {
            return null;
        }
        try {
            String string = h.getValue();
            return string;
        }
        finally {
            WinHttpHelpers.freeGlobalMemory(h.getPointer());
            h.setPointer(null);
        }
    }

    private String sanitizeUrl(String urlStr) {
        String u = urlStr.trim();
        int pos = u.indexOf(10);
        if (pos == 0) {
            return "";
        }
        if (pos > 0) {
            return u.substring(0, pos);
        }
        return u;
    }
}

