/*
 * Copyright (C) 2014 BigTesting.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.bigtesting.interpolatd.core;

import org.bigtesting.interpolatd.EnclosureClosingHandler;
import org.bigtesting.interpolatd.EnclosureOpeningHandler;

/**
 * 
 * @author Luis Antunes
 */
public class EnclosureOpeningHandlerImpl<T> implements EnclosureOpeningHandler<T> {

    private final String opening;
    
    private final String characterClass;
    
    private EnclosureClosingHandlerImpl<T> closingHandler;
    
    public EnclosureOpeningHandlerImpl(String opening, String characterClass) {
        
        this.opening = opening;
        this.characterClass = characterClass;
    }

    public EnclosureClosingHandler<T> and(String closing) {
        
        EnclosureClosingHandlerImpl<T> closingHandler = 
                new EnclosureClosingHandlerImpl<T>(opening, closing, characterClass);
        this.closingHandler = closingHandler;
        return closingHandler;
    }
    
    public EnclosureClosingHandlerImpl<T> getEnclosureClosingHandler() {
        
        return closingHandler;
    }
}
