/*
 * Decompiled with CFR 0.152.
 */
package org.bigtesting.interpolatd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bigtesting.interpolatd.InterpolationHandler;
import org.bigtesting.interpolatd.core.EscapeHandler;
import org.bigtesting.interpolatd.core.Interpolating;
import org.bigtesting.interpolatd.core.InterpolationHandlerImpl;
import org.bigtesting.interpolatd.core.Substitution;

public class Interpolator<T> {
    private final List<Interpolating<T>> interpolating = new ArrayList<Interpolating<T>>();

    public InterpolationHandler<T> when() {
        InterpolationHandlerImpl handler = new InterpolationHandlerImpl();
        this.interpolating.add(handler);
        return handler;
    }

    public InterpolationHandler<T> when(String characterClass) {
        InterpolationHandlerImpl handler = new InterpolationHandlerImpl(characterClass);
        this.interpolating.add(handler);
        return handler;
    }

    public void escapeWith(String escape) {
        this.interpolating.add(new EscapeHandler(escape));
    }

    public String interpolate(String toInterpolate, T arg) {
        ArrayList<Substitution> substitutions = new ArrayList<Substitution>();
        for (Interpolating<T> handler : this.interpolating) {
            substitutions.addAll(handler.interpolate(toInterpolate, arg));
        }
        Collections.sort(substitutions);
        StringBuilder sb = new StringBuilder(toInterpolate);
        int diff = 0;
        int lastEnd = 0;
        Substitution lastEscape = null;
        for (int i = 0; i < substitutions.size(); ++i) {
            Substitution sub = (Substitution)substitutions.get(i);
            if (sub.start() < lastEnd) continue;
            if (sub.isEscape()) {
                if (lastEscape != null && sub.isAfter(lastEscape) || !this.isActualEscape(sub, substitutions, i)) continue;
                lastEscape = sub;
            } else if (lastEscape != null && sub.isAfter(lastEscape)) {
                lastEnd = sub.end();
                continue;
            }
            if (sub.value() == null) continue;
            sb.replace(sub.start() - diff, sub.end() - diff, sub.value());
            diff += sub.found().length() - sub.value().length();
            lastEnd = sub.end();
        }
        return sb.toString();
    }

    private boolean isActualEscape(Substitution esc, List<Substitution> substitutions, int index) {
        if (!this.hasNext(substitutions, index)) {
            return false;
        }
        Substitution nextSub = this.getNext(substitutions, index);
        if (!nextSub.isAfter(esc)) {
            return false;
        }
        if (!nextSub.isEscape()) {
            return true;
        }
        return this.isActualEscape(nextSub, substitutions, ++index);
    }

    private boolean hasNext(List<Substitution> substitutions, int currentIndex) {
        return currentIndex + 1 < substitutions.size();
    }

    private Substitution getNext(List<Substitution> substitutions, int currentIndex) {
        return substitutions.get(currentIndex + 1);
    }
}

